/*
 * Decompiled with CFR 0.152.
 */
package feign.examples;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import feign.Feign;
import feign.Logger;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;

public class GitHubExample {
    public static void main(String ... args) {
        GitHub github = (GitHub)Feign.builder().decoder((Decoder)new GsonDecoder()).logger((Logger)new Logger.ErrorLogger()).logLevel(Logger.Level.BASIC).target(GitHub.class, "https://api.github.com");
        System.out.println("Let's fetch and print a list of the contributors to this library.");
        List<Contributor> contributors = github.contributors("netflix", "feign");
        for (Contributor contributor : contributors) {
            System.out.println(contributor.login + " (" + contributor.contributions + ")");
        }
    }

    static class GsonDecoder
    implements Decoder {
        private final Gson gson = new Gson();

        GsonDecoder() {
        }

        public Object decode(Response response, Type type) throws IOException {
            if (Void.TYPE == type || response.body() == null) {
                return null;
            }
            Reader reader = response.body().asReader(Util.UTF_8);
            try {
                Object object = this.gson.fromJson(reader, type);
                return object;
            }
            catch (JsonIOException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)IOException.class.cast(e.getCause());
                }
                throw e;
            }
            finally {
                Util.ensureClosed((Closeable)reader);
            }
        }
    }

    static class Contributor {
        String login;
        int contributions;

        Contributor() {
        }
    }

    static interface GitHub {
        @RequestLine(value="GET /repos/{owner}/{repo}/contributors")
        public List<Contributor> contributors(@Param(value="owner") String var1, @Param(value="repo") String var2);
    }
}

