/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.codec.ErrorDecoder;
import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class RetryAfterDecoderTest {
    private ErrorDecoder.RetryAfterDecoder decoder = new ErrorDecoder.RetryAfterDecoder(ErrorDecoder.RetryAfterDecoder.RFC822_FORMAT){

        protected long currentTimeMillis() {
            try {
                return RFC822_FORMAT.parse("Sat, 1 Jan 2000 00:00:00 GMT").getTime();
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    };

    @Test
    public void malformDateFailsGracefully() {
        Assert.assertFalse((this.decoder.apply("Fri, 31 Dec 1999 23:59:59 ZBW") != null ? 1 : 0) != 0);
    }

    @Test
    public void rfc822Parses() throws ParseException {
        Assert.assertEquals((Object)ErrorDecoder.RetryAfterDecoder.RFC822_FORMAT.parse("Fri, 31 Dec 1999 23:59:59 GMT"), (Object)this.decoder.apply("Fri, 31 Dec 1999 23:59:59 GMT"));
    }

    @Test
    public void relativeSecondsParses() throws ParseException {
        Assert.assertEquals((Object)ErrorDecoder.RetryAfterDecoder.RFC822_FORMAT.parse("Sun, 2 Jan 2000 00:00:00 GMT"), (Object)this.decoder.apply("86400"));
    }

    @Test
    public void relativeSecondsParseDecimalIntegers() throws ParseException {
        Assert.assertEquals((Object)ErrorDecoder.RetryAfterDecoder.RFC822_FORMAT.parse("Sun, 2 Jan 2000 00:00:00 GMT"), (Object)this.decoder.apply("86400.0"));
    }
}

