/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.FeignException;
import feign.Request;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultErrorDecoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private ErrorDecoder errorDecoder = new ErrorDecoder.Default();
    private Map<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();

    @Test
    public void throwsFeignException() throws Throwable {
        this.thrown.expect(FeignException.class);
        this.thrown.expectMessage("[500 Internal server error] during [GET] to [/api] [Service#foo()]: []");
        Response response = Response.builder().status(500).reason("Internal server error").request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(this.headers).build();
        throw this.errorDecoder.decode("Service#foo()", response);
    }

    @Test
    public void throwsFeignExceptionIncludingBody() throws Throwable {
        Response response = Response.builder().status(500).reason("Internal server error").request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(this.headers).body("hello world", Util.UTF_8).build();
        try {
            throw this.errorDecoder.decode("Service#foo()", response);
        }
        catch (FeignException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("[500 Internal server error] during [GET] to [/api] [Service#foo()]: [hello world]");
            Assertions.assertThat((String)e.contentUTF8()).isEqualTo("hello world");
            return;
        }
    }

    @Test
    public void throwsFeignExceptionIncludingLongBody() throws Throwable {
        String actualBody = this.repeatString("hello world ", 200);
        Response response = Response.builder().status(500).reason("Internal server error").request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(this.headers).body(actualBody, Util.UTF_8).build();
        String expectedBody = this.repeatString("hello world ", 16) + "hello wo... (2400 bytes)";
        try {
            throw this.errorDecoder.decode("Service#foo()", response);
        }
        catch (FeignException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("[500 Internal server error] during [GET] to [/api] [Service#foo()]: [" + expectedBody + "]");
            Assertions.assertThat((String)e.contentUTF8()).isEqualTo(actualBody);
            return;
        }
    }

    private String repeatString(String string, int times) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            result.append(string);
        }
        return result.toString();
    }

    @Test
    public void testFeignExceptionIncludesStatus() {
        Response response = Response.builder().status(400).reason("Bad request").request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(this.headers).build();
        Exception exception = this.errorDecoder.decode("Service#foo()", response);
        Assertions.assertThat((Throwable)exception).isInstanceOf(FeignException.class);
        Assertions.assertThat((int)((FeignException)((Object)exception)).status()).isEqualTo(400);
    }

    @Test
    public void retryAfterHeaderThrowsRetryableException() throws Throwable {
        this.thrown.expect(FeignException.class);
        this.thrown.expectMessage("[503 Service Unavailable] during [GET] to [/api] [Service#foo()]: []");
        this.headers.put("Retry-After", Collections.singletonList("Sat, 1 Jan 2000 00:00:00 GMT"));
        Response response = Response.builder().status(503).reason("Service Unavailable").request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(this.headers).build();
        throw this.errorDecoder.decode("Service#foo()", response);
    }
}

