/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.FeignException;
import feign.Request;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DefaultErrorDecoderHttpErrorTest {
    @Parameterized.Parameter
    public int httpStatus;
    @Parameterized.Parameter(value=1)
    public Class expectedExceptionClass;
    @Parameterized.Parameter(value=2)
    public String expectedMessage;
    private ErrorDecoder errorDecoder = new ErrorDecoder.Default();
    private Map<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();

    @Parameterized.Parameters(name="error: [{0}], exception: [{1}]")
    public static Object[][] errorCodes() {
        return new Object[][]{{400, FeignException.BadRequest.class, "[400 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {401, FeignException.Unauthorized.class, "[401 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {403, FeignException.Forbidden.class, "[403 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {404, FeignException.NotFound.class, "[404 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {405, FeignException.MethodNotAllowed.class, "[405 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {406, FeignException.NotAcceptable.class, "[406 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {409, FeignException.Conflict.class, "[409 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {429, FeignException.TooManyRequests.class, "[429 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {422, FeignException.UnprocessableEntity.class, "[422 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {450, FeignException.FeignClientException.class, "[450 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {500, FeignException.InternalServerError.class, "[500 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {501, FeignException.NotImplemented.class, "[501 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {502, FeignException.BadGateway.class, "[502 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {503, FeignException.ServiceUnavailable.class, "[503 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {504, FeignException.GatewayTimeout.class, "[504 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {599, FeignException.FeignServerException.class, "[599 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}, {599, FeignException.class, "[599 anything] during [GET] to [http://example.com/api] [Service#foo()]: [response body]"}};
    }

    @Test
    public void testExceptionIsHttpSpecific() throws Throwable {
        Response response = Response.builder().status(this.httpStatus).reason("anything").request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"http://example.com/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(this.headers).body("response body", Util.UTF_8).build();
        Exception exception = this.errorDecoder.decode("Service#foo()", response);
        Assertions.assertThat((Throwable)exception).isInstanceOf(this.expectedExceptionClass);
        Assertions.assertThat((int)((FeignException)exception).status()).isEqualTo(this.httpStatus);
        Assertions.assertThat((String)exception.getMessage()).isEqualTo(this.expectedMessage);
    }
}

