/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.util.Arrays;
import java.util.Date;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultEncoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final Encoder encoder = new Encoder.Default();

    @Test
    public void testEncodesStrings() throws Exception {
        String content = "This is my content";
        RequestTemplate template = new RequestTemplate();
        this.encoder.encode((Object)content, String.class, template);
        Assert.assertEquals((Object)content, (Object)new String(template.body(), Util.UTF_8));
    }

    @Test
    public void testEncodesByteArray() throws Exception {
        byte[] content = new byte[]{12, 34, 56};
        RequestTemplate template = new RequestTemplate();
        this.encoder.encode((Object)content, byte[].class, template);
        Assert.assertTrue((boolean)Arrays.equals(content, template.body()));
    }

    @Test
    public void testRefusesToEncodeOtherTypes() throws Exception {
        this.thrown.expect(EncodeException.class);
        this.thrown.expectMessage("is not a type supported by this encoder.");
        this.encoder.encode((Object)new Date(), Date.class, new RequestTemplate());
    }
}

