/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.Request;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;

public class DefaultDecoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final Decoder decoder = new Decoder.Default();

    @Test
    public void testDecodesToString() throws Exception {
        Response response = this.knownResponse();
        Object decodedObject = this.decoder.decode(response, String.class);
        Assert.assertEquals(String.class, decodedObject.getClass());
        Assert.assertEquals((Object)"response body", (Object)decodedObject.toString());
    }

    @Test
    public void testDecodesToByteArray() throws Exception {
        Response response = this.knownResponse();
        Object decodedObject = this.decoder.decode(response, byte[].class);
        Assert.assertEquals(byte[].class, decodedObject.getClass());
        Assert.assertEquals((Object)"response body", (Object)new String((byte[])decodedObject, Util.UTF_8));
    }

    @Test
    public void testDecodesNullBodyToNull() throws Exception {
        Assert.assertNull((Object)this.decoder.decode(this.nullBodyResponse(), Document.class));
    }

    @Test
    public void testRefusesToDecodeOtherTypes() throws Exception {
        this.thrown.expect(DecodeException.class);
        this.thrown.expectMessage(" is not a type supported by this decoder.");
        this.decoder.decode(this.knownResponse(), Document.class);
    }

    private Response knownResponse() {
        String content = "response body";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(Util.UTF_8));
        HashMap<String, Set<String>> headers = new HashMap<String, Set<String>>();
        headers.put("Content-Type", Collections.singleton("text/plain"));
        return Response.builder().status(200).reason("OK").headers(headers).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body((InputStream)inputStream, Integer.valueOf(content.length())).build();
    }

    private Response nullBodyResponse() {
        return Response.builder().status(200).reason("OK").headers(Collections.emptyMap()).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).build();
    }
}

