/*
 * Decompiled with CFR 0.152.
 */
package feign.client;

import feign.Client;
import feign.Feign;
import feign.RetryableException;
import feign.client.AbstractClientTest;
import feign.client.TrustingSSLSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DefaultClientTest
extends AbstractClientTest {
    protected Client disableHostnameVerification = new Client.Default(TrustingSSLSocketFactory.get(), new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    });
    private final SocketAddress proxyAddress = new InetSocketAddress("proxy.example.com", 8080);

    @Override
    public Feign.Builder newBuilder() {
        return Feign.builder().client((Client)new Client.Default(TrustingSSLSocketFactory.get(), null, false));
    }

    @Test
    public void retriesFailedHandshake() throws IOException, InterruptedException {
        this.server.useHttps(TrustingSSLSocketFactory.get("localhost"), false);
        this.server.enqueue(new MockResponse().setSocketPolicy(SocketPolicy.FAIL_HANDSHAKE));
        this.server.enqueue(new MockResponse());
        AbstractClientTest.TestInterface api = (AbstractClientTest.TestInterface)this.newBuilder().target(AbstractClientTest.TestInterface.class, "https://localhost:" + this.server.getPort());
        api.post("foo");
        Assert.assertEquals((long)2L, (long)this.server.getRequestCount());
    }

    @Test
    public void canOverrideSSLSocketFactory() throws IOException, InterruptedException {
        this.server.useHttps(TrustingSSLSocketFactory.get("localhost"), false);
        this.server.enqueue(new MockResponse());
        AbstractClientTest.TestInterface api = (AbstractClientTest.TestInterface)this.newBuilder().target(AbstractClientTest.TestInterface.class, "https://localhost:" + this.server.getPort());
        api.post("foo");
    }

    @Override
    @Test
    public void testPatch() throws Exception {
        this.thrown.expect(RetryableException.class);
        this.thrown.expectCause(Is.isA(ProtocolException.class));
        super.testPatch();
    }

    @Override
    @Test
    public void noResponseBodyForPatch() {
        this.thrown.expect(RetryableException.class);
        this.thrown.expectCause(Is.isA(ProtocolException.class));
        super.noResponseBodyForPatch();
    }

    @Test
    public void canOverrideHostnameVerifier() throws IOException, InterruptedException {
        this.server.useHttps(TrustingSSLSocketFactory.get("bad.example.com"), false);
        this.server.enqueue(new MockResponse());
        AbstractClientTest.TestInterface api = (AbstractClientTest.TestInterface)Feign.builder().client(this.disableHostnameVerification).target(AbstractClientTest.TestInterface.class, "https://localhost:" + this.server.getPort());
        api.post("foo");
    }

    @Test
    public void canCreateWithImplicitOrNoCredentials() throws Exception {
        Client.Proxied proxied = new Client.Proxied(TrustingSSLSocketFactory.get(), null, new Proxy(Proxy.Type.HTTP, this.proxyAddress));
        Assertions.assertThat((Object)proxied).isNotNull();
        Assertions.assertThat((String)proxied.getCredentials()).isNullOrEmpty();
        HttpURLConnection connection = proxied.getConnection(new URL("http://www.example.com"));
        ((ObjectAssert)Assertions.assertThat((Object)connection).isNotNull()).isInstanceOf(HttpURLConnection.class);
    }

    @Test
    public void canCreateWithExplicitCredentials() throws Exception {
        Client.Proxied proxied = new Client.Proxied(TrustingSSLSocketFactory.get(), null, new Proxy(Proxy.Type.HTTP, this.proxyAddress), "user", "password");
        Assertions.assertThat((Object)proxied).isNotNull();
        Assertions.assertThat((String)proxied.getCredentials()).isNotBlank();
        HttpURLConnection connection = proxied.getConnection(new URL("http://www.example.com"));
        ((ObjectAssert)Assertions.assertThat((Object)connection).isNotNull()).isInstanceOf(HttpURLConnection.class);
    }

    @Test
    public void canSupportGzip() throws Exception {
        String responseData = "Compressed Data";
        this.server.enqueue(new MockResponse().addHeader("Content-Encoding", (Object)"gzip").setBody(new Buffer().write(this.compress("Compressed Data"))));
        AbstractClientTest.TestInterface api = (AbstractClientTest.TestInterface)this.newBuilder().target(AbstractClientTest.TestInterface.class, "http://localhost:" + this.server.getPort());
        String result = api.get();
        ((AbstractStringAssert)Assertions.assertThat((String)result).isNotNull()).isEqualToIgnoringCase((CharSequence)"Compressed Data");
    }

    @Test
    public void canSupportDeflate() throws Exception {
        String responseData = "Compressed Data";
        this.server.enqueue(new MockResponse().addHeader("Content-Encoding", (Object)"deflate").setBody(new Buffer().write(this.deflate("Compressed Data"))));
        AbstractClientTest.TestInterface api = (AbstractClientTest.TestInterface)this.newBuilder().target(AbstractClientTest.TestInterface.class, "http://localhost:" + this.server.getPort());
        String result = api.get();
        ((AbstractStringAssert)Assertions.assertThat((String)result).isNotNull()).isEqualToIgnoringCase((CharSequence)"Compressed Data");
    }

    private byte[] compress(String data) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());){
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bos);
            gzipOutputStream.write(data.getBytes(StandardCharsets.UTF_8), 0, data.length());
            gzipOutputStream.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private byte[] deflate(String data) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());){
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bos);
            deflaterOutputStream.write(data.getBytes(StandardCharsets.UTF_8), 0, data.length());
            deflaterOutputStream.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

