/*
 * Decompiled with CFR 0.152.
 */
package feign.client;

import feign.CollectionFormat;
import feign.Feign;
import feign.FeignException;
import feign.Headers;
import feign.Logger;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import feign.Util;
import feign.assertj.MockWebServerAssertions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractClientTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final MockWebServer server = new MockWebServer();

    public abstract Feign.Builder newBuilder();

    @Test
    public void testPatch() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        this.server.enqueue(new MockResponse());
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Assert.assertEquals((Object)"foo", (Object)api.patch(""));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(Assertions.entry((Object)"Accept", Collections.singletonList("text/plain")), Assertions.entry((Object)"Content-Length", Collections.singletonList("0"))).hasNoHeaderNamed("Content-Type").hasMethod("PATCH");
    }

    @Test
    public void parsesRequestAndResponse() throws IOException, InterruptedException {
        this.server.enqueue(new MockResponse().setBody("foo").addHeader("Foo: Bar"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.post("foo");
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isEqualTo("OK");
        ((MapAssert)Assertions.assertThat((Map)response.headers()).hasEntrySatisfying((Object)"Content-Length", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"3"}))).hasEntrySatisfying((Object)"Foo", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"Bar"}));
        Assertions.assertThat((InputStream)response.body().asInputStream()).hasSameContentAs((InputStream)new ByteArrayInputStream("foo".getBytes(Util.UTF_8)));
        RecordedRequest recordedRequest = this.server.takeRequest();
        Assertions.assertThat((String)recordedRequest.getMethod()).isEqualToIgnoringCase((CharSequence)"POST");
        Assertions.assertThat((String)recordedRequest.getHeader("Foo")).isEqualToIgnoringCase((CharSequence)"Bar, Baz");
        Assertions.assertThat((String)recordedRequest.getHeader("Accept")).isEqualToIgnoringCase((CharSequence)"*/*");
        Assertions.assertThat((String)recordedRequest.getHeader("Content-Length")).isEqualToIgnoringCase((CharSequence)"3");
        Assertions.assertThat((String)recordedRequest.getBody().readUtf8()).isEqualToIgnoringCase((CharSequence)"foo");
    }

    @Test
    public void reasonPhraseIsOptional() throws IOException, InterruptedException {
        this.server.enqueue(new MockResponse().setStatus("HTTP/1.1 200"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.post("foo");
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isNullOrEmpty();
    }

    @Test
    public void parsesErrorResponse() {
        this.thrown.expect(FeignException.class);
        this.thrown.expectMessage("[500 Server Error] during [GET] to [http://localhost:" + this.server.getPort() + "/] [TestInterface#get()]: [ARGHH]");
        this.server.enqueue(new MockResponse().setResponseCode(500).setBody("ARGHH"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.get();
    }

    @Test
    public void parsesErrorResponseBody() {
        String expectedResponseBody = "ARGHH";
        this.server.enqueue(new MockResponse().setResponseCode(500).setBody("ARGHH"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        try {
            api.get();
        }
        catch (FeignException e) {
            Assertions.assertThat((String)e.contentUTF8()).isEqualTo(expectedResponseBody);
        }
    }

    @Test
    public void parsesUnauthorizedResponseBody() {
        String expectedResponseBody = "ARGHH";
        this.server.enqueue(new MockResponse().setResponseCode(401).setBody("ARGHH"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        try {
            api.postForString("HELLO");
        }
        catch (FeignException e) {
            Assertions.assertThat((String)e.contentUTF8()).isEqualTo(expectedResponseBody);
        }
    }

    @Test
    public void safeRebuffering() {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = (TestInterface)this.newBuilder().logger(new Logger(){

            protected void log(String configKey, String format, Object ... args) {
            }
        }).logLevel(Logger.Level.FULL).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.post("foo");
    }

    @Test
    public void safeRebuffering_noContent() {
        this.server.enqueue(new MockResponse().setResponseCode(204));
        TestInterface api = (TestInterface)this.newBuilder().logger(new Logger(){

            protected void log(String configKey, String format, Object ... args) {
            }
        }).logLevel(Logger.Level.FULL).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.post("foo");
    }

    @Test
    public void noResponseBodyForPost() {
        this.server.enqueue(new MockResponse());
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.noPostBody();
    }

    @Test
    public void noResponseBodyForPut() {
        this.server.enqueue(new MockResponse());
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.noPutBody();
    }

    @Test
    public void noResponseBodyForPatch() {
        this.server.enqueue(new MockResponse());
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.noPatchBody();
    }

    @Test
    public void parsesResponseMissingLength() throws IOException {
        this.server.enqueue(new MockResponse().setChunkedBody("foo", 1));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.post("testing");
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isEqualTo("OK");
        Assertions.assertThat((Integer)response.body().length()).isNull();
        Assertions.assertThat((InputStream)response.body().asInputStream()).hasSameContentAs((InputStream)new ByteArrayInputStream("foo".getBytes(Util.UTF_8)));
    }

    @Test
    public void postWithSpacesInPath() throws InterruptedException {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.post("current documents", "foo");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasMethod("POST").hasPath("/path/current%20documents/resource").hasBody("foo");
    }

    @Test
    public void testVeryLongResponseNullLength() {
        this.server.enqueue(new MockResponse().setBody("AAAAAAAA").addHeader("Content-Length", (Object)Long.MAX_VALUE));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.post("foo");
        Assertions.assertThat((Integer)response.body().length()).isNull();
    }

    @Test
    public void testResponseLength() {
        this.server.enqueue(new MockResponse().setBody("test"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Integer expected = 4;
        Response response = api.post("");
        Integer actual = response.body().length();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testContentTypeWithCharset() throws Exception {
        this.server.enqueue(new MockResponse().setBody("AAAAAAAA"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.postWithContentType("foo", "text/plain;charset=utf-8");
        Assert.assertEquals((Object)"AAAAAAAA", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
    }

    @Test
    public void testContentTypeWithoutCharset() throws Exception {
        this.server.enqueue(new MockResponse().setBody("AAAAAAAA"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.postWithContentType("foo", "text/plain");
        Assert.assertEquals((Object)"AAAAAAAA", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
    }

    @Test
    public void testContentTypeDefaultsToRequestCharset() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.postWithContentType("\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e8\u00e9\u00ea\u00eb", "text/plain; charset=UTF-8");
        String body = this.server.takeRequest().getBody().readUtf8();
        Assertions.assertThat((String)body).isEqualToIgnoringCase((CharSequence)"\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e8\u00e9\u00ea\u00eb");
    }

    @Test
    public void testDefaultCollectionFormat() throws Exception {
        this.server.enqueue(new MockResponse().setBody("body"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.get(Arrays.asList("bar", "baz"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isEqualTo("OK");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasMethod("GET").hasPath("/?foo=bar&foo=baz");
    }

    @Test
    public void testHeadersWithNullParams() throws InterruptedException {
        this.server.enqueue(new MockResponse().setBody("body"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.getWithHeaders(null);
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isEqualTo("OK");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasMethod("GET").hasPath("/").hasNoHeaderNamed("Authorization");
    }

    @Test
    public void testHeadersWithNotEmptyParams() throws InterruptedException {
        this.server.enqueue(new MockResponse().setBody("body"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.getWithHeaders("token");
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isEqualTo("OK");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasMethod("GET").hasPath("/").hasHeaders(Assertions.entry((Object)"authorization", Collections.singletonList("token")));
    }

    @Test
    public void testAlternativeCollectionFormat() throws Exception {
        this.server.enqueue(new MockResponse().setBody("body"));
        TestInterface api = (TestInterface)this.newBuilder().target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Response response = api.getCSV(Arrays.asList("bar", "baz"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.reason()).isEqualTo("OK");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasMethod("GET").hasOneOfPath("/?foo=bar,baz", "/?foo=bar%2Cbaz");
    }

    public static interface TestInterface {
        @RequestLine(value="POST /?foo=bar&foo=baz&qux=")
        @Headers(value={"Foo: Bar", "Foo: Baz", "Qux: ", "Content-Type: text/plain"})
        public Response post(String var1);

        @RequestLine(value="POST /path/{to}/resource")
        @Headers(value={"Accept: text/plain"})
        public Response post(@Param(value="to") String var1, String var2);

        @RequestLine(value="POST /?foo=bar&foo=baz&qux=")
        @Headers(value={"Foo: Bar", "Foo: Baz", "Qux: ", "Content-Type: text/plain"})
        public String postForString(String var1);

        @RequestLine(value="GET /")
        @Headers(value={"Accept: text/plain"})
        public String get();

        @RequestLine(value="GET /?foo={multiFoo}")
        public Response get(@Param(value="multiFoo") List<String> var1);

        @Headers(value={"Authorization: {authorization}"})
        @RequestLine(value="GET /")
        public Response getWithHeaders(@Param(value="authorization") String var1);

        @RequestLine(value="GET /?foo={multiFoo}", collectionFormat=CollectionFormat.CSV)
        public Response getCSV(@Param(value="multiFoo") List<String> var1);

        @RequestLine(value="PATCH /")
        @Headers(value={"Accept: text/plain"})
        public String patch(String var1);

        @RequestLine(value="POST")
        public String noPostBody();

        @RequestLine(value="PUT")
        public String noPutBody();

        @RequestLine(value="PATCH")
        public String noPatchBody();

        @RequestLine(value="POST /?foo=bar&foo=baz&qux=")
        @Headers(value={"Foo: Bar", "Foo: Baz", "Qux: ", "Content-Type: {contentType}"})
        public Response postWithContentType(String var1, @Param(value="contentType") String var2);
    }
}

