/*
 * Decompiled with CFR 0.152.
 */
package feign.auth;

import feign.RequestTemplate;
import feign.assertj.FeignAssertions;
import feign.auth.BasicAuthRequestInterceptor;
import java.util.Arrays;
import org.assertj.core.data.MapEntry;
import org.junit.Test;

public class BasicAuthRequestInterceptorTest {
    @Test
    public void addsAuthorizationHeader() {
        RequestTemplate template = new RequestTemplate();
        BasicAuthRequestInterceptor interceptor = new BasicAuthRequestInterceptor("Aladdin", "open sesame");
        interceptor.apply(template);
        FeignAssertions.assertThat(template).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==")));
    }

    @Test
    public void addsAuthorizationHeader_longUserAndPassword() {
        RequestTemplate template = new RequestTemplate();
        BasicAuthRequestInterceptor interceptor = new BasicAuthRequestInterceptor("IOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIO", "101010101010101010101010101010101010101010");
        interceptor.apply(template);
        FeignAssertions.assertThat(template).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("Basic SU9JT0lPSU9JT0lPSU9JT0lPSU9JT0lPSU9JT0lPSU9JT0lPSU86MTAxMDEwMTAxMDEwMTAxMDEwMTAxMDEwMTAxMDEwMTAxMDEwMTAxMDEw")));
    }
}

