/*
 * Decompiled with CFR 0.152.
 */
package feign.assertj;

import feign.RequestTemplate;
import feign.Util;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.MapEntry;
import org.assertj.core.internal.ByteArrays;
import org.assertj.core.internal.Maps;
import org.assertj.core.internal.Objects;

public final class RequestTemplateAssert
extends AbstractAssert<RequestTemplateAssert, RequestTemplate> {
    ByteArrays arrays = ByteArrays.instance();
    Objects objects = Objects.instance();
    Maps maps = Maps.instance();

    public RequestTemplateAssert(RequestTemplate actual) {
        super((Object)actual, RequestTemplateAssert.class);
    }

    public RequestTemplateAssert hasMethod(String expected) {
        this.isNotNull();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RequestTemplate)this.actual).method(), (Object)expected);
        return this;
    }

    public RequestTemplateAssert hasUrl(String expected) {
        this.isNotNull();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RequestTemplate)this.actual).url(), (Object)expected);
        return this;
    }

    public RequestTemplateAssert hasPath(String expected) {
        this.isNotNull();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RequestTemplate)this.actual).path(), (Object)expected);
        return this;
    }

    public RequestTemplateAssert hasBody(String utf8Expected) {
        this.isNotNull();
        if (((RequestTemplate)this.actual).bodyTemplate() != null) {
            this.failWithMessage("\nExpecting bodyTemplate to be null, but was:<%s>", new Object[]{((RequestTemplate)this.actual).bodyTemplate()});
        }
        this.objects.assertEqual((AssertionInfo)this.info, (Object)new String(((RequestTemplate)this.actual).body(), Util.UTF_8), (Object)utf8Expected);
        return this;
    }

    public RequestTemplateAssert hasBody(byte[] expected) {
        this.isNotNull();
        if (((RequestTemplate)this.actual).bodyTemplate() != null) {
            this.failWithMessage("\nExpecting bodyTemplate to be null, but was:<%s>", new Object[]{((RequestTemplate)this.actual).bodyTemplate()});
        }
        this.arrays.assertContains((AssertionInfo)this.info, ((RequestTemplate)this.actual).body(), expected);
        return this;
    }

    public RequestTemplateAssert hasBodyTemplate(String expected) {
        this.isNotNull();
        if (((RequestTemplate)this.actual).body() != null) {
            this.failWithMessage("\nExpecting body to be null, but was:<%s>", new Object[]{((RequestTemplate)this.actual).bodyTemplate()});
        }
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RequestTemplate)this.actual).bodyTemplate(), (Object)expected);
        return this;
    }

    public RequestTemplateAssert hasQueries(MapEntry ... entries) {
        this.isNotNull();
        this.maps.assertContainsExactly((AssertionInfo)this.info, ((RequestTemplate)this.actual).queries(), (Map.Entry[])entries);
        return this;
    }

    public RequestTemplateAssert hasHeaders(MapEntry ... entries) {
        this.isNotNull();
        this.maps.assertContainsOnly((AssertionInfo)this.info, ((RequestTemplate)this.actual).headers(), (Map.Entry[])entries);
        return this;
    }

    public RequestTemplateAssert hasNoHeader(String encoded) {
        this.objects.assertNull((AssertionInfo)this.info, ((RequestTemplate)this.actual).headers().get(encoded));
        return this;
    }

    public RequestTemplateAssert noRequestBody() {
        this.isNotNull();
        if (((RequestTemplate)this.actual).body() != null) {
            if (((RequestTemplate)this.actual).bodyTemplate() != null) {
                this.failWithMessage("\nExpecting requestBody.bodyTemplate to be null, but was:<%s>", new Object[]{((RequestTemplate)this.actual).bodyTemplate()});
            }
            if (((RequestTemplate)this.actual).body() != null) {
                this.failWithMessage("\nExpecting requestBody.data to be null, but was:<%s>", new Object[]{new String(((RequestTemplate)this.actual).body(), ((RequestTemplate)this.actual).requestCharset())});
            }
        }
        return this;
    }
}

