/*
 * Decompiled with CFR 0.152.
 */
package feign.assertj;

import feign.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.internal.ByteArrays;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Maps;
import org.assertj.core.internal.Objects;

public final class RecordedRequestAssert
extends AbstractAssert<RecordedRequestAssert, RecordedRequest> {
    ByteArrays arrays = ByteArrays.instance();
    Objects objects = Objects.instance();
    Maps maps = Maps.instance();
    Failures failures = Failures.instance();

    public RecordedRequestAssert(RecordedRequest actual) {
        super((Object)actual, RecordedRequestAssert.class);
    }

    public RecordedRequestAssert hasMethod(String expected) {
        this.isNotNull();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RecordedRequest)this.actual).getMethod(), (Object)expected);
        return this;
    }

    public RecordedRequestAssert hasPath(String expected) {
        this.isNotNull();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RecordedRequest)this.actual).getPath(), (Object)expected);
        return this;
    }

    public RecordedRequestAssert hasQueryParams(String ... expectedParams) {
        return this.hasQueryParams(Arrays.asList(expectedParams));
    }

    public RecordedRequestAssert hasQueryParams(Collection<String> expectedParams) {
        this.isNotNull();
        Collection<String> actualQueryParams = this.getQueryParams();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)expectedParams.size(), (Object)actualQueryParams.size());
        for (String expectedParam : expectedParams) {
            this.objects.assertIsIn((AssertionInfo)this.info, (Object)expectedParam, actualQueryParams);
        }
        return this;
    }

    private Collection<String> getQueryParams() {
        String path = ((RecordedRequest)this.actual).getPath();
        int queryStart = path.indexOf("?") + 1;
        String[] queryParams = ((RecordedRequest)this.actual).getPath().substring(queryStart).split("&");
        return Arrays.asList(queryParams);
    }

    public RecordedRequestAssert hasOneOfPath(String ... expected) {
        this.isNotNull();
        this.objects.assertIsIn((AssertionInfo)this.info, (Object)((RecordedRequest)this.actual).getPath(), (Object[])expected);
        return this;
    }

    public RecordedRequestAssert hasBody(String utf8Expected) {
        this.isNotNull();
        this.objects.assertEqual((AssertionInfo)this.info, (Object)((RecordedRequest)this.actual).getBody().readUtf8(), (Object)utf8Expected);
        return this;
    }

    public RecordedRequestAssert hasGzippedBody(byte[] expectedUncompressed) {
        byte[] uncompressedBody;
        this.isNotNull();
        byte[] compressedBody = ((RecordedRequest)this.actual).getBody().readByteArray();
        try {
            uncompressedBody = Util.toByteArray((InputStream)new GZIPInputStream(new ByteArrayInputStream(compressedBody)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.arrays.assertContains((AssertionInfo)this.info, uncompressedBody, expectedUncompressed);
        return this;
    }

    public RecordedRequestAssert hasDeflatedBody(byte[] expectedUncompressed) {
        byte[] uncompressedBody;
        this.isNotNull();
        byte[] compressedBody = ((RecordedRequest)this.actual).getBody().readByteArray();
        try {
            uncompressedBody = Util.toByteArray((InputStream)new InflaterInputStream(new ByteArrayInputStream(compressedBody)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.arrays.assertContains((AssertionInfo)this.info, uncompressedBody, expectedUncompressed);
        return this;
    }

    public RecordedRequestAssert hasBody(byte[] expected) {
        this.isNotNull();
        this.arrays.assertContains((AssertionInfo)this.info, ((RecordedRequest)this.actual).getBody().readByteArray(), expected);
        return this;
    }

    @Deprecated
    public RecordedRequestAssert hasHeaders(String ... headerLines) {
        this.isNotNull();
        Headers.Builder builder = new Headers.Builder();
        for (String next : headerLines) {
            builder.add(next);
        }
        ArrayList<MapEntry> expected = new ArrayList<MapEntry>();
        for (Map.Entry next : builder.build().toMultimap().entrySet()) {
            expected.add(MapEntry.entry(next.getKey(), next.getValue()));
        }
        this.hasHeaders(expected.toArray(new MapEntry[expected.size()]));
        return this;
    }

    public RecordedRequestAssert hasHeaders(MapEntry ... expected) {
        this.isNotNull();
        this.maps.assertContains((AssertionInfo)this.info, ((RecordedRequest)this.actual).getHeaders().toMultimap(), (Map.Entry[])expected);
        return this;
    }

    public RecordedRequestAssert hasNoHeaderNamed(String ... names) {
        this.isNotNull();
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        for (String header : ((RecordedRequest)this.actual).getHeaders().names()) {
            for (String name : names) {
                if (!header.equalsIgnoreCase(name)) continue;
                found.add(header);
            }
        }
        if (found.isEmpty()) {
            return this;
        }
        throw this.failures.failure((AssertionInfo)this.info, ShouldNotContain.shouldNotContain((Object)((RecordedRequest)this.actual).getHeaders(), (Object)names, found));
    }
}

