/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Util;
import feign.codec.Decoder;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class UtilTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void removesEmptyStrings() {
        Object[] values = new String[]{"", null};
        Assertions.assertThat((Object[])Util.removeValues((Object[])values, value -> Util.emptyToNull((String)value) == null, String.class)).isEmpty();
    }

    @Test
    public void removesEvenNumbers() {
        Object[] values = new Integer[]{22, 23};
        Assertions.assertThat((Object[])Util.removeValues((Object[])values, number -> number % 2 == 0, Integer.class)).containsExactly((Object[])new Integer[]{23});
    }

    @Test
    public void emptyValueOf() throws Exception {
        Assert.assertEquals((Object)false, (Object)Util.emptyValueOf(Boolean.TYPE));
        Assert.assertEquals((Object)false, (Object)Util.emptyValueOf(Boolean.class));
        Assertions.assertThat((byte[])((byte[])Util.emptyValueOf(byte[].class))).isEmpty();
        Assert.assertEquals(Collections.emptyList(), (Object)Util.emptyValueOf(Collection.class));
        Assertions.assertThat((boolean)((Iterator)Util.emptyValueOf(Iterator.class)).hasNext()).isFalse();
        Assert.assertEquals(Collections.emptyList(), (Object)Util.emptyValueOf(List.class));
        Assert.assertEquals(Collections.emptyMap(), (Object)Util.emptyValueOf(Map.class));
        Assert.assertEquals(Collections.emptySet(), (Object)Util.emptyValueOf(Set.class));
        Assert.assertEquals(Optional.empty(), (Object)Util.emptyValueOf(Optional.class));
    }

    @Test
    public void emptyValueOf_considersRawType() throws Exception {
        Type listStringType = LastTypeParameter.class.getDeclaredField("LIST_STRING").getGenericType();
        Assertions.assertThat((List)((List)Util.emptyValueOf((Type)listStringType))).isEmpty();
    }

    @Test
    public void emptyValueOf_nullForUndefined() throws Exception {
        Assertions.assertThat((Object)Util.emptyValueOf(Number.class)).isNull();
        Assertions.assertThat((Object)Util.emptyValueOf(Parameterized.class)).isNull();
    }

    @Test
    public void resolveLastTypeParameterWhenNotSubtype() throws Exception {
        Type context = LastTypeParameter.class.getDeclaredField("PARAMETERIZED_LIST_STRING").getGenericType();
        Type listStringType = LastTypeParameter.class.getDeclaredField("LIST_STRING").getGenericType();
        Type last = Util.resolveLastTypeParameter((Type)context, Parameterized.class);
        Assert.assertEquals((Object)listStringType, (Object)last);
    }

    @Test
    public void lastTypeFromInstance() throws Exception {
        ParameterizedSubtype instance = new ParameterizedSubtype();
        Type last = Util.resolveLastTypeParameter(instance.getClass(), Parameterized.class);
        Assert.assertEquals(String.class, (Object)last);
    }

    @Test
    public void lastTypeFromAnonymous() throws Exception {
        Parameterized<Reader> instance = new Parameterized<Reader>(){};
        Type last = Util.resolveLastTypeParameter(instance.getClass(), Parameterized.class);
        Assert.assertEquals(Reader.class, (Object)last);
    }

    @Test
    public void resolveLastTypeParameterWhenWildcard() throws Exception {
        Type context = LastTypeParameter.class.getDeclaredField("PARAMETERIZED_WILDCARD_LIST_STRING").getGenericType();
        Type listStringType = LastTypeParameter.class.getDeclaredField("LIST_STRING").getGenericType();
        Type last = Util.resolveLastTypeParameter((Type)context, Parameterized.class);
        Assert.assertEquals((Object)listStringType, (Object)last);
    }

    @Test
    public void resolveLastTypeParameterWhenParameterizedSubtype() throws Exception {
        Type context = LastTypeParameter.class.getDeclaredField("PARAMETERIZED_DECODER_LIST_STRING").getGenericType();
        Type listStringType = LastTypeParameter.class.getDeclaredField("LIST_STRING").getGenericType();
        Type last = Util.resolveLastTypeParameter((Type)context, ParameterizedDecoder.class);
        Assert.assertEquals((Object)listStringType, (Object)last);
    }

    @Test
    public void unboundWildcardIsObject() throws Exception {
        Type context = LastTypeParameter.class.getDeclaredField("PARAMETERIZED_DECODER_UNBOUND").getGenericType();
        Type last = Util.resolveLastTypeParameter((Type)context, ParameterizedDecoder.class);
        Assert.assertEquals(Object.class, (Object)last);
    }

    @Test
    public void checkArgumentInputFalseNotNullNullOutputIllegalArgumentException() {
        boolean expression = false;
        String errorMessageTemplate = "";
        Object[] errorMessageArgs = null;
        this.thrown.expect(IllegalArgumentException.class);
        Util.checkArgument((boolean)false, (String)"", errorMessageArgs);
    }

    @Test
    public void checkNotNullInputNullNotNullNullOutputNullPointerException() {
        Object reference = null;
        String errorMessageTemplate = "";
        Object[] errorMessageArgs = null;
        this.thrown.expect(NullPointerException.class);
        Util.checkNotNull(reference, (String)"", errorMessageArgs);
    }

    @Test
    public void checkNotNullInputZeroNotNull0OutputZero() {
        Integer reference = 0;
        String errorMessageTemplate = "   ";
        Object[] errorMessageArgs = new Object[]{};
        Object retval = Util.checkNotNull((Object)reference, (String)"   ", (Object[])errorMessageArgs);
        Assert.assertEquals((Object)new Integer(0), (Object)retval);
    }

    @Test
    public void checkStateInputFalseNotNullNullOutputIllegalStateException() {
        boolean expression = false;
        String errorMessageTemplate = "";
        Object[] errorMessageArgs = null;
        this.thrown.expect(IllegalStateException.class);
        Util.checkState((boolean)false, (String)"", errorMessageArgs);
    }

    @Test
    public void emptyToNullInputNotNullOutputNotNull() {
        String string = "AAAAAAAA";
        String retval = Util.emptyToNull((String)"AAAAAAAA");
        Assert.assertEquals((Object)"AAAAAAAA", (Object)retval);
    }

    @Test
    public void emptyToNullInputNullOutputNull() {
        String string = null;
        String retval = Util.emptyToNull(string);
        Assert.assertNull((Object)retval);
    }

    @Test
    public void isBlankInputNotNullOutputFalse() {
        String value = "AAAAAAAA";
        boolean retval = Util.isBlank((String)"AAAAAAAA");
        Assert.assertEquals((Object)false, (Object)retval);
    }

    @Test
    public void isBlankInputNullOutputTrue() {
        String value = null;
        boolean retval = Util.isBlank(value);
        Assert.assertEquals((Object)true, (Object)retval);
    }

    @Test
    public void isNotBlankInputNotNullOutputFalse() {
        String value = "";
        boolean retval = Util.isNotBlank((String)"");
        Assert.assertEquals((Object)false, (Object)retval);
    }

    @Test
    public void isNotBlankInputNotNullOutputTrue() {
        String value = "AAAAAAAA";
        boolean retval = Util.isNotBlank((String)"AAAAAAAA");
        Assert.assertEquals((Object)true, (Object)retval);
    }

    @Test
    public void caseInsensitiveCopyOfMap() {
        HashMap<String, Collection<String>> sourceMap = new HashMap<String, Collection<String>>();
        sourceMap.put("First", Arrays.asList("abc", "qwerty", "xyz"));
        sourceMap.put("camelCase", Collections.singleton("123"));
        Map actualMap = Util.caseInsensitiveCopyOf(sourceMap);
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)actualMap).hasEntrySatisfying((Object)"First", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"xyz", "abc", "qwerty"}))).hasEntrySatisfying((Object)"first", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"xyz", "abc", "qwerty"}))).hasEntrySatisfying((Object)"CAMELCASE", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"123"}))).hasEntrySatisfying((Object)"camelcase", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"123"}));
    }

    @Test
    public void copyIsUnmodifiable() {
        HashMap<String, Collection<String>> sourceMap = new HashMap<String, Collection<String>>();
        sourceMap.put("First", Arrays.asList("abc", "qwerty", "xyz"));
        sourceMap.put("camelCase", Collections.singleton("123"));
        Map unmodifiableMap = Util.caseInsensitiveCopyOf(sourceMap);
        Assertions.assertThatThrownBy(() -> {
            Collection cfr_ignored_0 = unmodifiableMap.put("new", Collections.singleton("223322"));
        }).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> ((Collection)unmodifiableMap.get("camelCase")).clear()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void nullMap() {
        Map actualMap = Util.caseInsensitiveCopyOf(null);
        ((MapAssert)Assertions.assertThat((Map)actualMap).isNotNull()).isEmpty();
    }

    static class ParameterizedSubtype
    implements Parameterized<String> {
        ParameterizedSubtype() {
        }
    }

    static interface Parameterized<T> {
    }

    static interface ParameterizedDecoder<T extends List<String>>
    extends Decoder {
    }

    static interface LastTypeParameter {
        public static final List<String> LIST_STRING = null;
        public static final Parameterized<List<String>> PARAMETERIZED_LIST_STRING = null;
        public static final Parameterized<? extends List<String>> PARAMETERIZED_WILDCARD_LIST_STRING = null;
        public static final ParameterizedDecoder<List<String>> PARAMETERIZED_DECODER_LIST_STRING = null;
        public static final ParameterizedDecoder<?> PARAMETERIZED_DECODER_UNBOUND = null;
    }
}

