/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Types;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TypesResolveReturnTypeTest {
    public Method[] getMethods(Class<?> c) {
        Method[] methods = c.getMethods();
        Arrays.sort(methods, Comparator.comparing(o -> o.getName() + o.getGenericReturnType().getTypeName()));
        return methods;
    }

    @Test
    public void simple() {
        Method[] methods = Simple.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(Simple.class, Simple.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(String.class);
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteSimple() {
        Method[] methods = ConcreteSimple.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ConcreteSimple.class, ConcreteSimple.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(String.class);
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void overridingConcreteSimple() {
        Method[] methods = OverridingConcreteSimple.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(OverridingConcreteSimple.class, OverridingConcreteSimple.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(String.class);
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void simplePrimitive() {
        Method[] methods = SimplePrimitive.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(SimplePrimitive.class, SimplePrimitive.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.TYPE);
        Type resolvedType = Types.resolveReturnType(Long.TYPE, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteSimplePrimitive() {
        Method[] methods = ConcreteSimplePrimitive.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ConcreteSimplePrimitive.class, ConcreteSimplePrimitive.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.TYPE);
        Type resolvedType = Types.resolveReturnType(Long.TYPE, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void overridingConcreteSimplePrimitive() {
        Method[] methods = OverridingConcreteSimplePrimitive.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(OverridingConcreteSimplePrimitive.class, OverridingConcreteSimplePrimitive.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.TYPE);
        Type resolvedType = Types.resolveReturnType(Long.TYPE, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void generic() {
        Method[] methods = Generic.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(Generic.class, Generic.class, (Type)Generic.class.getMethods()[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof TypeVariable)).isTrue();
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteSimpleClassGenericSecondLevel() {
        Method[] methods = ConcreteSimpleClassGenericSecondLevel.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ConcreteSimpleClassGenericSecondLevel.class, ConcreteSimpleClassGenericSecondLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void overridingConcreteSimpleClassGenericSecondLevel() {
        Method[] methods = this.getMethods(OverridingConcreteSimpleClassGenericSecondLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(OverridingConcreteSimpleClassGenericSecondLevel.class, OverridingConcreteSimpleClassGenericSecondLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(OverridingConcreteSimpleClassGenericSecondLevel.class, OverridingConcreteSimpleClassGenericSecondLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteSimpleClassMultipleGenericSecondLevel() {
        Method[] methods = ConcreteSimpleClassMultipleGenericSecondLevel.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(ConcreteSimpleClassMultipleGenericSecondLevel.class, ConcreteSimpleClassMultipleGenericSecondLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(ConcreteSimpleClassMultipleGenericSecondLevel.class, ConcreteSimpleClassMultipleGenericSecondLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void overridingConcreteSimpleClassMultipleGenericSecondLevel() {
        Method[] methods = this.getMethods(OverridingConcreteSimpleClassMultipleGenericSecondLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(OverridingConcreteSimpleClassMultipleGenericSecondLevel.class, OverridingConcreteSimpleClassMultipleGenericSecondLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(OverridingConcreteSimpleClassMultipleGenericSecondLevel.class, OverridingConcreteSimpleClassMultipleGenericSecondLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void realizingSimpleClassGenericThirdLevel() {
        Method[] methods = RealizingSimpleClassGenericThirdLevel.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(RealizingSimpleClassGenericThirdLevel.class, RealizingSimpleClassGenericThirdLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(RealizingSimpleClassGenericThirdLevel.class, RealizingSimpleClassGenericThirdLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Long.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void realizingSimpleClassMultipleGenericThirdLevel() {
        Method[] methods = this.getMethods(RealizingSimpleClassMultipleGenericThirdLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(RealizingSimpleClassMultipleGenericThirdLevel.class, RealizingSimpleClassMultipleGenericThirdLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(RealizingSimpleClassMultipleGenericThirdLevel.class, RealizingSimpleClassMultipleGenericThirdLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void realizingOverridingSimpleClassGenericThirdLevel() {
        Method[] methods = this.getMethods(RealizingOverridingSimpleClassGenericThirdLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(RealizingOverridingSimpleClassGenericThirdLevel.class, RealizingOverridingSimpleClassGenericThirdLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(RealizingOverridingSimpleClassGenericThirdLevel.class, RealizingOverridingSimpleClassGenericThirdLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void realizingOverridingSimpleClassMultipleGenericThirdLevel() {
        Method[] methods = this.getMethods(RealizingOverridingSimpleClassMultipleGenericThirdLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(RealizingOverridingSimpleClassMultipleGenericThirdLevel.class, RealizingOverridingSimpleClassMultipleGenericThirdLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(RealizingOverridingSimpleClassMultipleGenericThirdLevel.class, RealizingOverridingSimpleClassMultipleGenericThirdLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
        Assertions.assertThat((Object)resolvedType).isNotEqualTo((Object)resolved2);
    }

    @Test
    public void multipleInheritedGeneric() {
        Method[] methods = MultipleInheritedGeneric.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(MultipleInheritedGeneric.class, MultipleInheritedGeneric.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof TypeVariable)).isTrue();
        Type resolved2 = Types.resolve(MultipleInheritedGeneric.class, MultipleInheritedGeneric.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved2 instanceof TypeVariable)).isTrue();
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void secondLevelSimpleClassGeneric() {
        Method[] methods = SecondLevelSimpleClassGeneric.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(SecondLevelSimpleClassGeneric.class, SecondLevelSimpleClassGeneric.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof TypeVariable)).isTrue();
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteSimpleClassGenericThirdLevel() {
        Method[] methods = ConcreteSimpleClassGenericThirdLevel.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ConcreteSimpleClassGenericThirdLevel.class, ConcreteSimpleClassGenericThirdLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void OverridingConcreteSimpleClassGenericThirdLevel() {
        Method[] methods = this.getMethods(OverridingConcreteSimpleClassGenericThirdLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(OverridingConcreteSimpleClassGenericThirdLevel.class, OverridingConcreteSimpleClassGenericThirdLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved).isEqualTo(Long.class);
        Type resolved2 = Types.resolve(OverridingConcreteSimpleClassGenericThirdLevel.class, OverridingConcreteSimpleClassGenericThirdLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void secondLevelCollectionGeneric() {
        Method[] methods = SecondLevelCollectionGeneric.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(SecondLevelCollectionGeneric.class, SecondLevelCollectionGeneric.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof TypeVariable)).isTrue();
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void thirdLevelCollectionGeneric() {
        Method[] methods = ThirdLevelCollectionGeneric.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ThirdLevelCollectionGeneric.class, ThirdLevelCollectionGeneric.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof TypeVariable)).isTrue();
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteCollectionGenericFourthLevel() {
        Method[] methods = ConcreteCollectionGenericFourthLevel.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ConcreteCollectionGenericFourthLevel.class, ConcreteCollectionGenericFourthLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof ParameterizedType)).isTrue();
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void overridingConcreteCollectionGenericFourthLevel() {
        Method[] methods = this.getMethods(OverridingConcreteCollectionGenericFourthLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(OverridingConcreteCollectionGenericFourthLevel.class, OverridingConcreteCollectionGenericFourthLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof ParameterizedType)).isTrue();
        Type resolved2 = Types.resolve(OverridingConcreteCollectionGenericFourthLevel.class, OverridingConcreteCollectionGenericFourthLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void overrideOverridingConcreteCollectionGenericFourthLevel() {
        Method[] methods = this.getMethods(OverrideOverridingConcreteCollectionGenericFourthLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(OverrideOverridingConcreteCollectionGenericFourthLevel.class, OverrideOverridingConcreteCollectionGenericFourthLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof ParameterizedType)).isTrue();
        Type resolved2 = Types.resolve(OverrideOverridingConcreteCollectionGenericFourthLevel.class, OverrideOverridingConcreteCollectionGenericFourthLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)resolved, (Type)resolved2);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void genericFourthLevelCollectionGeneric() {
        Method[] methods = GenericFourthLevelCollectionGeneric.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(GenericFourthLevelCollectionGeneric.class, GenericFourthLevelCollectionGeneric.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof ParameterizedType)).isTrue();
        Type resolvedType = Types.resolveReturnType(Object.class, (Type)resolved);
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    @Test
    public void concreteGenericCollectionGenericFifthLevel() {
        Method[] methods = ConcreteGenericCollectionGenericFifthLevel.class.getMethods();
        Assertions.assertThat((int)methods.length).isEqualTo(1);
        Type resolved = Types.resolve(ConcreteGenericCollectionGenericFifthLevel.class, ConcreteGenericCollectionGenericFifthLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof ParameterizedType)).isTrue();
        ParameterizedType parameterizedType = (ParameterizedType)resolved;
    }

    @Test
    public void overridingConcreteGenericCollectionGenericFifthLevel() {
        Method[] methods = this.getMethods(OverridingConcreteGenericCollectionGenericFifthLevel.class);
        Assertions.assertThat((int)methods.length).isEqualTo(2);
        Type resolved = Types.resolve(OverridingConcreteGenericCollectionGenericFifthLevel.class, OverridingConcreteGenericCollectionGenericFifthLevel.class, (Type)methods[1].getGenericReturnType());
        Assertions.assertThat((boolean)(resolved instanceof ParameterizedType)).isTrue();
        Type resolved2 = Types.resolve(OverridingConcreteGenericCollectionGenericFifthLevel.class, OverridingConcreteGenericCollectionGenericFifthLevel.class, (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolved2).isEqualTo(Object.class);
        Type resolvedType = Types.resolveReturnType((Type)methods[1].getGenericReturnType(), (Type)methods[0].getGenericReturnType());
        Assertions.assertThat((Object)resolvedType).isEqualTo((Object)resolved);
    }

    static interface OverridingGenerifiedOverrideNonGenericSimpleClass
    extends GenerifiedOverrideNonGenericSimpleClass<Long> {
        @Override
        public Long get();
    }

    static interface RealizedGenerifiedOverrideNonGenericSimpleClass
    extends GenerifiedOverrideNonGenericSimpleClass<Long> {
    }

    static interface GenerifiedOverrideNonGenericSimpleClass<T extends Number>
    extends OverrideNonGenericSimpleClass {
        public T get();
    }

    static interface OverrideNonGenericSimpleClass
    extends SimpleClassNonGeneric {
        @Override
        public Number get();
    }

    static interface SimpleClassNonGeneric {
        public Object get();
    }

    static interface SimpleArrayGeneric<T> {
        public T[] get();
    }

    static interface ThirdLevelMapGeneric<T extends HashMap<?, ?>>
    extends SecondLevelMapGeneric<T> {
    }

    static interface SecondLevelMapGeneric<T extends Map<?, ?>>
    extends Generic<T> {
    }

    static interface OverridingConcreteGenericCollectionGenericFifthLevel
    extends GenericFourthLevelCollectionGeneric<Long>,
    SecondGenericFourthLevelCollectionGeneric<Long> {
        @Override
        public List<Long> get();
    }

    static interface ConcreteGenericCollectionGenericFifthLevel
    extends GenericFourthLevelCollectionGeneric<Long> {
    }

    static interface SecondGenericFourthLevelCollectionGeneric<T>
    extends ThirdLevelCollectionGeneric<List<T>> {
    }

    static interface GenericFourthLevelCollectionGeneric<T>
    extends ThirdLevelCollectionGeneric<List<T>> {
    }

    static interface OverrideOverridingConcreteCollectionGenericFourthLevel
    extends OverridingConcreteCollectionGenericFourthLevel {
        @Override
        public List<Long> get();
    }

    static interface OverridingConcreteCollectionGenericFourthLevel
    extends ThirdLevelCollectionGeneric<List<Long>> {
        @Override
        public List<Long> get();
    }

    static interface ConcreteCollectionGenericFourthLevel
    extends ThirdLevelCollectionGeneric<List<Long>> {
    }

    static interface ThirdLevelCollectionGeneric<T extends List<?>>
    extends SecondLevelCollectionGeneric<T> {
    }

    static interface ConcreteCollectionGenericThirdLevel
    extends SecondLevelCollectionGeneric<ArrayList<Long>> {
    }

    static interface SecondLevelCollectionGeneric<T extends Collection<?>>
    extends Generic<T> {
    }

    static interface ConcreteGenericClassThirdLevel
    extends SecondLevelGenericClassGeneric<RealizedGeneric> {
    }

    static interface RealizedGeneric
    extends Generic<Long> {
    }

    static interface SecondLevelGenericClassGeneric<T extends Generic<?>>
    extends Generic<T> {
    }

    static interface OverridingConcreteSimpleClassGenericThirdLevel
    extends SecondLevelSimpleClassGeneric<Long> {
        @Override
        public Long get();
    }

    static interface ConcreteSimpleClassGenericThirdLevel
    extends SecondLevelSimpleClassGeneric<Long> {
    }

    static interface SecondLevelSimpleClassGeneric<T extends Number>
    extends Generic<T> {
    }

    static interface MultipleInheritedGeneric<T>
    extends Generic<T>,
    SecondGeneric<T> {
    }

    static interface RealizingOverridingSimpleClassMultipleGenericThirdLevel
    extends OverridingConcreteSimpleClassMultipleGenericSecondLevel {
        @Override
        public Long get();
    }

    static interface RealizingOverridingSimpleClassGenericThirdLevel
    extends ConcreteSimpleClassMultipleGenericSecondLevel {
        @Override
        public Long get();
    }

    static interface RealizingSimpleClassMultipleGenericThirdLevel
    extends OverridingConcreteSimpleClassMultipleGenericSecondLevel {
    }

    static interface RealizingSimpleClassGenericThirdLevel
    extends ConcreteSimpleClassMultipleGenericSecondLevel {
    }

    static interface OverridingConcreteSimpleClassMultipleGenericSecondLevel
    extends Generic<Long>,
    SecondGeneric<Long> {
        @Override
        public Long get();
    }

    static interface ConcreteSimpleClassMultipleGenericSecondLevel
    extends Generic<Long>,
    SecondGeneric<Long> {
    }

    static interface SecondGeneric<T> {
        public T get();
    }

    static interface OverridingConcreteSimpleClassGenericSecondLevel
    extends Generic<Long> {
        @Override
        public Long get();
    }

    static interface ConcreteSimpleClassGenericSecondLevel
    extends Generic<Long> {
    }

    static interface Generic<T> {
        public T get();
    }

    static interface OverridingConcreteSimplePrimitive
    extends SimplePrimitive {
        @Override
        public long get();
    }

    static interface ConcreteSimplePrimitive
    extends SimplePrimitive {
    }

    static interface SimplePrimitive {
        public long get();
    }

    static interface OverridingConcreteSimple
    extends Simple {
        @Override
        public String get();
    }

    static interface ConcreteSimple
    extends Simple {
    }

    static interface Simple {
        public String get();
    }
}

