/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Feign;
import feign.Param;
import feign.Request;
import feign.RequestLine;
import feign.RequestTemplate;
import feign.Response;
import feign.Target;
import feign.assertj.MockWebServerAssertions;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Rule;
import org.junit.Test;

public class TargetTest {
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void baseCaseQueryParamsArePercentEncoded() throws InterruptedException {
        this.server.enqueue(new MockResponse());
        String baseUrl = this.server.url("/default").toString();
        ((TestQuery)Feign.builder().target(TestQuery.class, baseUrl)).get("slash/foo", "slash/bar");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/default/slash/foo?query=slash/bar");
    }

    @Test
    public void targetCanCreateCustomRequest() throws InterruptedException {
        this.server.enqueue(new MockResponse());
        String baseUrl = this.server.url("/default").toString();
        Target.HardCodedTarget<TestQuery> custom = new Target.HardCodedTarget<TestQuery>(TestQuery.class, baseUrl){

            public Request apply(RequestTemplate input) {
                Request urlEncoded = super.apply(input);
                return Request.create((Request.HttpMethod)urlEncoded.httpMethod(), (String)urlEncoded.url().replace("%2F", "/"), (Map)urlEncoded.headers(), (byte[])urlEncoded.body(), (Charset)urlEncoded.charset());
            }
        };
        ((TestQuery)Feign.builder().target((Target)custom)).get("slash/foo", "slash/bar");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/default/slash/foo?query=slash/bar");
    }

    @Test
    public void emptyTarget() throws InterruptedException {
        this.server.enqueue(new MockResponse());
        UriTarget uriTarget = (UriTarget)Feign.builder().target((Target)Target.EmptyTarget.create(UriTarget.class));
        String host = this.server.getHostName();
        int port = this.server.getPort();
        uriTarget.get(URI.create("http://" + host + ":" + port + "/path?query=param"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/path?query=param").hasQueryParams("query=param");
    }

    @Test
    public void hardCodedTargetWithURI() throws InterruptedException {
        this.server.enqueue(new MockResponse());
        String host = this.server.getHostName();
        int port = this.server.getPort();
        String base = "http://" + host + ":" + port;
        UriTarget uriTarget = (UriTarget)Feign.builder().target(UriTarget.class, base);
        uriTarget.get(URI.create("http://" + host + ":" + port + "/path?query=param"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/path?query=param").hasQueryParams("query=param");
    }

    static interface UriTarget {
        @RequestLine(value="GET")
        public Response get(URI var1);
    }

    static interface TestQuery {
        @RequestLine(value="GET /{path}?query={query}")
        public Response get(@Param(value="path") String var1, @Param(value="query") String var2);
    }
}

