/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.RetryableException;
import feign.Retryer;
import feign.Util;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RetryerTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final Request REQUEST = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/", Collections.emptyMap(), null, (Charset)Util.UTF_8);

    @Test
    public void only5TriesAllowedAndExponentialBackoff() throws Exception {
        RetryableException e = new RetryableException(-1, null, null, null, REQUEST);
        Retryer.Default retryer = new Retryer.Default();
        Assert.assertEquals((long)1L, (long)retryer.attempt);
        Assert.assertEquals((long)0L, (long)retryer.sleptForMillis);
        retryer.continueOrPropagate(e);
        Assert.assertEquals((long)2L, (long)retryer.attempt);
        Assert.assertEquals((long)150L, (long)retryer.sleptForMillis);
        retryer.continueOrPropagate(e);
        Assert.assertEquals((long)3L, (long)retryer.attempt);
        Assert.assertEquals((long)375L, (long)retryer.sleptForMillis);
        retryer.continueOrPropagate(e);
        Assert.assertEquals((long)4L, (long)retryer.attempt);
        Assert.assertEquals((long)712L, (long)retryer.sleptForMillis);
        retryer.continueOrPropagate(e);
        Assert.assertEquals((long)5L, (long)retryer.attempt);
        Assert.assertEquals((long)1218L, (long)retryer.sleptForMillis);
        this.thrown.expect(RetryableException.class);
        retryer.continueOrPropagate(e);
    }

    @Test
    public void considersRetryAfterButNotMoreThanMaxPeriod() {
        Retryer.Default retryer = new Retryer.Default(){

            protected long currentTimeMillis() {
                return 0L;
            }
        };
        retryer.continueOrPropagate(new RetryableException(-1, null, null, new Date(5000L), REQUEST));
        Assert.assertEquals((long)2L, (long)retryer.attempt);
        Assert.assertEquals((long)1000L, (long)retryer.sleptForMillis);
    }

    @Test(expected=RetryableException.class)
    public void neverRetryAlwaysPropagates() {
        Retryer.NEVER_RETRY.continueOrPropagate(new RetryableException(-1, null, null, new Date(5000L), REQUEST));
    }

    @Test
    public void defaultRetryerFailsOnInterruptedException() {
        Retryer.Default retryer = new Retryer.Default();
        Thread.currentThread().interrupt();
        RetryableException expected = new RetryableException(-1, null, null, new Date(System.currentTimeMillis() + 5000L), REQUEST);
        try {
            retryer.continueOrPropagate(expected);
            Thread.interrupted();
            Assert.fail((String)"Retryer continued despite interruption");
        }
        catch (RetryableException e) {
            Assert.assertTrue((String)"Interrupted status not reset", (boolean)Thread.interrupted());
            Assert.assertEquals((String)"Retry attempt not registered as expected", (long)2L, (long)retryer.attempt);
            Assert.assertEquals((String)"Unexpected exception found", (Object)((Object)expected), (Object)((Object)e));
        }
    }
}

