/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.Response;
import feign.Util;
import feign.assertj.FeignAssertions;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Lists;
import org.junit.Test;

public class ResponseTest {
    @Test
    public void reasonPhraseIsOptional() {
        Response response = Response.builder().status(200).headers(Collections.emptyMap()).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body(new byte[0]).build();
        FeignAssertions.assertThat((String)response.reason()).isNull();
        FeignAssertions.assertThat((String)response.toString()).startsWith((CharSequence)"HTTP/1.1 200");
    }

    @Test
    public void canAccessHeadersCaseInsensitively() {
        LinkedHashMap<String, List<String>> headersMap = new LinkedHashMap<String, List<String>>();
        List<String> valueList = Collections.singletonList("application/json");
        headersMap.put("Content-Type", valueList);
        Response response = Response.builder().status(200).headers(headersMap).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body(new byte[0]).build();
        ((MapAssert)FeignAssertions.assertThat((Map)response.headers()).hasEntrySatisfying((Object)"content-type", value -> FeignAssertions.assertThat((Collection)value).contains((Object[])new String[]{"application/json"}))).hasEntrySatisfying((Object)"Content-Type", value -> FeignAssertions.assertThat((Collection)value).contains((Object[])new String[]{"application/json"}));
    }

    @Test
    public void headerValuesWithSameNameOnlyVaryingInCaseAreMerged() {
        LinkedHashMap<String, List<String>> headersMap = new LinkedHashMap<String, List<String>>();
        headersMap.put("Set-Cookie", Arrays.asList("Cookie-A=Value", "Cookie-B=Value"));
        headersMap.put("set-cookie", Collections.singletonList("Cookie-C=Value"));
        Response response = Response.builder().status(200).headers(headersMap).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body(new byte[0]).build();
        FeignAssertions.assertThat((Map)response.headers()).hasEntrySatisfying((Object)"set-cookie", value -> FeignAssertions.assertThat((Collection)value).contains((Object[])new String[]{"Cookie-A=Value", "Cookie-B=Value", "Cookie-C=Value"}));
    }

    @Test
    public void headersAreOptional() {
        Response response = Response.builder().status(200).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body(new byte[0]).build();
        ((MapAssert)FeignAssertions.assertThat((Map)response.headers()).isNotNull()).isEmpty();
    }

    @Test
    public void support1xxStatusCodes() {
        Response response = Response.builder().status(103).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body((Response.Body)null).build();
        FeignAssertions.assertThat((int)response.status()).isEqualTo(103);
    }

    @Test
    public void statusCodesOfAnyValueAreAllowed() {
        Lists.list((Object[])new Integer[]{600, 50, 35600}).forEach(statusCode -> {
            Response response = Response.builder().status(statusCode.intValue()).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body((Response.Body)null).build();
            FeignAssertions.assertThat((int)response.status()).isEqualTo(statusCode);
        });
    }
}

