/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.CollectionFormat;
import feign.Request;
import feign.RequestTemplate;
import feign.Util;
import feign.assertj.FeignAssertions;
import feign.template.UriUtils;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.data.MapEntry;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RequestTemplateTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    private static <K, V> Map<K, V> mapOf(K key, V val) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        result.put(key, val);
        return result;
    }

    private static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        Map<K, V> result = RequestTemplateTest.mapOf(k1, v1);
        result.put(k2, v2);
        return result;
    }

    private static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> result = RequestTemplateTest.mapOf(k1, v1, k2, v2);
        result.put(k3, v3);
        return result;
    }

    private static String expand(String template, Map<String, Object> variables) {
        RequestTemplate requestTemplate = new RequestTemplate();
        requestTemplate.uri(template);
        return requestTemplate.resolve(variables).url();
    }

    @Test
    public void expandUrlEncoded() {
        for (String val : Arrays.asList("apples", "sp ace", "unic???de", "qu?stion")) {
            FeignAssertions.assertThat((String)RequestTemplateTest.expand("/users/{user}", RequestTemplateTest.mapOf("user", val))).isEqualTo("/users/" + UriUtils.encode((String)val, (Charset)Util.UTF_8));
        }
    }

    @Test
    public void expandMultipleParams() {
        FeignAssertions.assertThat((String)RequestTemplateTest.expand("/users/{user}/{repo}", RequestTemplateTest.mapOf("user", "unic???de", "repo", "foo"))).isEqualTo("/users/unic%3F%3F%3Fde/foo");
    }

    @Test
    public void expandParamKeyHyphen() {
        FeignAssertions.assertThat((String)RequestTemplateTest.expand("/{user-dir}", RequestTemplateTest.mapOf("user-dir", "foo"))).isEqualTo("/foo");
    }

    @Test
    public void expandMissingParamProceeds() {
        FeignAssertions.assertThat((String)RequestTemplateTest.expand("/{user-dir}", RequestTemplateTest.mapOf("user_dir", "foo"))).isEqualTo("/");
    }

    @Test
    public void resolveTemplateWithParameterizedPathSkipsEncodingSlash() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("{zoneId}");
        template = template.resolve(RequestTemplateTest.mapOf("zoneId", "/hostedzone/Z1PA6795UKMFR9"));
        FeignAssertions.assertThat(template).hasUrl("/hostedzone/Z1PA6795UKMFR9");
    }

    @Test
    public void resolveTemplateWithBinaryBody() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("{zoneId}").body(new byte[]{7, 3, -3, -7}, null);
        template = template.resolve(RequestTemplateTest.mapOf("zoneId", "/hostedzone/Z1PA6795UKMFR9"));
        FeignAssertions.assertThat(template).hasUrl("/hostedzone/Z1PA6795UKMFR9");
    }

    @Test
    public void canInsertAbsoluteHref() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/hostedzone/Z1PA6795UKMFR9");
        template.target("https://route53.amazonaws.com/2012-12-12");
        FeignAssertions.assertThat(template).hasUrl("https://route53.amazonaws.com/2012-12-12/hostedzone/Z1PA6795UKMFR9");
    }

    @Test
    public void resolveTemplateWithRelativeUriWithQuery() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/wsdl/testcase?wsdl").target("https://api.example.com");
        FeignAssertions.assertThat(template).hasUrl("https://api.example.com/wsdl/testcase?wsdl");
    }

    @Test
    public void resolveTemplateWithBaseAndParameterizedQuery() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/?Action=DescribeRegions").query("RegionName.1", new String[]{"{region}"});
        template = template.resolve(RequestTemplateTest.mapOf("region", "eu-west-1"));
        FeignAssertions.assertThat(template).hasQueries(MapEntry.entry((Object)"Action", Collections.singletonList("DescribeRegions")), MapEntry.entry((Object)"RegionName.1", Collections.singletonList("eu-west-1")));
    }

    @Test
    public void resolveTemplateWithBaseAndParameterizedIterableQuery() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/?Query=one").query("Queries", new String[]{"{queries}"});
        template = template.resolve(RequestTemplateTest.mapOf("queries", Arrays.asList("us-east-1", "eu-west-1")));
        FeignAssertions.assertThat(template).hasQueries(MapEntry.entry((Object)"Query", Collections.singletonList("one")), MapEntry.entry((Object)"Queries", Arrays.asList("us-east-1", "eu-west-1")));
    }

    @Test
    public void resolveTemplateWithMixedCollectionFormatsByQuery() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).collectionFormat(CollectionFormat.EXPLODED).uri("/api/collections").query("keys", new String[]{"{keys}"}).query("values[]", Collections.singletonList("{values[]}"), CollectionFormat.CSV);
        template = template.resolve(RequestTemplateTest.mapOf("keys", Arrays.asList("one", "two"), "values[]", Arrays.asList("1", "2")));
        FeignAssertions.assertThat((String)template.url()).isEqualToIgnoringCase((CharSequence)"/api/collections?keys=one&keys=two&values%5B%5D=1%2C2");
    }

    @Test
    public void resolveTemplateWithHeaderSubstitutions() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).header("Auth-Token", new String[]{"{authToken}"});
        template = template.resolve(RequestTemplateTest.mapOf("authToken", "1234"));
        FeignAssertions.assertThat(template).hasHeaders(MapEntry.entry((Object)"Auth-Token", Collections.singletonList("1234")));
    }

    @Test
    public void resolveTemplateWithHeaderSubstitutionsNotAtStart() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).header("Authorization", new String[]{"Bearer {token}"});
        template = template.resolve(RequestTemplateTest.mapOf("token", "1234"));
        FeignAssertions.assertThat(template).hasHeaders(MapEntry.entry((Object)"Authorization", Collections.singletonList("Bearer 1234")));
    }

    @Test
    public void resolveTemplateWithHeaderWithEscapedCurlyBrace() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).header("Encoded", new String[]{"{{{{dont_expand_me}}"});
        template.resolve(RequestTemplateTest.mapOf("dont_expand_me", "1234"));
        FeignAssertions.assertThat(template).hasHeaders(MapEntry.entry((Object)"Encoded", Collections.singletonList("{{{{dont_expand_me}}")));
    }

    @Test
    public void resolveTemplateWithHeaderIncludingSpecialCharacters() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).header("Accept", new String[]{"application/vnd.github.v3+{type}"});
        template = template.resolve(RequestTemplateTest.mapOf("type", "json"));
        FeignAssertions.assertThat(template).hasHeaders(MapEntry.entry((Object)"Accept", Collections.singletonList("application/vnd.github.v3+json")));
    }

    @Test
    public void resolveTemplateWithHeaderEmptyResult() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).header("Encoded", new String[]{"{var}"});
        template = template.resolve(RequestTemplateTest.mapOf("var", ""));
        FeignAssertions.assertThat(template).hasNoHeader("Encoded");
    }

    @Test
    public void resolveTemplateWithMixedRequestLineParams() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/domains/{domainId}/records").query("name", new String[]{"{name}"}).query("type", new String[]{"{type}"});
        template = template.resolve(RequestTemplateTest.mapOf("domainId", 1001, "name", "denominator.io", "type", "CNAME"));
        FeignAssertions.assertThat(template).hasQueries(MapEntry.entry((Object)"name", Collections.singletonList("denominator.io")), MapEntry.entry((Object)"type", Collections.singletonList("CNAME")));
    }

    @Test
    public void insertHasQueryParams() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/domains/1001/records").query("name", new String[]{"denominator.io"}).query("type", new String[]{"CNAME"});
        template.target("https://host/v1.0/1234?provider=foo");
        FeignAssertions.assertThat(template).hasPath("https://host/v1.0/1234/domains/1001/records").hasQueries(MapEntry.entry((Object)"name", Collections.singletonList("denominator.io")), MapEntry.entry((Object)"type", Collections.singletonList("CNAME")), MapEntry.entry((Object)"provider", Collections.singletonList("foo")));
    }

    @Test
    public void resolveTemplateWithBodyTemplateSetsBodyAndContentLength() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.POST).bodyTemplate("%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D", Util.UTF_8);
        template = template.resolve(RequestTemplateTest.mapOf("customer_name", "netflix", "user_name", "denominator", "password", "password"));
        FeignAssertions.assertThat(template).hasBody("{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"}").hasHeaders(MapEntry.entry((Object)"Content-Length", Collections.singletonList(String.valueOf(template.body().length))));
    }

    @Test
    public void resolveTemplateWithBodyTemplateDoesNotDoubleDecode() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.POST).bodyTemplate("%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D", Util.UTF_8);
        template = template.resolve(RequestTemplateTest.mapOf("customer_name", "netflix", "user_name", "denominator", "password", "abc+123%25d8"));
        FeignAssertions.assertThat(template).hasBody("{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"abc+123%25d8\"}");
    }

    @Test
    public void skipUnresolvedQueries() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/domains/{domainId}/records").query("optional", new String[]{"{optional}"}).query("name", new String[]{"{nameVariable}"});
        template = template.resolve(RequestTemplateTest.mapOf("domainId", 1001, "nameVariable", "denominator.io"));
        FeignAssertions.assertThat(template).hasQueries(MapEntry.entry((Object)"name", Collections.singletonList("denominator.io")));
    }

    @Test
    public void allQueriesUnresolvable() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/domains/{domainId}/records").query("optional", new String[]{"{optional}"}).query("optional2", new String[]{"{optional2}"});
        template = template.resolve(RequestTemplateTest.mapOf("domainId", 1001));
        FeignAssertions.assertThat(template).hasUrl("/domains/1001/records").hasQueries(new MapEntry[0]);
    }

    @Test
    public void spaceEncodingInUrlParam() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/api/{value1}?key={value2}");
        template = template.resolve(RequestTemplateTest.mapOf("value1", "ABC 123", "value2", "XYZ 123"));
        FeignAssertions.assertThat((String)template.request().url()).isEqualTo("/api/ABC%20123?key=XYZ%20123");
    }

    @Test
    public void useCaseInsensitiveHeaderFieldNames() {
        RequestTemplate template = new RequestTemplate();
        String value = "value1";
        template.header("TEST", new String[]{"value1"});
        String value2 = "value2";
        template.header("tEST", new String[]{"value2"});
        Collection test = (Collection)template.headers().get("test");
        String assertionMessage = "Header field names should be case insensitive";
        Assert.assertNotNull((String)"Header field names should be case insensitive", (Object)test);
        Assert.assertTrue((String)"Header field names should be case insensitive", (boolean)test.contains("value1"));
        Assert.assertTrue((String)"Header field names should be case insensitive", (boolean)test.contains("value2"));
        Assert.assertEquals((long)1L, (long)template.headers().size());
        Assert.assertEquals((long)2L, (long)((Collection)template.headers().get("tesT")).size());
    }

    @Test
    public void encodeSlashTest() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/api/{vhost}").decodeSlash(false);
        template = template.resolve(RequestTemplateTest.mapOf("vhost", "/"));
        FeignAssertions.assertThat(template).hasUrl("/api/%2F");
    }

    @Test
    public void uriStuffedIntoMethod() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid HTTP Method: /path?queryParam={queryParam}");
        new RequestTemplate().method("/path?queryParam={queryParam}");
    }

    @Test
    public void encodedQueryClearedOnNull() {
        RequestTemplate template = new RequestTemplate();
        template.query("param[]", new String[]{"value"});
        FeignAssertions.assertThat(template).hasQueries(MapEntry.entry((Object)"param[]", Collections.singletonList("value")));
        template.query("param[]", (String[])null);
        FeignAssertions.assertThat((Map)template.queries()).isEmpty();
    }

    @Test
    public void encodedQuery() {
        RequestTemplate template = new RequestTemplate().query("params[]", new String[]{"foo%20bar"});
        FeignAssertions.assertThat((String)template.queryLine()).isEqualTo("?params%5B%5D=foo%20bar");
        FeignAssertions.assertThat(template).hasQueries(MapEntry.entry((Object)"params[]", Collections.singletonList("foo%20bar")));
    }

    @Test
    public void encodedQueryWithUnsafeCharactersMixedWithUnencoded() {
        RequestTemplate template = new RequestTemplate().query("params[]", new String[]{"not encoded"}).query("params[]", new String[]{"encoded"});
        FeignAssertions.assertThat((String)template.queryLine()).isEqualTo("?params%5B%5D=not%20encoded&params%5B%5D=encoded");
        Map queries = template.queries();
        FeignAssertions.assertThat((Map)queries).containsKey((Object)"params[]");
        ((AbstractCollectionAssert)FeignAssertions.assertThat((Collection)((Collection)queries.get("params[]"))).contains((Object[])new String[]{"encoded"})).contains((Object[])new String[]{"not%20encoded"});
    }

    @Test
    public void shouldRetrieveHeadersWithoutNull() {
        RequestTemplate template = new RequestTemplate().header("key1", new String[]{null}).header("key2", Collections.emptyList()).header("key3", (Iterable)null).header("key4", new String[]{"valid"}).header("key5", new String[]{"valid"}).header("key6", new String[]{"valid"}).header("key7", new String[]{"valid"});
        FeignAssertions.assertThat((Map)template.headers()).hasSize(4);
        FeignAssertions.assertThat(template.headers().keySet()).containsExactly((Object[])new String[]{"key4", "key5", "key6", "key7"});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotInsertHeadersImmutableMap() {
        RequestTemplate template = new RequestTemplate().header("key1", new String[]{"valid"});
        FeignAssertions.assertThat((Map)template.headers()).hasSize(1);
        FeignAssertions.assertThat(template.headers().keySet()).containsExactly((Object[])new String[]{"key1"});
        template.headers().put("key2", Collections.singletonList("other value"));
    }

    @Test
    public void fragmentShouldNotBeEncodedInUri() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/path#fragment").queries(RequestTemplateTest.mapOf("key1", Collections.singletonList("value1")));
        FeignAssertions.assertThat((String)template.url()).isEqualTo("/path?key1=value1#fragment");
    }

    @Test
    public void fragmentShouldNotBeEncodedInTarget() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).target("https://example.com/path#fragment").queries(RequestTemplateTest.mapOf("key1", Collections.singletonList("value1")));
        FeignAssertions.assertThat((String)template.url()).isEqualTo("https://example.com/path?key1=value1#fragment");
    }

    @Test
    public void slashShouldNotBeAppendedForMatrixParams() {
        RequestTemplate template = new RequestTemplate().method(Request.HttpMethod.GET).uri("/path;key1=value1;key2=value2", true);
        FeignAssertions.assertThat((String)template.url()).isEqualTo("/path;key1=value1;key2=value2");
    }

    @Test
    public void encodedReservedPreserveSlash() {
        RequestTemplate template = new RequestTemplate();
        template.uri("/get?url={url}");
        template.method(Request.HttpMethod.GET);
        template = template.resolve(Collections.singletonMap("url", "https://www.google.com"));
        FeignAssertions.assertThat((String)template.url()).isEqualToIgnoringCase((CharSequence)"/get?url=https%3A//www.google.com");
    }

    @Test
    public void encodedReservedEncodeSlash() {
        RequestTemplate template = new RequestTemplate();
        template.uri("/get?url={url}");
        template.decodeSlash(false);
        template.method(Request.HttpMethod.GET);
        template = template.resolve(Collections.singletonMap("url", "https://www.google.com"));
        FeignAssertions.assertThat((String)template.url()).isEqualToIgnoringCase((CharSequence)"/get?url=https%3A%2F%2Fwww.google.com");
    }
}

