/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Feign;
import feign.FeignException;
import feign.Request;
import feign.RequestLine;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptionsTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void socketTimeoutTest() {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("foo").setBodyDelay(3L, TimeUnit.SECONDS));
        OptionsInterface api = (OptionsInterface)Feign.builder().options(new Request.Options(1000, 1000)).target(OptionsInterface.class, server.url("/").toString());
        this.thrown.expect(FeignException.class);
        this.thrown.expectCause(CoreMatchers.isA(SocketTimeoutException.class));
        api.get();
    }

    @Test
    public void normalResponseTest() {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("foo").setBodyDelay(3L, TimeUnit.SECONDS));
        OptionsInterface api = (OptionsInterface)Feign.builder().options(new Request.Options(1000, 1000)).target(OptionsInterface.class, server.url("/").toString());
        Assertions.assertThat((String)api.get(new Request.Options(1000, 4000))).isEqualTo("foo");
    }

    static interface OptionsInterface {
        @RequestLine(value="GET /")
        public String get(Request.Options var1);

        @RequestLine(value="GET /")
        public String get();
    }
}

