/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Logger;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class MultipleLoggerTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    private static Logger getInnerLogger(Logger.JavaLogger logger) throws Exception {
        Field inner = logger.getClass().getDeclaredField("logger");
        inner.setAccessible(true);
        return (Logger)inner.get(logger);
    }

    @Test
    public void testAppendSeveralFilesToOneJavaLogger() throws Exception {
        Logger.JavaLogger logger = new Logger.JavaLogger().appendToFile(this.tmp.newFile("1.log").getAbsolutePath()).appendToFile(this.tmp.newFile("2.log").getAbsolutePath());
        Logger inner = MultipleLoggerTest.getInnerLogger(logger);
        assert (inner.getHandlers().length == 2);
    }

    @Test
    public void testJavaLoggerInstantationWithLoggerName() throws Exception {
        Logger.JavaLogger l1 = new Logger.JavaLogger("First client").appendToFile(this.tmp.newFile("1.log").getAbsolutePath());
        Logger.JavaLogger l2 = new Logger.JavaLogger("Second client").appendToFile(this.tmp.newFile("2.log").getAbsolutePath());
        Logger logger1 = MultipleLoggerTest.getInnerLogger(l1);
        assert (logger1.getHandlers().length == 1);
        Logger logger2 = MultipleLoggerTest.getInnerLogger(l2);
        assert (logger2.getHandlers().length == 1);
    }

    @Test
    public void testJavaLoggerInstantationWithClazz() throws Exception {
        Logger.JavaLogger l1 = new Logger.JavaLogger(String.class).appendToFile(this.tmp.newFile("1.log").getAbsolutePath());
        Logger.JavaLogger l2 = new Logger.JavaLogger(Integer.class).appendToFile(this.tmp.newFile("2.log").getAbsolutePath());
        Logger logger1 = MultipleLoggerTest.getInnerLogger(l1);
        assert (logger1.getHandlers().length == 1);
        Logger logger2 = MultipleLoggerTest.getInnerLogger(l2);
        assert (logger2.getHandlers().length == 1);
    }
}

