/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Client;
import feign.Feign;
import feign.FeignBuilderTest;
import feign.RequestTemplate;
import feign.Response;
import feign.Util;
import feign.assertj.MockWebServerAssertions;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.io.Reader;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MethodMetadataPresenceTest {
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void client() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        FeignBuilderTest.TestInterface api = (FeignBuilderTest.TestInterface)Feign.builder().client((request, options) -> {
            Assert.assertNotNull((Object)request.requestTemplate());
            Assert.assertNotNull((Object)request.requestTemplate().methodMetadata());
            Assert.assertNotNull((Object)request.requestTemplate().feignTarget());
            return new Client.Default(null, null).execute(request, options);
        }).target(FeignBuilderTest.TestInterface.class, url);
        Response response = api.codecPost("request data");
        Assert.assertEquals((Object)"response data", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("request data");
    }

    @Test
    public void encoder() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        FeignBuilderTest.TestInterface api = (FeignBuilderTest.TestInterface)Feign.builder().encoder((object, bodyType, template) -> {
            Assert.assertNotNull((Object)template);
            Assert.assertNotNull((Object)template.methodMetadata());
            Assert.assertNotNull((Object)template.feignTarget());
            new Encoder.Default().encode(object, bodyType, template);
        }).target(FeignBuilderTest.TestInterface.class, url);
        Response response = api.codecPost("request data");
        Assert.assertEquals((Object)"response data", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("request data");
    }

    @Test
    public void decoder() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        FeignBuilderTest.TestInterface api = (FeignBuilderTest.TestInterface)Feign.builder().decoder((response, type) -> {
            RequestTemplate template = response.request().requestTemplate();
            Assert.assertNotNull((Object)template);
            Assert.assertNotNull((Object)template.methodMetadata());
            Assert.assertNotNull((Object)template.feignTarget());
            return new Decoder.Default().decode(response, type);
        }).target(FeignBuilderTest.TestInterface.class, url);
        Response response2 = api.codecPost("request data");
        Assert.assertEquals((Object)"response data", (Object)Util.toString((Reader)response2.body().asReader(Util.UTF_8)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("request data");
    }
}

