/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Body;
import feign.Feign;
import feign.FeignException;
import feign.Headers;
import feign.Logger;
import feign.Param;
import feign.Request;
import feign.RequestLine;
import feign.RetryableException;
import feign.Retryer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.SoftAssertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.model.Statement;

@RunWith(value=Enclosed.class)
public class LoggerTest {
    public final ExpectedException thrown = ExpectedException.none();
    public final MockWebServer server = new MockWebServer();
    public final RecordingLogger logger = new RecordingLogger();
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.server).around((TestRule)this.logger).around((TestRule)this.thrown);

    private static final class RecordingLogger
    extends Logger
    implements TestRule {
        private final List<String> messages = new ArrayList<String>();
        private final List<String> expectedMessages = new ArrayList<String>();

        private RecordingLogger() {
        }

        void expectMessages(List<String> expectedMessages) {
            this.expectedMessages.addAll(expectedMessages);
        }

        protected void log(String configKey, String format, Object ... args) {
            this.messages.add(RecordingLogger.methodTag((String)configKey) + String.format(format, args));
        }

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    base.evaluate();
                    SoftAssertions softly = new SoftAssertions();
                    softly.assertThat(messages.size()).isEqualTo(expectedMessages.size());
                    for (int i = 0; i < messages.size() && i < expectedMessages.size(); ++i) {
                        softly.assertThat((String)messages.get(i)).matches((CharSequence)expectedMessages.get(i));
                    }
                    softly.assertAll();
                }
            };
        }
    }

    @RunWith(value=Parameterized.class)
    public static class RetryEmitsTest
    extends LoggerTest {
        private final Logger.Level logLevel;

        public RetryEmitsTest(Logger.Level logLevel, List<String> expectedMessages) {
            this.logLevel = logLevel;
            this.logger.expectMessages(expectedMessages);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            return Arrays.asList({Logger.Level.NONE, Collections.emptyList()}, {Logger.Level.BASIC, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://robofu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: robofu.abc \\([0-9]+ms\\)", "\\[SendsStuff#login\\] ---> RETRYING", "\\[SendsStuff#login\\] ---> POST http://robofu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: robofu.abc \\([0-9]+ms\\)")});
        }

        @Test
        public void retryEmits() {
            this.thrown.expect(FeignException.class);
            SendsStuff api = (SendsStuff)Feign.builder().logger((Logger)this.logger).logLevel(this.logLevel).retryer(new Retryer(){
                boolean retried;

                public void continueOrPropagate(RetryableException e) {
                    if (!this.retried) {
                        this.retried = true;
                        return;
                    }
                    throw e;
                }

                public Retryer clone() {
                    return this;
                }
            }).target(SendsStuff.class, "http://robofu.abc");
            api.login("netflix", "denominator", "password");
        }
    }

    @RunWith(value=Parameterized.class)
    public static class FormatCharacterTest
    extends LoggerTest {
        private final Logger.Level logLevel;

        public FormatCharacterTest(Logger.Level logLevel, List<String> expectedMessages) {
            this.logLevel = logLevel;
            this.logger.expectMessages(expectedMessages);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            return Arrays.asList({Logger.Level.NONE, Collections.emptyList()}, {Logger.Level.BASIC, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://sna%fu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: sna%fu.abc \\([0-9]+ms\\)")}, {Logger.Level.HEADERS, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://sna%fu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: sna%fu.abc \\([0-9]+ms\\)")}, {Logger.Level.FULL, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://sna%fu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ", "\\[SendsStuff#login\\] \\{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"\\}", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: sna%fu.abc \\([0-9]+ms\\)", "(?s)\\[SendsStuff#login\\] java.net.UnknownHostException: sna%fu.abc.*", "\\[SendsStuff#login\\] <--- END ERROR")});
        }

        @Test
        public void formatCharacterEmits() {
            SendsStuff api = (SendsStuff)Feign.builder().logger((Logger)this.logger).logLevel(this.logLevel).retryer(new Retryer(){

                public void continueOrPropagate(RetryableException e) {
                    throw e;
                }

                public Retryer clone() {
                    return this;
                }
            }).target(SendsStuff.class, "http://sna%25fu.abc");
            this.thrown.expect(FeignException.class);
            api.login("netflix", "denominator", "password");
        }
    }

    @RunWith(value=Parameterized.class)
    public static class UnknownHostEmitsTest
    extends LoggerTest {
        private final Logger.Level logLevel;

        public UnknownHostEmitsTest(Logger.Level logLevel, List<String> expectedMessages) {
            this.logLevel = logLevel;
            this.logger.expectMessages(expectedMessages);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            return Arrays.asList({Logger.Level.NONE, Collections.emptyList()}, {Logger.Level.BASIC, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://robofu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: robofu.abc \\([0-9]+ms\\)")}, {Logger.Level.HEADERS, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://robofu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: robofu.abc \\([0-9]+ms\\)")}, {Logger.Level.FULL, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://robofu.abc/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ", "\\[SendsStuff#login\\] \\{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"\\}", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- ERROR UnknownHostException: robofu.abc \\([0-9]+ms\\)", "(?s)\\[SendsStuff#login\\] java.net.UnknownHostException: robofu.abc.*", "\\[SendsStuff#login\\] <--- END ERROR")});
        }

        @Test
        public void unknownHostEmits() {
            SendsStuff api = (SendsStuff)Feign.builder().logger((Logger)this.logger).logLevel(this.logLevel).retryer(new Retryer(){

                public void continueOrPropagate(RetryableException e) {
                    throw e;
                }

                public Retryer clone() {
                    return this;
                }
            }).target(SendsStuff.class, "http://robofu.abc");
            this.thrown.expect(FeignException.class);
            api.login("netflix", "denominator", "password");
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ReadTimeoutEmitsTest
    extends LoggerTest {
        private final Logger.Level logLevel;

        public ReadTimeoutEmitsTest(Logger.Level logLevel, List<String> expectedMessages) {
            this.logLevel = logLevel;
            this.logger.expectMessages(expectedMessages);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            return Arrays.asList({Logger.Level.NONE, Collections.emptyList()}, {Logger.Level.BASIC, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] <--- ERROR SocketTimeoutException: Read timed out \\([0-9]+ms\\)")}, {Logger.Level.HEADERS, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- ERROR SocketTimeoutException: Read timed out \\([0-9]+ms\\)")}, {Logger.Level.FULL, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ", "\\[SendsStuff#login\\] \\{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"\\}", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- ERROR SocketTimeoutException: Read timed out \\([0-9]+ms\\)", "(?s)\\[SendsStuff#login\\] java.net.SocketTimeoutException: Read timed out.*", "\\[SendsStuff#login\\] <--- END ERROR")});
        }

        @Test
        public void levelEmitsOnReadTimeout() {
            this.server.enqueue(new MockResponse().throttleBody(1L, 1L, TimeUnit.SECONDS).setBody("foo"));
            this.thrown.expect(FeignException.class);
            SendsStuff api = (SendsStuff)Feign.builder().logger((Logger)this.logger).logLevel(this.logLevel).options(new Request.Options(10000L, TimeUnit.MILLISECONDS, 50L, TimeUnit.MILLISECONDS, true)).retryer(new Retryer(){

                public void continueOrPropagate(RetryableException e) {
                    throw e;
                }

                public Retryer clone() {
                    return this;
                }
            }).target(SendsStuff.class, "http://localhost:" + this.server.getPort());
            api.login("netflix", "denominator", "password");
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ReasonPhraseOptional
    extends LoggerTest {
        private final Logger.Level logLevel;

        public ReasonPhraseOptional(Logger.Level logLevel, List<String> expectedMessages) {
            this.logLevel = logLevel;
            this.logger.expectMessages(expectedMessages);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            return Arrays.asList(new Object[][]{{Logger.Level.BASIC, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] <--- HTTP/1.1 200 \\([0-9]+ms\\)")}});
        }

        @Test
        public void reasonPhraseOptional() {
            this.server.enqueue(new MockResponse().setStatus("HTTP/1.1 200"));
            SendsStuff api = (SendsStuff)Feign.builder().logger((Logger)this.logger).logLevel(this.logLevel).target(SendsStuff.class, "http://localhost:" + this.server.getPort());
            api.login("netflix", "denominator", "password");
        }
    }

    @RunWith(value=Parameterized.class)
    public static class LogLevelEmitsTest
    extends LoggerTest {
        private final Logger.Level logLevel;

        public LogLevelEmitsTest(Logger.Level logLevel, List<String> expectedMessages) {
            this.logLevel = logLevel;
            this.logger.expectMessages(expectedMessages);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            return Arrays.asList({Logger.Level.NONE, Collections.emptyList()}, {Logger.Level.BASIC, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] <--- HTTP/1.1 200 OK \\([0-9]+ms\\)")}, {Logger.Level.HEADERS, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- HTTP/1.1 200 OK \\([0-9]+ms\\)", "\\[SendsStuff#login\\] content-length: 3", "\\[SendsStuff#login\\] <--- END HTTP \\(3-byte body\\)")}, {Logger.Level.FULL, Arrays.asList("\\[SendsStuff#login\\] ---> POST http://localhost:[0-9]+/ HTTP/1.1", "\\[SendsStuff#login\\] Content-Length: 80", "\\[SendsStuff#login\\] Content-Type: application/json", "\\[SendsStuff#login\\] ", "\\[SendsStuff#login\\] \\{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"\\}", "\\[SendsStuff#login\\] ---> END HTTP \\(80-byte body\\)", "\\[SendsStuff#login\\] <--- HTTP/1.1 200 OK \\([0-9]+ms\\)", "\\[SendsStuff#login\\] content-length: 3", "\\[SendsStuff#login\\] ", "\\[SendsStuff#login\\] foo", "\\[SendsStuff#login\\] <--- END HTTP \\(3-byte body\\)")});
        }

        @Test
        public void levelEmits() {
            this.server.enqueue(new MockResponse().setBody("foo"));
            SendsStuff api = (SendsStuff)Feign.builder().logger((Logger)this.logger).logLevel(this.logLevel).target(SendsStuff.class, "http://localhost:" + this.server.getPort());
            api.login("netflix", "denominator", "password");
        }
    }

    static interface SendsStuff {
        @RequestLine(value="POST /")
        @Headers(value={"Content-Type: application/json"})
        @Body(value="%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D")
        public String login(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);
    }
}

