/*
 * Decompiled with CFR 0.152.
 */
package feign;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import feign.Body;
import feign.ChildPojo;
import feign.CustomPojo;
import feign.ExceptionPropagationPolicy;
import feign.Feign;
import feign.FeignException;
import feign.HeaderMap;
import feign.Headers;
import feign.Param;
import feign.PropertyPojo;
import feign.QueryMap;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.RequestTemplate;
import feign.Response;
import feign.ResponseMapper;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.Util;
import feign.assertj.MockWebServerAssertions;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.codec.StringDecoder;
import feign.querymap.BeanQueryMapEncoder;
import feign.querymap.FieldQueryMapEncoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.util.Maps;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FeignTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void iterableQueryParams() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.queryParams("user", Arrays.asList("apple", "pear"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?1=user&2=apple&2=pear");
    }

    @Test
    public void arrayQueryMapParams() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.queryMapWithArrayValues(Maps.newHashMap((Object)"1", (Object)new String[]{"apple", "pear"}));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?1=apple&1=pear");
    }

    @Test
    public void postTemplateParamsResolve() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.login("netflix", "denominator", "password");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"}");
    }

    @Test
    public void postFormParams() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.form("netflix", "denominator", "password");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("{\"customer_name\":\"netflix\",\"user_name\":\"denominator\",\"password\":\"password\"}");
    }

    @Test
    public void postBodyParam() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.body(Arrays.asList("netflix", "denominator", "password"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Length", Collections.singletonList("32"))).hasBody("[netflix, denominator, password]");
    }

    @Test
    public void bodyTypeCorrespondsWithParameterType() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        final AtomicReference encodedType = new AtomicReference();
        TestInterface api = new TestInterfaceBuilder().encoder((Encoder)new Encoder.Default(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                encodedType.set(bodyType);
            }
        }).target("http://localhost:" + this.server.getPort());
        api.body(Arrays.asList("netflix", "denominator", "password"));
        this.server.takeRequest();
        MockWebServerAssertions.assertThat(encodedType.get()).isEqualTo((Object)new TypeToken<List<String>>(){}.getType());
    }

    @Test
    public void postGZIPEncodedBodyParam() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.gzipBody(Arrays.asList("netflix", "denominator", "password"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasNoHeaderNamed("Content-Length").hasGzippedBody("[netflix, denominator, password]".getBytes(Util.UTF_8));
    }

    @Test
    public void postDeflateEncodedBodyParam() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.deflateBody(Arrays.asList("netflix", "denominator", "password"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasNoHeaderNamed("Content-Length").hasDeflatedBody("[netflix, denominator, password]".getBytes(Util.UTF_8));
    }

    @Test
    public void singleInterceptor() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().requestInterceptor(new ForwardedForInterceptor()).target("http://localhost:" + this.server.getPort());
        api.post();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"X-Forwarded-For", Collections.singletonList("origin.host.com")));
    }

    @Test
    public void multipleInterceptor() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterface api = new TestInterfaceBuilder().requestInterceptor(new ForwardedForInterceptor()).requestInterceptor(new UserAgentInterceptor()).target("http://localhost:" + this.server.getPort());
        api.post();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"X-Forwarded-For", Collections.singletonList("origin.host.com")), MapEntry.entry((Object)"User-Agent", Collections.singletonList("Feign")));
    }

    @Test
    public void customExpander() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.expand(new Date(1234L));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?date=1234");
    }

    @Test
    public void customExpanderListParam() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.expandList(Arrays.asList(new Date(1234L), new Date(12345L)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?date=1234&date=12345");
    }

    @Test
    public void customExpanderNullParam() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.expandList(Arrays.asList(new Date(1234L), null));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?date=1234");
    }

    @Test
    public void headerMap() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
        headerMap.put("Content-Type", "myContent");
        headerMap.put("Custom-Header", "fooValue");
        api.headerMap(headerMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Type", Arrays.asList("myContent")), MapEntry.entry((Object)"Custom-Header", Arrays.asList("fooValue")));
    }

    @Test
    public void headerMapWithHeaderAnnotations() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
        headerMap.put("Custom-Header", "fooValue");
        api.headerMapWithHeaderAnnotations(headerMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Encoding", Collections.singletonList("deflate")), MapEntry.entry((Object)"Custom-Header", Collections.singletonList("fooValue")));
        this.server.enqueue(new MockResponse());
        headerMap.put("Content-Encoding", "overrideFromMap");
        api.headerMapWithHeaderAnnotations(headerMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Encoding", Arrays.asList("deflate", "overrideFromMap")), MapEntry.entry((Object)"Custom-Header", Collections.singletonList("fooValue")));
    }

    @Test
    public void queryMap() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("name", "alice");
        queryMap.put("fooKey", "fooValue");
        api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice&fooKey=fooValue");
    }

    @Test
    public void queryMapIterableValuesExpanded() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("name", Arrays.asList("Alice", "Bob"));
        queryMap.put("fooKey", "fooValue");
        queryMap.put("emptyListKey", new ArrayList());
        queryMap.put("emptyStringKey", "");
        api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=Alice&name=Bob&fooKey=fooValue&emptyStringKey");
    }

    @Test
    public void queryMapWithQueryParams() throws Exception {
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        this.server.enqueue(new MockResponse());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("fooKey", "fooValue");
        api.queryMapWithQueryParams("alice", queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice&fooKey=fooValue");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("name", "bob");
        api.queryMapWithQueryParams("alice", queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice&name=bob");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("name", null);
        api.queryMapWithQueryParams("alice", queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice");
    }

    @Test
    public void queryMapValueStartingWithBrace() throws Exception {
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        this.server.enqueue(new MockResponse());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("name", "{alice");
        api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=%7Balice");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("{name", "alice");
        api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?%7Bname=alice");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("name", "%7Balice");
        api.queryMapEncoded(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=%7Balice");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("%7Bname", "%7Balice");
        api.queryMapEncoded(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?%7Bname=%7Balice");
    }

    @Test
    public void queryMapPojoWithFullParams() throws Exception {
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        CustomPojo customPojo = new CustomPojo("Name", 3);
        this.server.enqueue(new MockResponse());
        api.queryMapPojo(customPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams(Arrays.asList("name=Name", "number=3"));
    }

    @Test
    public void queryMapPojoWithPartialParams() throws Exception {
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        CustomPojo customPojo = new CustomPojo("Name", null);
        this.server.enqueue(new MockResponse());
        api.queryMapPojo(customPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=Name");
    }

    @Test
    public void queryMapPojoWithEmptyParams() throws Exception {
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        CustomPojo customPojo = new CustomPojo(null, null);
        this.server.enqueue(new MockResponse());
        api.queryMapPojo(customPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/");
    }

    @Test
    public void configKeyFormatsAsExpected() throws Exception {
        Assert.assertEquals((Object)"TestInterface#post()", (Object)Feign.configKey(TestInterface.class, (Method)TestInterface.class.getDeclaredMethod("post", new Class[0])));
        Assert.assertEquals((Object)"TestInterface#uriParam(String,URI,String)", (Object)Feign.configKey(TestInterface.class, (Method)TestInterface.class.getDeclaredMethod("uriParam", String.class, URI.class, String.class)));
    }

    @Test
    public void configKeyUsesChildType() throws Exception {
        Assert.assertEquals((Object)"List#iterator()", (Object)Feign.configKey(List.class, (Method)Iterable.class.getDeclaredMethod("iterator", new Class[0])));
    }

    @Test
    public void canOverrideErrorDecoder() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(400).setBody("foo"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("bad zone name");
        TestInterface api = new TestInterfaceBuilder().errorDecoder((ErrorDecoder)new IllegalArgumentExceptionOn400()).target("http://localhost:" + this.server.getPort());
        api.post();
    }

    @Test
    public void retriesLostConnectionBeforeRead() throws Exception {
        this.server.enqueue(new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_START));
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.post();
        Assert.assertEquals((long)2L, (long)this.server.getRequestCount());
    }

    @Test
    public void overrideTypeSpecificDecoder() throws Exception {
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterface api = new TestInterfaceBuilder().decoder(new Decoder(){

            public Object decode(Response response, Type type) {
                return "fail";
            }
        }).target("http://localhost:" + this.server.getPort());
        Assert.assertEquals((Object)api.post(), (Object)"fail");
    }

    @Test
    public void retryableExceptionInDecoder() throws Exception {
        this.server.enqueue(new MockResponse().setBody("retry!"));
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterface api = new TestInterfaceBuilder().decoder((Decoder)new StringDecoder(){

            public Object decode(Response response, Type type) throws IOException {
                String string = super.decode(response, type).toString();
                if ("retry!".equals(string)) {
                    throw new RetryableException(response.status(), string, Request.HttpMethod.POST, null, response.request());
                }
                return string;
            }
        }).target("http://localhost:" + this.server.getPort());
        Assert.assertEquals((Object)api.post(), (Object)"success!");
        Assert.assertEquals((long)2L, (long)this.server.getRequestCount());
    }

    @Test
    public void doesntRetryAfterResponseIsSent() throws Exception {
        this.server.enqueue(new MockResponse().setBody("success!"));
        this.thrown.expect(FeignException.class);
        this.thrown.expectMessage("timeout reading POST http://");
        TestInterface api = new TestInterfaceBuilder().decoder(new Decoder(){

            public Object decode(Response response, Type type) throws IOException {
                throw new IOException("timeout");
            }
        }).target("http://localhost:" + this.server.getPort());
        api.post();
    }

    @Test
    public void throwsFeignExceptionIncludingBody() {
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterface api = (TestInterface)Feign.builder().decoder((response, type) -> {
            throw new IOException("timeout");
        }).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        try {
            api.body("Request body");
        }
        catch (FeignException e) {
            MockWebServerAssertions.assertThat((String)e.getMessage()).isEqualTo("timeout reading POST http://localhost:" + this.server.getPort() + "/");
            MockWebServerAssertions.assertThat((String)e.contentUTF8()).isEqualTo("Request body");
        }
    }

    @Test
    public void throwsFeignExceptionWithoutBody() {
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterface api = (TestInterface)Feign.builder().decoder((response, type) -> {
            throw new IOException("timeout");
        }).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        try {
            api.noContent();
        }
        catch (FeignException e) {
            MockWebServerAssertions.assertThat((String)e.getMessage()).isEqualTo("timeout reading POST http://localhost:" + this.server.getPort() + "/");
            MockWebServerAssertions.assertThat((String)e.contentUTF8()).isEqualTo("");
        }
    }

    @Test
    public void ensureRetryerClonesItself() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(503).setBody("foo 1"));
        this.server.enqueue(new MockResponse().setResponseCode(200).setBody("foo 2"));
        this.server.enqueue(new MockResponse().setResponseCode(503).setBody("foo 3"));
        this.server.enqueue(new MockResponse().setResponseCode(200).setBody("foo 4"));
        MockRetryer retryer = new MockRetryer();
        TestInterface api = (TestInterface)Feign.builder().retryer((Retryer)retryer).errorDecoder(new ErrorDecoder(){

            public Exception decode(String methodKey, Response response) {
                return new RetryableException(response.status(), "play it again sam!", Request.HttpMethod.POST, null, response.request());
            }
        }).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.post();
        api.post();
        Assert.assertEquals((long)4L, (long)this.server.getRequestCount());
    }

    @Test
    public void throwsOriginalExceptionAfterFailedRetries() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(503).setBody("foo 1"));
        this.server.enqueue(new MockResponse().setResponseCode(503).setBody("foo 2"));
        String message = "the innerest";
        this.thrown.expect(TestInterfaceException.class);
        this.thrown.expectMessage("the innerest");
        TestInterface api = (TestInterface)Feign.builder().exceptionPropagationPolicy(ExceptionPropagationPolicy.UNWRAP).retryer((Retryer)new Retryer.Default(1L, 1L, 2)).errorDecoder(new ErrorDecoder(){

            public Exception decode(String methodKey, Response response) {
                return new RetryableException(response.status(), "play it again sam!", Request.HttpMethod.POST, (Throwable)new TestInterfaceException("the innerest"), null, response.request());
            }
        }).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.post();
    }

    @Test
    public void throwsRetryableExceptionIfNoUnderlyingCause() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(503).setBody("foo 1"));
        this.server.enqueue(new MockResponse().setResponseCode(503).setBody("foo 2"));
        final String message = "play it again sam!";
        this.thrown.expect(RetryableException.class);
        this.thrown.expectMessage(message);
        TestInterface api = (TestInterface)Feign.builder().exceptionPropagationPolicy(ExceptionPropagationPolicy.UNWRAP).retryer((Retryer)new Retryer.Default(1L, 1L, 2)).errorDecoder(new ErrorDecoder(){

            public Exception decode(String methodKey, Response response) {
                return new RetryableException(response.status(), message, Request.HttpMethod.POST, null, response.request());
            }
        }).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        api.post();
    }

    @Test
    public void whenReturnTypeIsResponseNoErrorHandling() {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        headers.put("Location", Collections.singletonList("http://bar.com"));
        Response response = Response.builder().status(302).reason("Found").headers(headers).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body(new byte[0]).build();
        TestInterface api = (TestInterface)Feign.builder().client((request, options) -> response).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        MockWebServerAssertions.assertThat((Map)api.response().headers()).hasEntrySatisfying((Object)"Location", value -> MockWebServerAssertions.assertThat((Collection)value).contains((Object[])new String[]{"http://bar.com"}));
    }

    @Test
    public void okIfDecodeRootCauseHasNoMessage() throws Exception {
        this.server.enqueue(new MockResponse().setBody("success!"));
        this.thrown.expect(DecodeException.class);
        TestInterface api = new TestInterfaceBuilder().decoder(new Decoder(){

            public Object decode(Response response, Type type) throws IOException {
                throw new RuntimeException();
            }
        }).target("http://localhost:" + this.server.getPort());
        api.post();
    }

    @Test
    public void decodingExceptionGetWrappedInDecode404Mode() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.thrown.expect(DecodeException.class);
        this.thrown.expectCause(CoreMatchers.isA(NoSuchElementException.class));
        TestInterface api = new TestInterfaceBuilder().decode404().decoder(new Decoder(){

            public Object decode(Response response, Type type) throws IOException {
                Assert.assertEquals((long)404L, (long)response.status());
                throw new NoSuchElementException();
            }
        }).target("http://localhost:" + this.server.getPort());
        api.post();
    }

    @Test
    public void decodingDoesNotSwallow404ErrorsInDecode404Mode() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.thrown.expect(IllegalArgumentException.class);
        TestInterface api = new TestInterfaceBuilder().decode404().errorDecoder((ErrorDecoder)new IllegalArgumentExceptionOn404()).target("http://localhost:" + this.server.getPort());
        api.queryMap(Collections.emptyMap());
    }

    @Test
    public void okIfEncodeRootCauseHasNoMessage() throws Exception {
        this.server.enqueue(new MockResponse().setBody("success!"));
        this.thrown.expect(EncodeException.class);
        TestInterface api = new TestInterfaceBuilder().encoder(new Encoder(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                throw new RuntimeException();
            }
        }).target("http://localhost:" + this.server.getPort());
        api.body(Arrays.asList("foo"));
    }

    @Test
    public void equalsHashCodeAndToStringWork() {
        Target.HardCodedTarget t1 = new Target.HardCodedTarget(TestInterface.class, "http://localhost:8080");
        Target.HardCodedTarget t2 = new Target.HardCodedTarget(TestInterface.class, "http://localhost:8888");
        Target.HardCodedTarget t3 = new Target.HardCodedTarget(OtherTestInterface.class, "http://localhost:8080");
        TestInterface i1 = (TestInterface)Feign.builder().target((Target)t1);
        TestInterface i2 = (TestInterface)Feign.builder().target((Target)t1);
        TestInterface i3 = (TestInterface)Feign.builder().target((Target)t2);
        OtherTestInterface i4 = (OtherTestInterface)Feign.builder().target((Target)t3);
        ((ObjectAssert)((ObjectAssert)MockWebServerAssertions.assertThat((Object)i1).isEqualTo((Object)i2)).isNotEqualTo((Object)i3)).isNotEqualTo((Object)i4);
        MockWebServerAssertions.assertThat((int)i1.hashCode()).isEqualTo(i2.hashCode()).isNotEqualTo(i3.hashCode()).isNotEqualTo(i4.hashCode());
        ((AbstractStringAssert)MockWebServerAssertions.assertThat((String)i1.toString()).isEqualTo(i2.toString()).isNotEqualTo((Object)i3.toString())).isNotEqualTo((Object)i4.toString());
        MockWebServerAssertions.assertThat((Object)t1).isNotEqualTo((Object)i1);
        MockWebServerAssertions.assertThat((int)t1.hashCode()).isEqualTo(i1.hashCode());
        MockWebServerAssertions.assertThat((String)t1.toString()).isEqualTo(i1.toString());
    }

    @Test
    public void decodeLogicSupportsByteArray() throws Exception {
        byte[] expectedResponse = new byte[]{12, 34, 56};
        this.server.enqueue(new MockResponse().setBody(new Buffer().write(expectedResponse)));
        OtherTestInterface api = (OtherTestInterface)Feign.builder().target(OtherTestInterface.class, "http://localhost:" + this.server.getPort());
        MockWebServerAssertions.assertThat((byte[])api.binaryResponseBody()).containsExactly(expectedResponse);
    }

    @Test
    public void encodeLogicSupportsByteArray() throws Exception {
        byte[] expectedRequest = new byte[]{12, 34, 56};
        this.server.enqueue(new MockResponse());
        OtherTestInterface api = (OtherTestInterface)Feign.builder().target(OtherTestInterface.class, "http://localhost:" + this.server.getPort());
        api.binaryRequestBody(expectedRequest);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody(expectedRequest);
    }

    @Test
    public void encodedQueryParam() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterface api = new TestInterfaceBuilder().target("http://localhost:" + this.server.getPort());
        api.encodedQueryParam("5.2FSi+");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?trim=5.2FSi%2B");
    }

    @Test
    public void responseMapperIsAppliedBeforeDelegate() throws IOException {
        Feign.ResponseMappingDecoder decoder = new Feign.ResponseMappingDecoder(this.upperCaseResponseMapper(), (Decoder)new StringDecoder());
        String output = (String)decoder.decode(this.responseWithText("response"), String.class);
        MockWebServerAssertions.assertThat((String)output).isEqualTo("RESPONSE");
    }

    private ResponseMapper upperCaseResponseMapper() {
        return new ResponseMapper(){

            public Response map(Response response, Type type) {
                try {
                    return response.toBuilder().body(Util.toString((Reader)response.body().asReader(Util.UTF_8)).toUpperCase().getBytes()).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Response responseWithText(String text) {
        return Response.builder().body(text, Util.UTF_8).status(200).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(new HashMap()).build();
    }

    @Test
    public void mapAndDecodeExecutesMapFunction() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response!"));
        TestInterface api = (TestInterface)new Feign.Builder().mapAndDecode(this.upperCaseResponseMapper(), (Decoder)new StringDecoder()).target(TestInterface.class, "http://localhost:" + this.server.getPort());
        Assert.assertEquals((Object)api.post(), (Object)"RESPONSE!");
    }

    @Test
    public void beanQueryMapEncoderWithPrivateGetterIgnored() throws Exception {
        TestInterface api = new TestInterfaceBuilder().queryMapEndcoder((QueryMapEncoder)new BeanQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        PropertyPojo.ChildPojoClass propertyPojo = new PropertyPojo.ChildPojoClass();
        propertyPojo.setPrivateGetterProperty("privateGetterProperty");
        propertyPojo.setName("Name");
        propertyPojo.setNumber(1);
        this.server.enqueue(new MockResponse());
        api.queryMapPropertyPojo(propertyPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams(Arrays.asList("name=Name", "number=1"));
    }

    @Test
    public void queryMap_with_child_pojo() throws Exception {
        TestInterface api = new TestInterfaceBuilder().queryMapEndcoder((QueryMapEncoder)new FieldQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        ChildPojo childPojo = new ChildPojo();
        childPojo.setChildPrivateProperty("first");
        childPojo.setParentProtectedProperty("second");
        childPojo.setParentPublicProperty("third");
        this.server.enqueue(new MockResponse());
        api.queryMapPropertyInheritence(childPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams("parentPublicProperty=third", "parentProtectedProperty=second", "childPrivateProperty=first");
    }

    @Test
    public void beanQueryMapEncoderWithNullValueIgnored() throws Exception {
        TestInterface api = new TestInterfaceBuilder().queryMapEndcoder((QueryMapEncoder)new BeanQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        PropertyPojo.ChildPojoClass propertyPojo = new PropertyPojo.ChildPojoClass();
        propertyPojo.setName(null);
        propertyPojo.setNumber(1);
        this.server.enqueue(new MockResponse());
        api.queryMapPropertyPojo(propertyPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams("number=1");
    }

    @Test
    public void beanQueryMapEncoderWithEmptyParams() throws Exception {
        TestInterface api = new TestInterfaceBuilder().queryMapEndcoder((QueryMapEncoder)new BeanQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        PropertyPojo.ChildPojoClass propertyPojo = new PropertyPojo.ChildPojoClass();
        this.server.enqueue(new MockResponse());
        api.queryMapPropertyPojo(propertyPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams("/");
    }

    static final class TestInterfaceBuilder {
        private final Feign.Builder delegate = new Feign.Builder().decoder((Decoder)new Decoder.Default()).encoder(new Encoder(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                if (object instanceof Map) {
                    template.body(new Gson().toJson(object));
                } else {
                    template.body(object.toString());
                }
            }
        });

        TestInterfaceBuilder() {
        }

        TestInterfaceBuilder requestInterceptor(RequestInterceptor requestInterceptor) {
            this.delegate.requestInterceptor(requestInterceptor);
            return this;
        }

        TestInterfaceBuilder encoder(Encoder encoder) {
            this.delegate.encoder(encoder);
            return this;
        }

        TestInterfaceBuilder decoder(Decoder decoder) {
            this.delegate.decoder(decoder);
            return this;
        }

        TestInterfaceBuilder errorDecoder(ErrorDecoder errorDecoder) {
            this.delegate.errorDecoder(errorDecoder);
            return this;
        }

        TestInterfaceBuilder decode404() {
            this.delegate.decode404();
            return this;
        }

        TestInterfaceBuilder queryMapEndcoder(QueryMapEncoder queryMapEncoder) {
            this.delegate.queryMapEncoder(queryMapEncoder);
            return this;
        }

        TestInterface target(String url) {
            return (TestInterface)this.delegate.target(TestInterface.class, url);
        }
    }

    static class IllegalArgumentExceptionOn404
    extends ErrorDecoder.Default {
        IllegalArgumentExceptionOn404() {
        }

        public Exception decode(String methodKey, Response response) {
            if (response.status() == 404) {
                return new IllegalArgumentException("bad zone name");
            }
            return super.decode(methodKey, response);
        }
    }

    static class IllegalArgumentExceptionOn400
    extends ErrorDecoder.Default {
        IllegalArgumentExceptionOn400() {
        }

        public Exception decode(String methodKey, Response response) {
            if (response.status() == 400) {
                return new IllegalArgumentException("bad zone name");
            }
            return super.decode(methodKey, response);
        }
    }

    static class UserAgentInterceptor
    implements RequestInterceptor {
        UserAgentInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("User-Agent", new String[]{"Feign"});
        }
    }

    static class ForwardedForInterceptor
    implements RequestInterceptor {
        ForwardedForInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("X-Forwarded-For", new String[]{"origin.host.com"});
        }
    }

    static interface OtherTestInterface {
        @RequestLine(value="POST /")
        public String post();

        @RequestLine(value="POST /")
        public byte[] binaryResponseBody();

        @RequestLine(value="POST /")
        public void binaryRequestBody(byte[] var1);
    }

    class TestInterfaceException
    extends Exception {
        TestInterfaceException(String message) {
            super(message);
        }
    }

    static interface TestInterface {
        @RequestLine(value="POST /")
        public Response response();

        @RequestLine(value="POST /")
        public String post() throws TestInterfaceException;

        @RequestLine(value="POST /")
        @Body(value="%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D")
        public void login(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);

        @RequestLine(value="POST /")
        public void body(List<String> var1);

        @RequestLine(value="POST /")
        public String body(String var1);

        @RequestLine(value="POST /")
        public String noContent();

        @RequestLine(value="POST /")
        @Headers(value={"Content-Encoding: gzip"})
        public void gzipBody(List<String> var1);

        @RequestLine(value="POST /")
        @Headers(value={"Content-Encoding: deflate"})
        public void deflateBody(List<String> var1);

        @RequestLine(value="POST /")
        public void form(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);

        @RequestLine(value="GET /{1}/{2}")
        public Response uriParam(@Param(value="1") String var1, URI var2, @Param(value="2") String var3);

        @RequestLine(value="GET /?1={1}&2={2}")
        public Response queryParams(@Param(value="1") String var1, @Param(value="2") Iterable<String> var2);

        @RequestLine(value="GET /")
        public Response queryMapWithArrayValues(@QueryMap Map<String, String[]> var1);

        @RequestLine(value="POST /?date={date}")
        public void expand(@Param(value="date", expander=DateToMillis.class) Date var1);

        @RequestLine(value="GET /?date={date}")
        public void expandList(@Param(value="date", expander=DateToMillis.class) List<Date> var1);

        @RequestLine(value="GET /?date={date}")
        public void expandArray(@Param(value="date", expander=DateToMillis.class) Date[] var1);

        @RequestLine(value="GET /")
        public void headerMap(@HeaderMap Map<String, Object> var1);

        @RequestLine(value="GET /")
        @Headers(value={"Content-Encoding: deflate"})
        public void headerMapWithHeaderAnnotations(@HeaderMap Map<String, Object> var1);

        @RequestLine(value="GET /")
        public void queryMap(@QueryMap Map<String, Object> var1);

        @RequestLine(value="GET /")
        public void queryMapEncoded(@QueryMap(encoded=true) Map<String, Object> var1);

        @RequestLine(value="GET /?name={name}")
        public void queryMapWithQueryParams(@Param(value="name") String var1, @QueryMap Map<String, Object> var2);

        @RequestLine(value="GET /?trim={trim}")
        public void encodedQueryParam(@Param(value="trim") String var1);

        @RequestLine(value="GET /")
        public void queryMapPojo(@QueryMap CustomPojo var1);

        @RequestLine(value="GET /")
        public void queryMapPropertyPojo(@QueryMap PropertyPojo var1);

        @RequestLine(value="GET /")
        public void queryMapPropertyInheritence(@QueryMap ChildPojo var1);

        public static class DateToMillis
        implements Param.Expander {
            public String expand(Object value) {
                return String.valueOf(((Date)value).getTime());
            }
        }
    }

    private static class MockRetryer
    implements Retryer {
        boolean tripped;

        private MockRetryer() {
        }

        public void continueOrPropagate(RetryableException e) {
            if (this.tripped) {
                throw new RuntimeException("retryer instance should never be reused");
            }
            this.tripped = true;
        }

        public Retryer clone() {
            return new MockRetryer();
        }
    }
}

