/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class FeignExceptionTest {
    @Test
    public void canCreateWithRequestAndResponse() {
        Request request = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/home", Collections.emptyMap(), (byte[])"data".getBytes(StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8, null);
        Response response = Response.builder().status(400).body("response".getBytes(StandardCharsets.UTF_8)).request(request).build();
        FeignException exception = FeignException.errorReading((Request)request, (Response)response, (IOException)new IOException("socket closed"));
        Assertions.assertThat((Optional)exception.responseBody()).isNotEmpty();
        Assertions.assertThat((boolean)exception.hasRequest()).isTrue();
        Assertions.assertThat((Object)exception.request()).isNotNull();
    }

    @Test
    public void canCreateWithRequestOnly() {
        Request request = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/home", Collections.emptyMap(), (byte[])"data".getBytes(StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8, null);
        FeignException exception = FeignException.errorExecuting((Request)request, (IOException)new IOException("connection timeout"));
        Assertions.assertThat((Optional)exception.responseBody()).isEmpty();
        Assertions.assertThat((byte[])exception.content()).isNullOrEmpty();
        Assertions.assertThat((boolean)exception.hasRequest()).isTrue();
        Assertions.assertThat((Object)exception.request()).isNotNull();
    }

    @Test
    public void createFeignExceptionWithCorrectCharsetResponse() {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("connection", new ArrayList<String>(Collections.singletonList("keep-alive")));
        map.put("content-length", new ArrayList<String>(Collections.singletonList("100")));
        map.put("content-type", new ArrayList<String>(Collections.singletonList("application/json;charset=UTF-16BE")));
        Request request = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/home", Collections.emptyMap(), (byte[])"data".getBytes(StandardCharsets.UTF_16BE), (Charset)StandardCharsets.UTF_16BE, null);
        Response response = Response.builder().status(400).body("response".getBytes(StandardCharsets.UTF_16BE)).headers(map).request(request).build();
        FeignException exception = FeignException.errorStatus((String)"methodKey", (Response)response);
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("[400] during [GET] to [/home] [methodKey]: [response]");
    }

    @Test
    public void createFeignExceptionWithErrorCharsetResponse() {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("connection", new ArrayList<String>(Collections.singletonList("keep-alive")));
        map.put("content-length", new ArrayList<String>(Collections.singletonList("100")));
        map.put("content-type", new ArrayList<String>(Collections.singletonList("application/json;charset=UTF-8")));
        Request request = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/home", Collections.emptyMap(), (byte[])"data".getBytes(StandardCharsets.UTF_16BE), (Charset)StandardCharsets.UTF_16BE, null);
        Response response = Response.builder().status(400).body("response".getBytes(StandardCharsets.UTF_16BE)).headers(map).request(request).build();
        FeignException exception = FeignException.errorStatus((String)"methodKey", (Response)response);
        Assertions.assertThat((String)exception.getMessage()).isNotEqualTo((Object)"[400] during [GET] to [/home] [methodKey]: [response]");
    }

    @Test
    public void canGetResponseHeadersFromException() {
        Request request = Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/home", Collections.emptyMap(), (byte[])"data".getBytes(StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8, null);
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        responseHeaders.put("Content-Type", Collections.singletonList("text/plain"));
        responseHeaders.put("Cookie", Arrays.asList("cookie1", "cookie2"));
        Response response = Response.builder().request(request).body("some text", StandardCharsets.UTF_8).headers(responseHeaders).build();
        FeignException exception = FeignException.errorStatus((String)"methodKey", (Response)response);
        ((MapAssert)Assertions.assertThat((Map)exception.responseHeaders()).hasEntrySatisfying((Object)"Content-Type", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"text/plain"}))).hasEntrySatisfying((Object)"Cookie", value -> Assertions.assertThat((Collection)value).contains((Object[])new String[]{"cookie1", "cookie2"}));
    }

    @Test(expected=NullPointerException.class)
    public void nullRequestShouldThrowNPEwThrowable() {
        new Derived(404, "message", null, new Throwable());
    }

    @Test(expected=NullPointerException.class)
    public void nullRequestShouldThrowNPEwThrowableAndBytes() {
        new Derived(404, "message", null, new Throwable(), new byte[1], Collections.emptyMap());
    }

    @Test(expected=NullPointerException.class)
    public void nullRequestShouldThrowNPE() {
        new Derived(404, "message", null);
    }

    @Test(expected=NullPointerException.class)
    public void nullRequestShouldThrowNPEwBytes() {
        new Derived(404, "message", null, new byte[1], Collections.emptyMap());
    }

    static class Derived
    extends FeignException {
        public Derived(int status, String message, Request request, Throwable cause) {
            super(status, message, request, cause);
        }

        public Derived(int status, String message, Request request, Throwable cause, byte[] content, Map<String, Collection<String>> headers) {
            super(status, message, request, cause, content, headers);
        }

        public Derived(int status, String message, Request request) {
            super(status, message, request);
        }

        public Derived(int status, String message, Request request, byte[] content, Map<String, Collection<String>> headers) {
            super(status, message, request, content, headers);
        }
    }
}

