/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Param;
import feign.QueryMap;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.Response;
import feign.Target;
import feign.Util;
import feign.assertj.MockWebServerAssertions;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class FeignBuilderTest {
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void testDefaults() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        Response response = api.codecPost("request data");
        Assert.assertEquals((Object)"response data", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("request data");
    }

    @Test
    public void testDecode404() {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.server.enqueue(new MockResponse().setResponseCode(400));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().decode404().target(TestInterface.class, url);
        MockWebServerAssertions.assertThat((byte[])api.getQueues("/")).isEmpty();
        MockWebServerAssertions.assertThat((boolean)api.decodedLazyPost().hasNext()).isFalse();
        MockWebServerAssertions.assertThat(api.optionalContent()).isEmpty();
        MockWebServerAssertions.assertThat(api.streamPost()).isEmpty();
        MockWebServerAssertions.assertThat((String)api.decodedPost()).isNull();
        try {
            api.decodedPost();
            Assertions.failBecauseExceptionWasNotThrown(FeignException.class);
        }
        catch (FeignException e) {
            MockWebServerAssertions.assertThat((int)e.status()).isEqualTo(400);
        }
    }

    @Test
    public void testDecode204() {
        this.server.enqueue(new MockResponse().setResponseCode(204));
        this.server.enqueue(new MockResponse().setResponseCode(204));
        this.server.enqueue(new MockResponse().setResponseCode(204));
        this.server.enqueue(new MockResponse().setResponseCode(204));
        this.server.enqueue(new MockResponse().setResponseCode(204));
        this.server.enqueue(new MockResponse().setResponseCode(400));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        MockWebServerAssertions.assertThat((byte[])api.getQueues("/")).isEmpty();
        MockWebServerAssertions.assertThat((boolean)api.decodedLazyPost().hasNext()).isFalse();
        MockWebServerAssertions.assertThat(api.optionalContent()).isEmpty();
        MockWebServerAssertions.assertThat(api.streamPost()).isEmpty();
        MockWebServerAssertions.assertThat((String)api.decodedPost()).isNull();
        try {
            api.decodedPost();
            Assertions.failBecauseExceptionWasNotThrown(FeignException.class);
        }
        catch (FeignException e) {
            MockWebServerAssertions.assertThat((int)e.status()).isEqualTo(400);
        }
    }

    @Test
    public void testNoFollowRedirect() {
        this.server.enqueue(new MockResponse().setResponseCode(302).addHeader("Location", (Object)"/"));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface noFollowApi = (TestInterface)Feign.builder().options(new Request.Options(100L, TimeUnit.MILLISECONDS, 600L, TimeUnit.MILLISECONDS, false)).target(TestInterface.class, url);
        Response response = noFollowApi.defaultMethodPassthrough();
        MockWebServerAssertions.assertThat((int)response.status()).isEqualTo(302);
        MockWebServerAssertions.assertThat((Map)response.headers()).hasEntrySatisfying((Object)"Location", value -> MockWebServerAssertions.assertThat((Collection)value).contains((Object[])new String[]{"/"}));
        this.server.enqueue(new MockResponse().setResponseCode(302).addHeader("Location", (Object)"/"));
        this.server.enqueue(new MockResponse().setResponseCode(200));
        TestInterface defaultApi = (TestInterface)Feign.builder().options(new Request.Options(100L, TimeUnit.MILLISECONDS, 600L, TimeUnit.MILLISECONDS, true)).target(TestInterface.class, url);
        MockWebServerAssertions.assertThat((int)defaultApi.defaultMethodPassthrough().status()).isEqualTo(200);
    }

    @Test
    public void testUrlPathConcatUrlTrailingSlash() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort() + "/";
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        api.codecPost("request data");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/");
    }

    @Test
    public void testUrlPathConcatNoPathOnRequestLine() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort() + "/";
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        api.getNoPath();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/");
    }

    @Test
    public void testHttpNotFoundError() {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        String url = "http://localhost:" + this.server.getPort() + "/";
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        try {
            api.getBodyAsString();
            Assertions.failBecauseExceptionWasNotThrown(FeignException.class);
        }
        catch (FeignException.NotFound e) {
            MockWebServerAssertions.assertThat((int)e.status()).isEqualTo(404);
        }
    }

    @Test
    public void testUrlPathConcatNoInitialSlashOnPath() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort() + "/";
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        api.getNoInitialSlashOnSlash();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/api/thing");
    }

    @Test
    public void testUrlPathConcatNoInitialSlashOnPathNoTrailingSlashOnUrl() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        api.getNoInitialSlashOnSlash();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/api/thing");
    }

    @Test
    public void testOverrideEncoder() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        Encoder encoder = (object, bodyType, template) -> template.body(object.toString());
        TestInterface api = (TestInterface)Feign.builder().encoder(encoder).target(TestInterface.class, url);
        api.encodedPost(Arrays.asList("This", "is", "my", "request"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("[This, is, my, request]");
    }

    @Test
    public void testOverrideDecoder() {
        this.server.enqueue(new MockResponse().setBody("success!"));
        String url = "http://localhost:" + this.server.getPort();
        Decoder decoder = (response, type) -> "fail";
        TestInterface api = (TestInterface)Feign.builder().decoder(decoder).target(TestInterface.class, url);
        Assert.assertEquals((Object)"fail", (Object)api.decodedPost());
        Assert.assertEquals((long)1L, (long)this.server.getRequestCount());
    }

    @Test
    public void testOverrideQueryMapEncoder() throws Exception {
        this.server.enqueue(new MockResponse());
        String url = "http://localhost:" + this.server.getPort();
        QueryMapEncoder customMapEncoder = ignored -> {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("key1", "value1");
            queryMap.put("key2", "value2");
            return queryMap;
        };
        TestInterface api = (TestInterface)Feign.builder().queryMapEncoder(customMapEncoder).target(TestInterface.class, url);
        api.queryMapEncoded("ignored");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams(Arrays.asList("key1=value1", "key2=value2"));
        Assert.assertEquals((long)1L, (long)this.server.getRequestCount());
    }

    @Test
    public void testProvideRequestInterceptors() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        RequestInterceptor requestInterceptor = template -> template.header("Content-Type", new String[]{"text/plain"});
        TestInterface api = (TestInterface)Feign.builder().requestInterceptor(requestInterceptor).target(TestInterface.class, url);
        Response response = api.codecPost("request data");
        Assert.assertEquals((Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)), (Object)"response data");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Type", Collections.singletonList("text/plain"))).hasBody("request data");
    }

    @Test
    public void testProvideInvocationHandlerFactory() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        final AtomicInteger callCount = new AtomicInteger();
        InvocationHandlerFactory factory = new InvocationHandlerFactory(){
            private final InvocationHandlerFactory delegate = new InvocationHandlerFactory.Default();

            public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
                callCount.incrementAndGet();
                return this.delegate.create(target, dispatch);
            }
        };
        TestInterface api = (TestInterface)Feign.builder().invocationHandlerFactory(factory).target(TestInterface.class, url);
        Response response = api.codecPost("request data");
        Assert.assertEquals((Object)"response data", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
        Assert.assertEquals((long)1L, (long)callCount.get());
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("request data");
    }

    @Test
    public void testSlashIsEncodedInPathParams() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        api.getQueues("/");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/api/queues/%2F");
    }

    @Test
    public void testBasicDefaultMethod() {
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        String result = api.independentDefaultMethod();
        MockWebServerAssertions.assertThat((boolean)result.equals("default result")).isTrue();
    }

    @Test
    public void testDefaultCallingProxiedMethod() throws Exception {
        this.server.enqueue(new MockResponse().setBody("response data"));
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().target(TestInterface.class, url);
        Response response = api.defaultMethodPassthrough();
        Assert.assertEquals((Object)"response data", (Object)Util.toString((Reader)response.body().asReader(Util.UTF_8)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/");
    }

    @Test
    public void testDoNotCloseAfterDecode() {
        this.server.enqueue(new MockResponse().setBody("success!"));
        String url = "http://localhost:" + this.server.getPort();
        Decoder decoder = (response, type) -> new Iterator<Object>(){
            private boolean called = false;

            @Override
            public boolean hasNext() {
                return !this.called;
            }

            @Override
            public Object next() {
                try {
                    String string = Util.toString((Reader)response.body().asReader(Util.UTF_8));
                    return string;
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    Object var2_3 = null;
                    return var2_3;
                }
                finally {
                    Util.ensureClosed((Closeable)response);
                    this.called = true;
                }
            }
        };
        TestInterface api = (TestInterface)Feign.builder().decoder(decoder).doNotCloseAfterDecode().target(TestInterface.class, url);
        Iterator<String> iterator = api.decodedLazyPost();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"success!", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)this.server.getRequestCount());
    }

    @Test
    public void testDoNotCloseAfterDecodeDecoderFailure() {
        this.server.enqueue(new MockResponse().setBody("success!"));
        String url = "http://localhost:" + this.server.getPort();
        Decoder angryDecoder = (response, type) -> {
            throw new IOException("Failed to decode the response");
        };
        final AtomicBoolean closed = new AtomicBoolean();
        TestInterface api = (TestInterface)Feign.builder().client(new Client(){
            Client client = new Client.Default(null, null);

            public Response execute(Request request, Request.Options options) throws IOException {
                final Response original = this.client.execute(request, options);
                return Response.builder().status(original.status()).headers(original.headers()).reason(original.reason()).request(original.request()).body(new Response.Body(){

                    public Integer length() {
                        return original.body().length();
                    }

                    public boolean isRepeatable() {
                        return original.body().isRepeatable();
                    }

                    public InputStream asInputStream() throws IOException {
                        return original.body().asInputStream();
                    }

                    public Reader asReader() throws IOException {
                        return original.body().asReader(Util.UTF_8);
                    }

                    public Reader asReader(Charset charset) throws IOException {
                        return original.body().asReader(charset);
                    }

                    public void close() throws IOException {
                        closed.set(true);
                        original.body().close();
                    }
                }).build();
            }
        }).decoder(angryDecoder).doNotCloseAfterDecode().target(TestInterface.class, url);
        try {
            api.decodedLazyPost();
            Assert.fail((String)"Expected an exception");
        }
        catch (FeignException feignException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Responses must be closed when the decoder fails", (boolean)closed.get());
    }

    static interface TestInterface {
        @RequestLine(value="GET")
        public Response getNoPath();

        @RequestLine(value="GET api/thing")
        public Response getNoInitialSlashOnSlash();

        @RequestLine(value="GET api/thing")
        public String getBodyAsString();

        @RequestLine(value="GET /api/querymap/object")
        public String queryMapEncoded(@QueryMap Object var1);

        @RequestLine(value="POST /")
        public Response codecPost(String var1);

        @RequestLine(value="POST /")
        public void encodedPost(List<String> var1);

        @RequestLine(value="POST /")
        public String decodedPost();

        @RequestLine(value="POST /")
        public Iterator<String> decodedLazyPost();

        @RequestLine(value="POST /")
        public Optional<String> optionalContent();

        @RequestLine(value="POST /")
        public Stream<String> streamPost();

        @RequestLine(value="GET /api/queues/{vhost}", decodeSlash=false)
        public byte[] getQueues(@Param(value="vhost") String var1);

        default public String independentDefaultMethod() {
            return "default result";
        }

        default public Response defaultMethodPassthrough() {
            return this.getNoPath();
        }
    }
}

