/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.RequestLine;
import feign.RequestTemplate;
import feign.Response;
import feign.Target;
import feign.assertj.FeignAssertions;
import java.net.URI;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class EmptyTargetTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void whenNameNotSupplied() {
        FeignAssertions.assertThat((Object)Target.EmptyTarget.create(UriInterface.class)).isEqualTo((Object)Target.EmptyTarget.create(UriInterface.class, (String)"empty:UriInterface"));
    }

    @Test
    public void toString_withoutName() {
        FeignAssertions.assertThat((String)Target.EmptyTarget.create(UriInterface.class).toString()).isEqualTo("EmptyTarget(type=UriInterface)");
    }

    @Test
    public void toString_withName() {
        FeignAssertions.assertThat((String)Target.EmptyTarget.create(UriInterface.class, (String)"manager-access").toString()).isEqualTo("EmptyTarget(type=UriInterface, name=manager-access)");
    }

    @Test
    public void mustApplyToAbsoluteUrl() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("Request with non-absolute URL not supported with empty target");
        Target.EmptyTarget.create(UriInterface.class).apply(new RequestTemplate().method(Request.HttpMethod.GET).uri("/relative"));
    }

    static interface UriInterface {
        @RequestLine(value="GET /")
        public Response get(URI var1);
    }
}

