/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.QueryMapEncoder;
import feign.QueryMapEncoderObject;
import feign.querymap.FieldQueryMapEncoder;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultQueryMapEncoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final QueryMapEncoder encoder = new FieldQueryMapEncoder();

    @Test
    public void testEncodesObject_visibleFields() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "fooz");
        expected.put("bar", "barz");
        expected.put("baz", "bazz");
        VisibleFieldsObject object = new VisibleFieldsObject();
        object.foo = "fooz";
        object.bar = "barz";
        object.baz = "bazz";
        Map encodedMap = this.encoder.encode((Object)object);
        Assert.assertEquals((String)"Unexpected encoded query map", expected, (Object)encodedMap);
    }

    @Test
    public void testEncodesObject_visibleFields_emptyObject() {
        VisibleFieldsObject object = new VisibleFieldsObject();
        Map encodedMap = this.encoder.encode((Object)object);
        Assert.assertTrue((String)("Non-empty map generated from null fields: " + encodedMap), (boolean)encodedMap.isEmpty());
    }

    @Test
    public void testEncodesObject_nonVisibleFields() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "fooz");
        expected.put("bar", "barz");
        QueryMapEncoderObject object = new QueryMapEncoderObject("fooz", "barz");
        Map encodedMap = this.encoder.encode((Object)object);
        Assert.assertEquals((String)"Unexpected encoded query map", expected, (Object)encodedMap);
    }

    @Test
    public void testEncodesObject_nonVisibleFields_emptyObject() {
        QueryMapEncoderObject object = new QueryMapEncoderObject(null, null);
        Map encodedMap = this.encoder.encode((Object)object);
        Assert.assertTrue((String)"Non-empty map generated from null fields", (boolean)encodedMap.isEmpty());
    }

    static class VisibleFieldsObject {
        String foo;
        String bar;
        String baz;

        VisibleFieldsObject() {
        }
    }
}

