/*
 * Decompiled with CFR 0.152.
 */
package feign;

import com.google.gson.reflect.TypeToken;
import feign.Body;
import feign.Contract;
import feign.HeaderMap;
import feign.Headers;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.Response;
import feign.assertj.FeignAssertions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.assertj.core.api.Fail;
import org.assertj.core.data.MapEntry;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

public class DefaultContractTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    Contract.Default contract = new Contract.Default();

    @Test
    public void httpMethods() throws Exception {
        FeignAssertions.assertThat(this.parseAndValidateMetadata(Methods.class, "post", new Class[0]).template()).hasMethod("POST");
        FeignAssertions.assertThat(this.parseAndValidateMetadata(Methods.class, "put", new Class[0]).template()).hasMethod("PUT");
        FeignAssertions.assertThat(this.parseAndValidateMetadata(Methods.class, "get", new Class[0]).template()).hasMethod("GET");
        FeignAssertions.assertThat(this.parseAndValidateMetadata(Methods.class, "delete", new Class[0]).template()).hasMethod("DELETE");
    }

    @Test
    public void bodyParamIsGeneric() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(BodyParams.class, "post", List.class);
        FeignAssertions.assertThat((Integer)md.bodyIndex()).isEqualTo(0);
        FeignAssertions.assertThat((Object)md.bodyType()).isEqualTo((Object)new TypeToken<List<String>>(){}.getType());
    }

    @Test
    public void bodyParamWithPathParam() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(BodyParams.class, "post", Integer.TYPE, List.class);
        FeignAssertions.assertThat((Integer)md.bodyIndex()).isEqualTo(1);
        FeignAssertions.assertThat((Map)md.indexToName()).containsOnly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("id"))});
    }

    @Test
    public void tooManyBodies() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Method has too many Body");
        this.parseAndValidateMetadata(BodyParams.class, "tooMany", List.class, List.class);
    }

    @Test
    public void customMethodWithoutPath() throws Exception {
        FeignAssertions.assertThat(this.parseAndValidateMetadata(CustomMethod.class, "patch", new Class[0]).template()).hasMethod("PATCH").hasUrl("/");
    }

    @Test
    public void queryParamsInPathExtract() throws Exception {
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "none", new Class[0]).template()).hasUrl("/").hasQueries(new MapEntry[0]);
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "one", new Class[0]).template()).hasPath("/").hasQueries(MapEntry.entry((Object)"Action", Arrays.asList("GetUser")));
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "two", new Class[0]).template()).hasPath("/").hasQueries(MapEntry.entry((Object)"Action", Arrays.asList("GetUser")), MapEntry.entry((Object)"Version", Arrays.asList("2010-05-08")));
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "three", new Class[0]).template()).hasPath("/").hasQueries(MapEntry.entry((Object)"Action", Arrays.asList("GetUser")), MapEntry.entry((Object)"Version", Arrays.asList("2010-05-08")), MapEntry.entry((Object)"limit", Arrays.asList("1")));
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "twoAndOneEmpty", new Class[0]).template()).hasPath("/").hasQueries(MapEntry.entry((Object)"flag", new ArrayList()), MapEntry.entry((Object)"Action", Arrays.asList("GetUser")), MapEntry.entry((Object)"Version", Arrays.asList("2010-05-08")));
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "oneEmpty", new Class[0]).template()).hasPath("/").hasQueries(MapEntry.entry((Object)"flag", new ArrayList()));
        FeignAssertions.assertThat(this.parseAndValidateMetadata(WithQueryParamsInPath.class, "twoEmpty", new Class[0]).template()).hasPath("/").hasQueries(MapEntry.entry((Object)"flag", new ArrayList()), MapEntry.entry((Object)"NoErrors", new ArrayList()));
    }

    @Test
    public void bodyWithoutParameters() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(BodyWithoutParameters.class, "post", new Class[0]);
        FeignAssertions.assertThat(md.template()).hasBody("<v01:getAccountsListOfUser/>");
    }

    @Test
    public void headersOnMethodAddsContentTypeHeader() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(BodyWithoutParameters.class, "post", new Class[0]);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Content-Type", Arrays.asList("application/xml")), MapEntry.entry((Object)"Content-Length", Arrays.asList(String.valueOf(md.template().body().length))));
    }

    @Test
    public void headersOnTypeAddsContentTypeHeader() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(HeadersOnType.class, "post", new Class[0]);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Content-Type", Arrays.asList("application/xml")), MapEntry.entry((Object)"Content-Length", Arrays.asList(String.valueOf(md.template().body().length))));
    }

    @Test
    public void headersContainsWhitespaces() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(HeadersContainsWhitespaces.class, "post", new Class[0]);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Content-Type", Collections.singletonList("application/xml")), MapEntry.entry((Object)"Content-Length", Arrays.asList(String.valueOf(md.template().body().length))));
    }

    @Test
    public void withPathAndURIParam() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(WithURIParam.class, "uriParam", String.class, URI.class, String.class);
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("1")), MapEntry.entry((Object)2, Arrays.asList("2"))});
        FeignAssertions.assertThat((Integer)md.urlIndex()).isEqualTo(1);
    }

    @Test
    public void pathAndQueryParams() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(WithPathAndQueryParams.class, "recordsByNameAndType", Integer.TYPE, String.class, String.class);
        FeignAssertions.assertThat(md.template()).hasQueries(MapEntry.entry((Object)"name", Arrays.asList("{name}")), MapEntry.entry((Object)"type", Arrays.asList("{type}")));
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("domainId")), MapEntry.entry((Object)1, Arrays.asList("name")), MapEntry.entry((Object)2, Arrays.asList("type"))});
    }

    @Test
    public void autoDiscoverParamNames() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(AutoDiscoverParamNames.class, "recordsByNameAndType", Integer.TYPE, String.class, String.class);
        FeignAssertions.assertThat(md.template()).hasQueries(MapEntry.entry((Object)"name", Arrays.asList("{name}")), MapEntry.entry((Object)"type", Arrays.asList("{type}")));
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("domainId")), MapEntry.entry((Object)1, Arrays.asList("name")), MapEntry.entry((Object)2, Arrays.asList("type"))});
    }

    @Test
    public void bodyWithTemplate() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(FormParams.class, "login", String.class, String.class, String.class);
        FeignAssertions.assertThat(md.template()).hasBodyTemplate("%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D");
    }

    @Test
    public void formParamsParseIntoIndexToName() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(FormParams.class, "login", String.class, String.class, String.class);
        FeignAssertions.assertThat((List)md.formParams()).containsExactly((Object[])new String[]{"customer_name", "user_name", "password"});
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("customer_name")), MapEntry.entry((Object)1, Arrays.asList("user_name")), MapEntry.entry((Object)2, Arrays.asList("password"))});
    }

    @Test
    public void formParamAndBodyParams() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Body parameters cannot be used with form parameters.");
        this.parseAndValidateMetadata(FormParams.class, "formParamAndBodyParams", String.class, String.class);
        Fail.failBecauseExceptionWasNotThrown(IllegalStateException.class);
    }

    @Test
    public void bodyParamsAndformParam() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Body parameters cannot be used with form parameters.");
        this.parseAndValidateMetadata(FormParams.class, "bodyParamsAndformParam", String.class, String.class);
        Fail.failBecauseExceptionWasNotThrown(IllegalStateException.class);
    }

    @Test
    public void formParamParseIntoFormParams() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(FormParams.class, "loginNoBodyTemplate", String.class, String.class, String.class);
        FeignAssertions.assertThat((List)md.formParams()).containsExactly((Object[])new String[]{"customer_name", "user_name", "password"});
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("customer_name")), MapEntry.entry((Object)1, Arrays.asList("user_name")), MapEntry.entry((Object)2, Arrays.asList("password"))});
    }

    @Test
    public void formParamsDoesNotSetBodyType() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(FormParams.class, "login", String.class, String.class, String.class);
        FeignAssertions.assertThat((Object)md.bodyType()).isNull();
    }

    @Test
    public void headerParamsParseIntoIndexToName() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(HeaderParams.class, "logout", String.class);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Auth-Token", Arrays.asList("{authToken}", "Foo")));
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("authToken"))});
        FeignAssertions.assertThat((List)md.formParams()).isEmpty();
    }

    @Test
    public void headerParamsParseIntoIndexToNameNotAtStart() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(HeaderParamsNotAtStart.class, "logout", String.class);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("Bearer {authToken}", "Foo")));
        FeignAssertions.assertThat((Map)md.indexToName()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, Arrays.asList("authToken"))});
        FeignAssertions.assertThat((List)md.formParams()).isEmpty();
    }

    @Test
    public void customExpander() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(CustomExpander.class, "date", Date.class);
        FeignAssertions.assertThat((Map)md.indexToExpanderClass()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)0, DateToMillis.class)});
    }

    @Test
    public void queryMap() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "queryMap", Map.class);
        FeignAssertions.assertThat((Integer)md.queryMapIndex()).isEqualTo(0);
    }

    @Test
    public void queryMapEncodedDefault() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "queryMap", Map.class);
        FeignAssertions.assertThat((boolean)md.queryMapEncoded()).isFalse();
    }

    @Test
    public void queryMapEncodedTrue() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "queryMapEncoded", Map.class);
        FeignAssertions.assertThat((boolean)md.queryMapEncoded()).isTrue();
    }

    @Test
    public void queryMapEncodedFalse() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "queryMapNotEncoded", Map.class);
        FeignAssertions.assertThat((boolean)md.queryMapEncoded()).isFalse();
    }

    @Test
    public void queryMapMapSubclass() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "queryMapMapSubclass", SortedMap.class);
        FeignAssertions.assertThat((Integer)md.queryMapIndex()).isEqualTo(0);
    }

    @Test
    public void onlyOneQueryMapAnnotationPermitted() throws Exception {
        try {
            this.parseAndValidateMetadata(QueryMapTestInterface.class, "multipleQueryMap", Map.class, Map.class);
            Fail.failBecauseExceptionWasNotThrown(IllegalStateException.class);
        }
        catch (IllegalStateException ex) {
            FeignAssertions.assertThat((Throwable)ex).hasMessage("QueryMap annotation was present on multiple parameters.");
        }
    }

    @Test
    public void queryMapKeysMustBeStrings() throws Exception {
        try {
            this.parseAndValidateMetadata(QueryMapTestInterface.class, "nonStringKeyQueryMap", Map.class);
            Fail.failBecauseExceptionWasNotThrown(IllegalStateException.class);
        }
        catch (IllegalStateException ex) {
            FeignAssertions.assertThat((Throwable)ex).hasMessage("QueryMap key must be a String: Integer");
        }
    }

    @Test
    public void queryMapPojoObject() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "pojoObject", Object.class);
        FeignAssertions.assertThat((Integer)md.queryMapIndex()).isEqualTo(0);
    }

    @Test
    public void queryMapPojoObjectEncoded() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "pojoObjectEncoded", Object.class);
        FeignAssertions.assertThat((Integer)md.queryMapIndex()).isEqualTo(0);
        FeignAssertions.assertThat((boolean)md.queryMapEncoded()).isTrue();
    }

    @Test
    public void queryMapPojoObjectNotEncoded() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(QueryMapTestInterface.class, "pojoObjectNotEncoded", Object.class);
        FeignAssertions.assertThat((Integer)md.queryMapIndex()).isEqualTo(0);
        FeignAssertions.assertThat((boolean)md.queryMapEncoded()).isFalse();
    }

    @Test
    public void slashAreEncodedWhenNeeded() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(SlashNeedToBeEncoded.class, "getQueues", String.class);
        FeignAssertions.assertThat((boolean)md.template().decodeSlash()).isFalse();
        md = this.parseAndValidateMetadata(SlashNeedToBeEncoded.class, "getZone", String.class);
        FeignAssertions.assertThat((boolean)md.template().decodeSlash()).isTrue();
    }

    @Test
    public void onlyOneHeaderMapAnnotationPermitted() throws Exception {
        try {
            this.parseAndValidateMetadata(HeaderMapInterface.class, "multipleHeaderMap", Map.class, Map.class);
            Fail.failBecauseExceptionWasNotThrown(IllegalStateException.class);
        }
        catch (IllegalStateException ex) {
            FeignAssertions.assertThat((Throwable)ex).hasMessage("HeaderMap annotation was present on multiple parameters.");
        }
    }

    @Test
    public void headerMapSubclass() throws Exception {
        MethodMetadata md = this.parseAndValidateMetadata(HeaderMapInterface.class, "headerMapSubClass", SubClassHeaders.class);
        FeignAssertions.assertThat((Integer)md.headerMapIndex()).isEqualTo(0);
    }

    @Test
    public void parameterizedBaseApi() throws Exception {
        List md = this.contract.parseAndValidateMetadata(ParameterizedApi.class);
        LinkedHashMap<String, MethodMetadata> byConfigKey = new LinkedHashMap<String, MethodMetadata>();
        for (MethodMetadata m : md) {
            byConfigKey.put(m.configKey(), m);
        }
        FeignAssertions.assertThat(byConfigKey).containsOnlyKeys((Object[])new String[]{"ParameterizedApi#get(String)", "ParameterizedApi#getAll(Keys)"});
        FeignAssertions.assertThat((Object)((MethodMetadata)byConfigKey.get("ParameterizedApi#get(String)")).returnType()).isEqualTo((Object)new TypeToken<Entity<String, Long>>(){}.getType());
        FeignAssertions.assertThat(((MethodMetadata)byConfigKey.get("ParameterizedApi#get(String)")).template()).hasHeaders(MapEntry.entry((Object)"Version", Arrays.asList("1")), MapEntry.entry((Object)"Foo", Arrays.asList("Bar")));
        FeignAssertions.assertThat((Object)((MethodMetadata)byConfigKey.get("ParameterizedApi#getAll(Keys)")).returnType()).isEqualTo((Object)new TypeToken<Entities<String, Long>>(){}.getType());
        FeignAssertions.assertThat((Object)((MethodMetadata)byConfigKey.get("ParameterizedApi#getAll(Keys)")).bodyType()).isEqualTo((Object)new TypeToken<Keys<String>>(){}.getType());
        FeignAssertions.assertThat(((MethodMetadata)byConfigKey.get("ParameterizedApi#getAll(Keys)")).template()).hasHeaders(MapEntry.entry((Object)"Version", Arrays.asList("1")), MapEntry.entry((Object)"Foo", Arrays.asList("Bar")));
    }

    @Test
    public void parameterizedHeaderExpandApi() throws Exception {
        List md = this.contract.parseAndValidateMetadata(ParameterizedHeaderExpandApi.class);
        FeignAssertions.assertThat((List)md).hasSize(1);
        FeignAssertions.assertThat((String)((MethodMetadata)md.get(0)).configKey()).isEqualTo("ParameterizedHeaderExpandApi#getZone(String,String)");
        FeignAssertions.assertThat((Object)((MethodMetadata)md.get(0)).returnType()).isEqualTo(String.class);
        FeignAssertions.assertThat(((MethodMetadata)md.get(0)).template()).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("{authHdr}")), MapEntry.entry((Object)"Accept", Arrays.asList("application/json")));
        FeignAssertions.assertThat((List)((MethodMetadata)md.get(0)).formParams()).isEmpty();
    }

    @Test
    public void parameterizedHeaderNotStartingWithCurlyBraceExpandApi() throws Exception {
        List md = this.contract.parseAndValidateMetadata(ParameterizedHeaderNotStartingWithCurlyBraceExpandApi.class);
        FeignAssertions.assertThat((List)md).hasSize(1);
        FeignAssertions.assertThat((String)((MethodMetadata)md.get(0)).configKey()).isEqualTo("ParameterizedHeaderNotStartingWithCurlyBraceExpandApi#getZone(String,String)");
        FeignAssertions.assertThat((Object)((MethodMetadata)md.get(0)).returnType()).isEqualTo(String.class);
        FeignAssertions.assertThat(((MethodMetadata)md.get(0)).template()).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("Bearer {authHdr}")), MapEntry.entry((Object)"Accept", Arrays.asList("application/json")));
        FeignAssertions.assertThat((List)((MethodMetadata)md.get(0)).formParams()).isEmpty();
    }

    @Test
    public void parameterizedHeaderExpandApiBaseClass() throws Exception {
        List mds = this.contract.parseAndValidateMetadata(ParameterizedHeaderExpandInheritedApi.class);
        LinkedHashMap<String, MethodMetadata> byConfigKey = new LinkedHashMap<String, MethodMetadata>();
        for (MethodMetadata m : mds) {
            byConfigKey.put(m.configKey(), m);
        }
        FeignAssertions.assertThat(byConfigKey).containsOnlyKeys((Object[])new String[]{"ParameterizedHeaderExpandInheritedApi#getZoneAccept(String,String)", "ParameterizedHeaderExpandInheritedApi#getZone(String,String)"});
        MethodMetadata md = (MethodMetadata)byConfigKey.get("ParameterizedHeaderExpandInheritedApi#getZoneAccept(String,String)");
        FeignAssertions.assertThat((Object)md.returnType()).isEqualTo(String.class);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("{authHdr}")), MapEntry.entry((Object)"Accept", Arrays.asList("application/json")));
        FeignAssertions.assertThat((List)md.formParams()).isEmpty();
        md = (MethodMetadata)byConfigKey.get("ParameterizedHeaderExpandInheritedApi#getZone(String,String)");
        FeignAssertions.assertThat((Object)md.returnType()).isEqualTo(String.class);
        FeignAssertions.assertThat(md.template()).hasHeaders(MapEntry.entry((Object)"Authorization", Arrays.asList("{authHdr}")));
        FeignAssertions.assertThat((List)md.formParams()).isEmpty();
    }

    private MethodMetadata parseAndValidateMetadata(Class<?> targetType, String method, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return this.contract.parseAndValidateMetadata(targetType, targetType.getMethod(method, parameterTypes));
    }

    @Test
    public void missingMethod() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("RequestLine annotation didn't start with an HTTP verb on method MissingMethod#updateSharing");
        this.contract.parseAndValidateMetadata(MissingMethod.class);
    }

    @Test
    public void staticMethodsOnInterfaceIgnored() throws Exception {
        List mds = this.contract.parseAndValidateMetadata(StaticMethodOnInterface.class);
        FeignAssertions.assertThat((List)mds).hasSize(1);
        MethodMetadata md = (MethodMetadata)mds.get(0);
        FeignAssertions.assertThat((String)md.configKey()).isEqualTo("StaticMethodOnInterface#get(String)");
    }

    @Test
    public void defaultMethodsOnInterfaceIgnored() throws Exception {
        List mds = this.contract.parseAndValidateMetadata(DefaultMethodOnInterface.class);
        FeignAssertions.assertThat((List)mds).hasSize(1);
        MethodMetadata md = (MethodMetadata)mds.get(0);
        FeignAssertions.assertThat((String)md.configKey()).isEqualTo("DefaultMethodOnInterface#get(String)");
    }

    @Test
    public void paramIsASubstringOfAQuery() throws Exception {
        List mds = this.contract.parseAndValidateMetadata(SubstringQuery.class);
        FeignAssertions.assertThat((Map)((MethodMetadata)mds.get(0)).template().queries()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"q", Arrays.asList("body:{body}"))});
        FeignAssertions.assertThat((List)((MethodMetadata)mds.get(0)).formParams()).isEmpty();
    }

    @Test
    public void errorMessageOnMixedContracts() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("are not used by contract Default");
        this.contract.parseAndValidateMetadata(MixedAnnotations.class);
    }

    static interface MixedAnnotations {
        @Headers(value={"Content-Type: application/json"})
        @RequestLine(value="GET api/v2/clients/{uid}")
        public Response findAllClientsByUid2(@Category(value={String.class}) String var1, Integer var2, Integer var3);
    }

    static interface SubstringQuery {
        @RequestLine(value="GET /_search?q=body:{body}")
        public String paramIsASubstringOfAQuery(@Param(value="body") String var1);
    }

    static interface DefaultMethodOnInterface {
        @RequestLine(value="GET /api/{key}")
        public String get(@Param(value="key") String var1);

        default public String defaultGet(String key) {
            return this.get(key);
        }
    }

    static interface StaticMethodOnInterface {
        @RequestLine(value="GET /api/{key}")
        public String get(@Param(value="key") String var1);

        public static String staticMethod() {
            return "value";
        }
    }

    static interface MissingMethod {
        @RequestLine(value="/path?queryParam={queryParam}")
        public Response updateSharing(@Param(value="queryParam") long var1, String var3);
    }

    static interface ParameterizedHeaderExpandInheritedApi
    extends ParameterizedHeaderBase {
        @RequestLine(value="GET /api/{zoneId}")
        @Headers(value={"Accept: application/json"})
        public String getZoneAccept(@Param(value="zoneId") String var1, @Param(value="authHdr") String var2);

        @RequestLine(value="GET /api/{zoneId}")
        public String getZone(@Param(value="zoneId") String var1, @Param(value="authHdr") String var2);
    }

    @Headers(value={"Authorization: {authHdr}"})
    static interface ParameterizedHeaderBase {
    }

    @Headers(value={"Authorization: Bearer {authHdr}"})
    static interface ParameterizedHeaderNotStartingWithCurlyBraceExpandApi {
        @RequestLine(value="GET /api/{zoneId}")
        @Headers(value={"Accept: application/json"})
        public String getZone(@Param(value="zoneId") String var1, @Param(value="authHdr") String var2);
    }

    @Headers(value={"Authorization: {authHdr}"})
    static interface ParameterizedHeaderExpandApi {
        @RequestLine(value="GET /api/{zoneId}")
        @Headers(value={"Accept: application/json"})
        public String getZone(@Param(value="zoneId") String var1, @Param(value="authHdr") String var2);
    }

    @Headers(value={"Version: 1"})
    static interface ParameterizedApi
    extends ParameterizedBaseApi<String, Long> {
    }

    static interface SubClassHeaders
    extends Map<String, String> {
    }

    static class Entities<K, M> {
        private List<Entity<K, M>> entities;

        Entities() {
        }
    }

    static class Entity<K, M> {
        K key;
        M model;

        Entity() {
        }
    }

    static class Keys<K> {
        List<K> keys;

        Keys() {
        }
    }

    @Headers(value={"Foo: Bar"})
    static interface ParameterizedBaseApi<K, M> {
        @RequestLine(value="GET /api/{key}")
        public Entity<K, M> get(@Param(value="key") K var1);

        @RequestLine(value="POST /api")
        public Entities<K, M> getAll(Keys<K> var1);
    }

    static interface SlashNeedToBeEncoded {
        @RequestLine(value="GET /api/queues/{vhost}", decodeSlash=false)
        public String getQueues(@Param(value="vhost") String var1);

        @RequestLine(value="GET /api/{zoneId}")
        public String getZone(@Param(value="ZoneId") String var1);
    }

    static interface QueryMapTestInterface {
        @RequestLine(value="POST /")
        public void queryMap(@QueryMap Map<String, String> var1);

        @RequestLine(value="POST /")
        public void queryMapMapSubclass(@QueryMap SortedMap<String, String> var1);

        @RequestLine(value="POST /")
        public void queryMapEncoded(@QueryMap(encoded=true) Map<String, String> var1);

        @RequestLine(value="POST /")
        public void queryMapNotEncoded(@QueryMap(encoded=false) Map<String, String> var1);

        @RequestLine(value="POST /")
        public void pojoObject(@QueryMap Object var1);

        @RequestLine(value="POST /")
        public void pojoObjectEncoded(@QueryMap(encoded=true) Object var1);

        @RequestLine(value="POST /")
        public void pojoObjectNotEncoded(@QueryMap(encoded=false) Object var1);

        @RequestLine(value="POST /")
        public void multipleQueryMap(@QueryMap Map<String, String> var1, @QueryMap Map<String, String> var2);

        @RequestLine(value="POST /")
        public void nonStringKeyQueryMap(@QueryMap Map<Integer, String> var1);
    }

    class DateToMillis
    implements Param.Expander {
        DateToMillis() {
        }

        public String expand(Object value) {
            return String.valueOf(((Date)value).getTime());
        }
    }

    static interface CustomExpander {
        @RequestLine(value="POST /?date={date}")
        public void date(@Param(value="date", expander=DateToMillis.class) Date var1);
    }

    static interface HeaderParamsNotAtStart {
        @RequestLine(value="POST /")
        @Headers(value={"Authorization: Bearer {authToken}", "Authorization: Foo"})
        public void logout(@Param(value="authToken") String var1);
    }

    static interface HeaderParams {
        @RequestLine(value="POST /")
        @Headers(value={"Auth-Token: {authToken}", "Auth-Token: Foo"})
        public void logout(@Param(value="authToken") String var1);
    }

    static interface HeaderMapInterface {
        @RequestLine(value="POST /")
        public void multipleHeaderMap(@HeaderMap Map<String, String> var1, @HeaderMap Map<String, String> var2);

        @RequestLine(value="POST /")
        public void headerMapSubClass(@HeaderMap SubClassHeaders var1);
    }

    static interface FormParams {
        @RequestLine(value="POST /")
        @Body(value="%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D")
        public void login(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);

        @RequestLine(value="POST /")
        public void loginNoBodyTemplate(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);

        @RequestLine(value="POST /")
        public void formParamAndBodyParams(@Param(value="customer_name") String var1, String var2);

        @RequestLine(value="POST /")
        public void bodyParamsAndformParam(String var1, @Param(value="customer_name") String var2);
    }

    static interface AutoDiscoverParamNames {
        @RequestLine(value="GET /domains/{domainId}/records?name={name}&type={type}")
        public Response recordsByNameAndType(@Param int var1, @Param String var2, @Param String var3);
    }

    static interface WithPathAndQueryParams {
        @RequestLine(value="GET /domains/{domainId}/records?name={name}&type={type}")
        public Response recordsByNameAndType(@Param(value="domainId") int var1, @Param(value="name") String var2, @Param(value="type") String var3);
    }

    static interface WithURIParam {
        @RequestLine(value="GET /{1}/{2}")
        public Response uriParam(@Param(value="1") String var1, URI var2, @Param(value="2") String var3);
    }

    @Headers(value={"Content-Type:    application/xml   "})
    static interface HeadersContainsWhitespaces {
        @RequestLine(value="POST /")
        @Body(value="<v01:getAccountsListOfUser/>")
        public Response post();
    }

    @Headers(value={"Content-Type: application/xml"})
    static interface HeadersOnType {
        @RequestLine(value="POST /")
        @Body(value="<v01:getAccountsListOfUser/>")
        public Response post();
    }

    static interface BodyWithoutParameters {
        @RequestLine(value="POST /")
        @Headers(value={"Content-Type: application/xml"})
        @Body(value="<v01:getAccountsListOfUser/>")
        public Response post();
    }

    static interface WithQueryParamsInPath {
        @RequestLine(value="GET /")
        public Response none();

        @RequestLine(value="GET /?Action=GetUser")
        public Response one();

        @RequestLine(value="GET /?Action=GetUser&Version=2010-05-08")
        public Response two();

        @RequestLine(value="GET /?Action=GetUser&Version=2010-05-08&limit=1")
        public Response three();

        @RequestLine(value="GET /?flag&Action=GetUser&Version=2010-05-08")
        public Response twoAndOneEmpty();

        @RequestLine(value="GET /?flag")
        public Response oneEmpty();

        @RequestLine(value="GET /?flag&NoErrors")
        public Response twoEmpty();
    }

    static interface CustomMethod {
        @RequestLine(value="PATCH")
        public Response patch();
    }

    static interface BodyParams {
        @RequestLine(value="POST")
        public Response post(List<String> var1);

        @RequestLine(value="PUT /offers/{id}")
        public void post(@Param(value="id") int var1, List<String> var2);

        @RequestLine(value="POST")
        public Response tooMany(List<String> var1, List<String> var2);
    }

    static interface Methods {
        @RequestLine(value="POST /")
        public void post();

        @RequestLine(value="PUT /")
        public void put();

        @RequestLine(value="GET /")
        public void get();

        @RequestLine(value="DELETE /")
        public void delete();
    }
}

