/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Body;
import feign.Contract;
import feign.Headers;
import feign.MethodMetadata;
import feign.Param;
import feign.RequestLine;
import feign.assertj.FeignAssertions;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.data.MapEntry;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultContractInheritanceTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    Contract.Default contract = new Contract.Default();

    @Test
    public void simpleParameterizedBaseApi() throws Exception {
        List md = this.contract.parseAndValidateMetadata(SimpleParameterizedApi.class);
        FeignAssertions.assertThat((List)md).hasSize(1);
        FeignAssertions.assertThat((String)((MethodMetadata)md.get(0)).configKey()).isEqualTo("SimpleParameterizedApi#get(String)");
        FeignAssertions.assertThat((Object)((MethodMetadata)md.get(0)).returnType()).isEqualTo(String.class);
        FeignAssertions.assertThat(((MethodMetadata)md.get(0)).template()).hasHeaders(MapEntry.entry((Object)"Foo", Arrays.asList("Bar")));
    }

    @Test
    public void parameterizedApiUnsupported() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Parameterized types unsupported: SimpleParameterizedBaseApi");
        this.contract.parseAndValidateMetadata(SimpleParameterizedBaseApi.class);
    }

    @Test
    public void overrideParameterizedApiSupported() {
        this.contract.parseAndValidateMetadata(OverrideParameterizedApi.class);
    }

    @Test
    public void overrideSimpleApiSupported() {
        this.contract.parseAndValidateMetadata(OverrideSimpleApi.class);
    }

    @Test
    public void singleInheritance() {
        this.contract.parseAndValidateMetadata(SingleInheritanceChild.class);
    }

    @Test
    public void multipleInheritanceDoneWrong() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Only single inheritance supported: MultipleInheritanceDoneWrong");
        this.contract.parseAndValidateMetadata(MultipleInheritanceDoneWrong.class);
    }

    @Test
    public void multipleInheritanceDoneCorrectly() {
        this.contract.parseAndValidateMetadata(MultipleInheritanceDoneCorrectly.class);
    }

    @Test
    public void multipleInheritanceDoneCorrectly2() {
        this.contract.parseAndValidateMetadata(MultipleInheritanceApi.class);
    }

    @Test
    public void multipleInheritanceSupported() {
        this.contract.parseAndValidateMetadata(GrandChild.class);
    }

    @Headers(value={"Foo: Bar"})
    static interface MultipleInheritanceApi
    extends ServiceApi<String> {
        @Override
        @RequestLine(value="GET /api/{zoneId}")
        public String get(@Param(value="key") String var1);

        @Override
        @RequestLine(value="POST /api/{zoneId}")
        @Body(value="%7B\"value\": \"{value}\"%7D")
        public void update(@Param(value="key") String var1, @Param(value="value") String var2);
    }

    static interface ServiceApi<T>
    extends FirstServiceBaseApi<T>,
    SecondServiceBaseApi<T> {
    }

    static interface MultipleInheritanceDoneCorrectly
    extends MultipleInheritanceParameterizedBaseApi<String> {
    }

    @Headers(value={"Foo: Bar"})
    static interface MultipleInheritanceParameterizedBaseApi<T>
    extends FirstServiceBaseApi<T>,
    SecondServiceBaseApi<T> {
        @Override
        @RequestLine(value="GET /api/{zoneId}")
        public T get(@Param(value="key") String var1);

        @Override
        @RequestLine(value="POST /api/{zoneId}")
        @Body(value="%7B\"value\": \"{value}\"%7D")
        public void update(@Param(value="key") String var1, @Param(value="value") T var2);
    }

    static interface MultipleInheritanceDoneWrong
    extends SimpleParameterizedBaseApi<String>,
    FirstServiceBaseApi<String>,
    SecondServiceBaseApi<String> {
    }

    static interface SecondServiceBaseApi<T> {
        public void update(String var1, T var2);
    }

    static interface FirstServiceBaseApi<T> {
        public T get(String var1);
    }

    static interface SingleInheritanceChild
    extends SimpleParameterizedBaseApi<String> {
    }

    static interface GrandChild
    extends Child<String> {
    }

    static interface Child<T>
    extends SimpleParameterizedBaseApi<List<T>> {
    }

    static interface OverrideSimpleApi
    extends SimpleBaseApi {
        @Override
        @RequestLine(value="GET /api/v2/{zoneId}")
        public String get(@Param(value="key") String var1);
    }

    @Headers(value={"Foo: Bar"})
    static interface SimpleBaseApi {
        @RequestLine(value="GET /api/{zoneId}")
        public String get(@Param(value="key") String var1);
    }

    static interface OverrideParameterizedApi
    extends SimpleParameterizedBaseApi<String> {
        @Override
        @RequestLine(value="GET /api/{zoneId}")
        public String get(@Param(value="key") String var1);
    }

    static interface SimpleParameterizedApi
    extends SimpleParameterizedBaseApi<String> {
    }

    @Headers(value={"Foo: Bar"})
    static interface SimpleParameterizedBaseApi<M> {
        @RequestLine(value="GET /api/{zoneId}")
        public M get(@Param(value="key") String var1);
    }
}

