/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import feign.assertj.MockWebServerAssertions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class ContractWithRuntimeInjectionTest {
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void baseCaseExpanderNewInstance() throws InterruptedException {
        this.server.enqueue(new MockResponse());
        String baseUrl = this.server.url("/default").toString();
        ((TestExpander)Feign.builder().target(TestExpander.class, baseUrl)).get("FOO");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/default/path?query=FOO");
    }

    @Test
    public void contractWithRuntimeInjection() throws InterruptedException {
        this.server.enqueue(new MockResponse());
        String baseUrl = this.server.url("/default").toString();
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{FeignConfiguration.class});
        ((TestExpander)Feign.builder().contract((Contract)context.getBean(Contract.class)).target(TestExpander.class, baseUrl)).get("FOO");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/default/path?query=foo");
    }

    static class ContractWithRuntimeInjection
    implements Contract {
        final BeanFactory beanFactory;

        ContractWithRuntimeInjection(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
            List result = new Contract.Default().parseAndValidateMetadata(targetType);
            for (MethodMetadata md : result) {
                LinkedHashMap indexToExpander = new LinkedHashMap();
                for (Map.Entry entry : md.indexToExpanderClass().entrySet()) {
                    indexToExpander.put(entry.getKey(), this.beanFactory.getBean((Class)entry.getValue()));
                }
                md.indexToExpander(indexToExpander);
            }
            return result;
        }
    }

    @Configuration
    static class FeignConfiguration {
        FeignConfiguration() {
        }

        @Bean
        CaseExpander lowercaseExpander() {
            return new CaseExpander(true);
        }

        @Bean
        Contract contract(BeanFactory beanFactory) {
            return new ContractWithRuntimeInjection(beanFactory);
        }
    }

    static interface TestExpander {
        @RequestLine(value="GET /path?query={query}")
        public Response get(@Param(value="query", expander=CaseExpander.class) String var1);
    }

    static class CaseExpander
    implements Param.Expander {
        private final boolean lowercase;

        CaseExpander() {
            this(false);
        }

        CaseExpander(boolean lowercase) {
            this.lowercase = lowercase;
        }

        public String expand(Object value) {
            return this.lowercase ? value.toString().toLowerCase() : value.toString();
        }
    }
}

