/*
 * Decompiled with CFR 0.152.
 */
package feign;

import com.google.gson.reflect.TypeToken;
import feign.Feign;
import feign.Param;
import feign.RequestLine;
import feign.RequestTemplate;
import feign.Response;
import feign.assertj.MockWebServerAssertions;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Rule;
import org.junit.Test;

public class BaseApiTest {
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void resolvesParameterizedResult() throws InterruptedException {
        this.server.enqueue(new MockResponse().setBody("foo"));
        String baseUrl = this.server.url("/default").toString();
        ((MyApi)Feign.builder().decoder(new Decoder(){

            public Object decode(Response response, Type type) {
                MockWebServerAssertions.assertThat((Object)type).isEqualTo((Object)new TypeToken<Entity<String, Long>>(){}.getType());
                return null;
            }
        }).target(MyApi.class, baseUrl)).get("foo");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/default/api/foo");
    }

    @Test
    public void resolvesBodyParameter() throws InterruptedException {
        this.server.enqueue(new MockResponse().setBody("foo"));
        String baseUrl = this.server.url("/default").toString();
        ((MyApi)Feign.builder().encoder(new Encoder(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                MockWebServerAssertions.assertThat((Object)bodyType).isEqualTo((Object)new TypeToken<Keys<String>>(){}.getType());
            }
        }).decoder(new Decoder(){

            public Object decode(Response response, Type type) {
                MockWebServerAssertions.assertThat((Object)type).isEqualTo((Object)new TypeToken<Entities<String, Long>>(){}.getType());
                return null;
            }
        }).target(MyApi.class, baseUrl)).getAll(new Keys());
    }

    static interface MyApi
    extends BaseApi<String, Long> {
    }

    static class Entities<K, M> {
        List<Entity<K, M>> entities;

        Entities() {
        }
    }

    static class Entity<K, M> {
        K key;
        M model;

        Entity() {
        }
    }

    static class Keys<K> {
        List<K> keys;

        Keys() {
        }
    }

    static interface BaseApi<K, M> {
        @RequestLine(value="GET /api/{key}")
        public Entity<K, M> get(@Param(value="key") K var1);

        @RequestLine(value="POST /api")
        public Entities<K, M> getAll(Keys<K> var1);
    }
}

