/*
 * Decompiled with CFR 0.152.
 */
package feign;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import feign.AsyncClient;
import feign.AsyncFeign;
import feign.Body;
import feign.ChildPojo;
import feign.CustomPojo;
import feign.Feign;
import feign.FeignException;
import feign.HeaderMap;
import feign.Headers;
import feign.Param;
import feign.PropertyPojo;
import feign.QueryMap;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.RequestTemplate;
import feign.Response;
import feign.ResponseMapper;
import feign.Target;
import feign.Util;
import feign.assertj.MockWebServerAssertions;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.codec.StringDecoder;
import feign.querymap.BeanQueryMapEncoder;
import feign.querymap.FieldQueryMapEncoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okio.Buffer;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.MapEntry;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AsyncFeignTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final MockWebServer server = new MockWebServer();

    @Test
    public void iterableQueryParams() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        api.queryParams("user", Arrays.asList("apple", "pear"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?1=user&2=apple&2=pear");
    }

    @Test
    public void postTemplateParamsResolve() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        api.login("netflix", "denominator", "password");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("{\"customer_name\": \"netflix\", \"user_name\": \"denominator\", \"password\": \"password\"}");
    }

    @Test
    public void postFormParams() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.form("netflix", "denominator", "password");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody("{\"customer_name\":\"netflix\",\"user_name\":\"denominator\",\"password\":\"password\"}");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void postBodyParam() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.body(Arrays.asList("netflix", "denominator", "password"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Length", Collections.singletonList("32"))).hasBody("[netflix, denominator, password]");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void bodyTypeCorrespondsWithParameterType() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        final AtomicReference encodedType = new AtomicReference();
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().encoder((Encoder)new Encoder.Default(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                encodedType.set(bodyType);
            }
        }).target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.body(Arrays.asList("netflix", "denominator", "password"));
        this.server.takeRequest();
        MockWebServerAssertions.assertThat(encodedType.get()).isEqualTo((Object)new TypeToken<List<String>>(){}.getType());
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void postGZIPEncodedBodyParam() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.gzipBody(Arrays.asList("netflix", "denominator", "password"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasNoHeaderNamed("Content-Length").hasGzippedBody("[netflix, denominator, password]".getBytes(Util.UTF_8));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void postDeflateEncodedBodyParam() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.deflateBody(Arrays.asList("netflix", "denominator", "password"));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasNoHeaderNamed("Content-Length").hasDeflatedBody("[netflix, denominator, password]".getBytes(Util.UTF_8));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void singleInterceptor() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().requestInterceptor(new ForwardedForInterceptor()).target("http://localhost:" + this.server.getPort());
        CompletableFuture<String> cf = api.post();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"X-Forwarded-For", Collections.singletonList("origin.host.com")));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void multipleInterceptor() throws Exception {
        this.server.enqueue(new MockResponse().setBody("foo"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().requestInterceptor(new ForwardedForInterceptor()).requestInterceptor(new UserAgentInterceptor()).target("http://localhost:" + this.server.getPort());
        CompletableFuture<String> cf = api.post();
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"X-Forwarded-For", Collections.singletonList("origin.host.com")), MapEntry.entry((Object)"User-Agent", Collections.singletonList("Feign")));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void customExpander() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.expand(new Date(1234L));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?date=1234");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void customExpanderListParam() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.expandList(Arrays.asList(new Date(1234L), new Date(12345L)));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?date=1234&date=12345");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void customExpanderNullParam() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.expandList(Arrays.asList(new Date(1234L), null));
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?date=1234");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void headerMap() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
        headerMap.put("Content-Type", "myContent");
        headerMap.put("Custom-Header", "fooValue");
        CompletableFuture<Void> cf = api.headerMap(headerMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Type", Arrays.asList("myContent")), MapEntry.entry((Object)"Custom-Header", Arrays.asList("fooValue")));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void headerMapWithHeaderAnnotations() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
        headerMap.put("Custom-Header", "fooValue");
        api.headerMapWithHeaderAnnotations(headerMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Encoding", Arrays.asList("deflate")), MapEntry.entry((Object)"Custom-Header", Arrays.asList("fooValue")));
        this.server.enqueue(new MockResponse());
        headerMap.put("Content-Encoding", "overrideFromMap");
        CompletableFuture<Void> cf = api.headerMapWithHeaderAnnotations(headerMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasHeaders(MapEntry.entry((Object)"Content-Encoding", Arrays.asList("deflate", "overrideFromMap")), MapEntry.entry((Object)"Custom-Header", Arrays.asList("fooValue")));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void queryMap() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("name", "alice");
        queryMap.put("fooKey", "fooValue");
        CompletableFuture<Void> cf = api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice&fooKey=fooValue");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void queryMapIterableValuesExpanded() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("name", Arrays.asList("Alice", "Bob"));
        queryMap.put("fooKey", "fooValue");
        queryMap.put("emptyListKey", new ArrayList());
        queryMap.put("emptyStringKey", "");
        CompletableFuture<Void> cf = api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=Alice&name=Bob&fooKey=fooValue&emptyStringKey");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void queryMapWithQueryParams() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        this.server.enqueue(new MockResponse());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("fooKey", "fooValue");
        api.queryMapWithQueryParams("alice", queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice&fooKey=fooValue");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("name", "bob");
        api.queryMapWithQueryParams("alice", queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice&name=bob");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("name", null);
        api.queryMapWithQueryParams("alice", queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=alice");
    }

    @Test
    public void queryMapValueStartingWithBrace() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        this.server.enqueue(new MockResponse());
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        queryMap.put("name", "{alice");
        api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=%7Balice");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("{name", "alice");
        api.queryMap(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?%7Bname=alice");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("name", "%7Balice");
        api.queryMapEncoded(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=%7Balice");
        this.server.enqueue(new MockResponse());
        queryMap = new LinkedHashMap();
        queryMap.put("%7Bname", "%7Balice");
        api.queryMapEncoded(queryMap);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?%7Bname=%7Balice");
    }

    @Test
    public void queryMapPojoWithFullParams() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CustomPojo customPojo = new CustomPojo("Name", 3);
        this.server.enqueue(new MockResponse());
        CompletableFuture<Void> cf = api.queryMapPojo(customPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams(Arrays.asList("name=Name", "number=3"));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void queryMapPojoWithPartialParams() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CustomPojo customPojo = new CustomPojo("Name", null);
        this.server.enqueue(new MockResponse());
        CompletableFuture<Void> cf = api.queryMapPojo(customPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?name=Name");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void queryMapPojoWithEmptyParams() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CustomPojo customPojo = new CustomPojo(null, null);
        this.server.enqueue(new MockResponse());
        api.queryMapPojo(customPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/");
    }

    @Test
    public void configKeyFormatsAsExpected() throws Exception {
        Assert.assertEquals((Object)"TestInterfaceAsync#post()", (Object)Feign.configKey(TestInterfaceAsync.class, (Method)TestInterfaceAsync.class.getDeclaredMethod("post", new Class[0])));
        Assert.assertEquals((Object)"TestInterfaceAsync#uriParam(String,URI,String)", (Object)Feign.configKey(TestInterfaceAsync.class, (Method)TestInterfaceAsync.class.getDeclaredMethod("uriParam", String.class, URI.class, String.class)));
    }

    @Test
    public void configKeyUsesChildType() throws Exception {
        Assert.assertEquals((Object)"List#iterator()", (Object)Feign.configKey(List.class, (Method)Iterable.class.getDeclaredMethod("iterator", new Class[0])));
    }

    private <T> T unwrap(CompletableFuture<T> cf) throws Throwable {
        try {
            return cf.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test
    public void canOverrideErrorDecoder() throws Throwable {
        this.server.enqueue(new MockResponse().setResponseCode(400).setBody("foo"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("bad zone name");
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().errorDecoder((ErrorDecoder)new IllegalArgumentExceptionOn400()).target("http://localhost:" + this.server.getPort());
        this.unwrap(api.post());
    }

    @Test
    public void overrideTypeSpecificDecoder() throws Throwable {
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().decoder(new Decoder(){

            public Object decode(Response response, Type type) {
                return "fail";
            }
        }).target("http://localhost:" + this.server.getPort());
        Assert.assertEquals((Object)"fail", (Object)this.unwrap(api.post()));
    }

    @Test
    public void doesntRetryAfterResponseIsSent() throws Throwable {
        this.server.enqueue(new MockResponse().setBody("success!"));
        this.thrown.expect(FeignException.class);
        this.thrown.expectMessage("timeout reading POST http://");
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().decoder(new Decoder(){

            public Object decode(Response response, Type type) throws IOException {
                throw new IOException("timeout");
            }
        }).target("http://localhost:" + this.server.getPort());
        CompletableFuture<String> cf = api.post();
        this.server.takeRequest();
        this.unwrap(cf);
    }

    @Test
    public void throwsFeignExceptionIncludingBody() throws Throwable {
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterfaceAsync api = (TestInterfaceAsync)AsyncFeign.asyncBuilder().decoder((response, type) -> {
            throw new IOException("timeout");
        }).target(TestInterfaceAsync.class, "http://localhost:" + this.server.getPort());
        CompletableFuture<String> cf = api.body("Request body");
        this.server.takeRequest();
        try {
            this.unwrap(cf);
        }
        catch (FeignException e) {
            MockWebServerAssertions.assertThat((String)e.getMessage()).isEqualTo("timeout reading POST http://localhost:" + this.server.getPort() + "/");
            MockWebServerAssertions.assertThat((String)e.contentUTF8()).isEqualTo("Request body");
            return;
        }
        Assert.fail();
    }

    @Test
    public void throwsFeignExceptionWithoutBody() {
        this.server.enqueue(new MockResponse().setBody("success!"));
        TestInterfaceAsync api = (TestInterfaceAsync)AsyncFeign.asyncBuilder().decoder((response, type) -> {
            throw new IOException("timeout");
        }).target(TestInterfaceAsync.class, "http://localhost:" + this.server.getPort());
        try {
            api.noContent();
        }
        catch (FeignException e) {
            MockWebServerAssertions.assertThat((String)e.getMessage()).isEqualTo("timeout reading POST http://localhost:" + this.server.getPort() + "/");
            MockWebServerAssertions.assertThat((String)e.contentUTF8()).isEqualTo("");
        }
    }

    @Test
    public void whenReturnTypeIsResponseNoErrorHandling() throws Throwable {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        headers.put("Location", Arrays.asList("http://bar.com"));
        Response response = Response.builder().status(302).reason("Found").headers(headers).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body(new byte[0]).build();
        ExecutorService execs = Executors.newSingleThreadExecutor();
        TestInterfaceAsync api = (TestInterfaceAsync)AsyncFeign.asyncBuilder().client((AsyncClient)new AsyncClient.Default((request, options) -> response, execs)).target(TestInterfaceAsync.class, "http://localhost:" + this.server.getPort());
        MockWebServerAssertions.assertThat((Map)this.unwrap(api.response()).headers()).hasEntrySatisfying((Object)"Location", value -> MockWebServerAssertions.assertThat((Collection)value).contains((Object[])new String[]{"http://bar.com"}));
        execs.shutdown();
    }

    @Test
    public void okIfDecodeRootCauseHasNoMessage() throws Throwable {
        this.server.enqueue(new MockResponse().setBody("success!"));
        this.thrown.expect(DecodeException.class);
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().decoder(new Decoder(){

            public Object decode(Response response, Type type) throws IOException {
                throw new RuntimeException();
            }
        }).target("http://localhost:" + this.server.getPort());
        this.unwrap(api.post());
    }

    @Test
    public void decodingExceptionGetWrappedInDecode404Mode() throws Throwable {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.thrown.expect(DecodeException.class);
        this.thrown.expectCause(CoreMatchers.isA(NoSuchElementException.class));
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().decode404().decoder(new Decoder(){

            public Object decode(Response response, Type type) throws IOException {
                Assert.assertEquals((long)404L, (long)response.status());
                throw new NoSuchElementException();
            }
        }).target("http://localhost:" + this.server.getPort());
        this.unwrap(api.post());
    }

    @Test
    public void decodingDoesNotSwallow404ErrorsInDecode404Mode() throws Throwable {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        this.thrown.expect(IllegalArgumentException.class);
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().decode404().errorDecoder((ErrorDecoder)new IllegalArgumentExceptionOn404()).target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.queryMap(Collections.emptyMap());
        this.server.takeRequest();
        this.unwrap(cf);
    }

    @Test
    public void okIfEncodeRootCauseHasNoMessage() throws Throwable {
        this.server.enqueue(new MockResponse().setBody("success!"));
        this.thrown.expect(EncodeException.class);
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().encoder(new Encoder(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                throw new RuntimeException();
            }
        }).target("http://localhost:" + this.server.getPort());
        this.unwrap(api.body(Arrays.asList("foo")));
    }

    @Test
    public void equalsHashCodeAndToStringWork() {
        Target.HardCodedTarget t1 = new Target.HardCodedTarget(TestInterfaceAsync.class, "http://localhost:8080");
        Target.HardCodedTarget t2 = new Target.HardCodedTarget(TestInterfaceAsync.class, "http://localhost:8888");
        Target.HardCodedTarget t3 = new Target.HardCodedTarget(OtherTestInterfaceAsync.class, "http://localhost:8080");
        TestInterfaceAsync i1 = (TestInterfaceAsync)AsyncFeign.asyncBuilder().target((Target)t1);
        TestInterfaceAsync i2 = (TestInterfaceAsync)AsyncFeign.asyncBuilder().target((Target)t1);
        TestInterfaceAsync i3 = (TestInterfaceAsync)AsyncFeign.asyncBuilder().target((Target)t2);
        OtherTestInterfaceAsync i4 = (OtherTestInterfaceAsync)AsyncFeign.asyncBuilder().target((Target)t3);
        ((ObjectAssert)((ObjectAssert)MockWebServerAssertions.assertThat((Object)i1).isEqualTo((Object)i2)).isNotEqualTo((Object)i3)).isNotEqualTo((Object)i4);
        MockWebServerAssertions.assertThat((int)i1.hashCode()).isEqualTo(i2.hashCode()).isNotEqualTo(i3.hashCode()).isNotEqualTo(i4.hashCode());
        ((AbstractStringAssert)MockWebServerAssertions.assertThat((String)i1.toString()).isEqualTo(i2.toString()).isNotEqualTo((Object)i3.toString())).isNotEqualTo((Object)i4.toString());
        MockWebServerAssertions.assertThat((Object)t1).isNotEqualTo((Object)i1);
        MockWebServerAssertions.assertThat((int)t1.hashCode()).isEqualTo(i1.hashCode());
        MockWebServerAssertions.assertThat((String)t1.toString()).isEqualTo(i1.toString());
    }

    @Test
    public void decodeLogicSupportsByteArray() throws Throwable {
        byte[] expectedResponse = new byte[]{12, 34, 56};
        this.server.enqueue(new MockResponse().setBody(new Buffer().write(expectedResponse)));
        OtherTestInterfaceAsync api = (OtherTestInterfaceAsync)AsyncFeign.asyncBuilder().target(OtherTestInterfaceAsync.class, "http://localhost:" + this.server.getPort());
        MockWebServerAssertions.assertThat((byte[])this.unwrap(api.binaryResponseBody())).containsExactly(expectedResponse);
    }

    @Test
    public void encodeLogicSupportsByteArray() throws Exception {
        byte[] expectedRequest = new byte[]{12, 34, 56};
        this.server.enqueue(new MockResponse());
        OtherTestInterfaceAsync api = (OtherTestInterfaceAsync)AsyncFeign.asyncBuilder().target(OtherTestInterfaceAsync.class, "http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.binaryRequestBody(expectedRequest);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasBody(expectedRequest);
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void encodedQueryParam() throws Exception {
        this.server.enqueue(new MockResponse());
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().target("http://localhost:" + this.server.getPort());
        CompletableFuture<Void> cf = api.encodedQueryParam("5.2FSi+");
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasPath("/?trim=5.2FSi%2B");
        this.checkCFCompletedSoon(cf);
    }

    private void checkCFCompletedSoon(CompletableFuture<?> cf) {
        try {
            this.unwrap(cf);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Test
    public void responseMapperIsAppliedBeforeDelegate() throws IOException {
        Feign.ResponseMappingDecoder decoder = new Feign.ResponseMappingDecoder(this.upperCaseResponseMapper(), (Decoder)new StringDecoder());
        String output = (String)decoder.decode(this.responseWithText("response"), String.class);
        MockWebServerAssertions.assertThat((String)output).isEqualTo("RESPONSE");
    }

    private ResponseMapper upperCaseResponseMapper() {
        return new ResponseMapper(){

            public Response map(Response response, Type type) {
                try {
                    return response.toBuilder().body(Util.toString((Reader)response.body().asReader()).toUpperCase().getBytes()).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Response responseWithText(String text) {
        return Response.builder().body(text, Util.UTF_8).status(200).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).headers(new HashMap()).build();
    }

    @Test
    public void mapAndDecodeExecutesMapFunction() throws Throwable {
        this.server.enqueue(new MockResponse().setBody("response!"));
        TestInterfaceAsync api = (TestInterfaceAsync)AsyncFeign.asyncBuilder().mapAndDecode(this.upperCaseResponseMapper(), (Decoder)new StringDecoder()).target(TestInterfaceAsync.class, "http://localhost:" + this.server.getPort());
        Assert.assertEquals((Object)"RESPONSE!", (Object)this.unwrap(api.post()));
    }

    @Test
    public void beanQueryMapEncoderWithPrivateGetterIgnored() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().queryMapEndcoder((QueryMapEncoder)new BeanQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        PropertyPojo.ChildPojoClass propertyPojo = new PropertyPojo.ChildPojoClass();
        propertyPojo.setPrivateGetterProperty("privateGetterProperty");
        propertyPojo.setName("Name");
        propertyPojo.setNumber(1);
        this.server.enqueue(new MockResponse());
        CompletableFuture<Void> cf = api.queryMapPropertyPojo(propertyPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams(Arrays.asList("name=Name", "number=1"));
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void queryMap_with_child_pojo() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().queryMapEndcoder((QueryMapEncoder)new FieldQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        ChildPojo childPojo = new ChildPojo();
        childPojo.setChildPrivateProperty("first");
        childPojo.setParentProtectedProperty("second");
        childPojo.setParentPublicProperty("third");
        this.server.enqueue(new MockResponse());
        CompletableFuture<Void> cf = api.queryMapPropertyInheritence(childPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams("parentPublicProperty=third", "parentProtectedProperty=second", "childPrivateProperty=first");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void beanQueryMapEncoderWithNullValueIgnored() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().queryMapEndcoder((QueryMapEncoder)new BeanQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        PropertyPojo.ChildPojoClass propertyPojo = new PropertyPojo.ChildPojoClass();
        propertyPojo.setName(null);
        propertyPojo.setNumber(1);
        this.server.enqueue(new MockResponse());
        CompletableFuture<Void> cf = api.queryMapPropertyPojo(propertyPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams("number=1");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void beanQueryMapEncoderWithEmptyParams() throws Exception {
        TestInterfaceAsync api = new TestInterfaceAsyncBuilder().queryMapEndcoder((QueryMapEncoder)new BeanQueryMapEncoder()).target("http://localhost:" + this.server.getPort());
        PropertyPojo.ChildPojoClass propertyPojo = new PropertyPojo.ChildPojoClass();
        this.server.enqueue(new MockResponse());
        CompletableFuture<Void> cf = api.queryMapPropertyPojo(propertyPojo);
        MockWebServerAssertions.assertThat(this.server.takeRequest()).hasQueryParams("/");
        this.checkCFCompletedSoon(cf);
    }

    @Test
    public void testNonInterface() {
        this.thrown.expect(IllegalArgumentException.class);
        AsyncFeign.asyncBuilder().target(NonInterface.class, "http://localhost");
    }

    @Test
    public void testExtendedCFReturnType() {
        this.thrown.expect(IllegalArgumentException.class);
        AsyncFeign.asyncBuilder().target(ExtendedCFApi.class, "http://localhost");
    }

    @Test
    public void testLowerWildReturnType() {
        this.thrown.expect(IllegalArgumentException.class);
        AsyncFeign.asyncBuilder().target(LowerWildApi.class, "http://localhost");
    }

    @Test
    public void testUpperWildReturnType() {
        this.thrown.expect(IllegalArgumentException.class);
        AsyncFeign.asyncBuilder().target(UpperWildApi.class, "http://localhost");
    }

    @Test
    public void testrWildReturnType() {
        this.thrown.expect(IllegalArgumentException.class);
        AsyncFeign.asyncBuilder().target(WildApi.class, "http://localhost");
    }

    static interface WildApi {
        @RequestLine(value="GET /")
        public CompletableFuture<?> x();
    }

    static interface UpperWildApi {
        @RequestLine(value="GET /")
        public CompletableFuture<? super Object> x();
    }

    static interface LowerWildApi {
        @RequestLine(value="GET /")
        public CompletableFuture<? extends Object> x();
    }

    static interface ExtendedCFApi {
        @RequestLine(value="GET /")
        public ExtendedCF<Void> x();
    }

    static interface NonCFApi {
        @RequestLine(value="GET /")
        public void x();
    }

    static abstract class NonInterface {
        NonInterface() {
        }

        @RequestLine(value="GET /")
        abstract CompletableFuture<Void> x();
    }

    static final class ExtendedCF<T>
    extends CompletableFuture<T> {
        ExtendedCF() {
        }
    }

    static final class TestInterfaceAsyncBuilder {
        private final AsyncFeign.AsyncBuilder<Void> delegate = AsyncFeign.asyncBuilder().decoder((Decoder)new Decoder.Default()).encoder(new Encoder(){

            public void encode(Object object, Type bodyType, RequestTemplate template) {
                if (object instanceof Map) {
                    template.body(new Gson().toJson(object));
                } else {
                    template.body(object.toString());
                }
            }
        });

        TestInterfaceAsyncBuilder() {
        }

        TestInterfaceAsyncBuilder requestInterceptor(RequestInterceptor requestInterceptor) {
            this.delegate.requestInterceptor(requestInterceptor);
            return this;
        }

        TestInterfaceAsyncBuilder encoder(Encoder encoder) {
            this.delegate.encoder(encoder);
            return this;
        }

        TestInterfaceAsyncBuilder decoder(Decoder decoder) {
            this.delegate.decoder(decoder);
            return this;
        }

        TestInterfaceAsyncBuilder errorDecoder(ErrorDecoder errorDecoder) {
            this.delegate.errorDecoder(errorDecoder);
            return this;
        }

        TestInterfaceAsyncBuilder decode404() {
            this.delegate.decode404();
            return this;
        }

        TestInterfaceAsyncBuilder queryMapEndcoder(QueryMapEncoder queryMapEncoder) {
            this.delegate.queryMapEncoder(queryMapEncoder);
            return this;
        }

        TestInterfaceAsync target(String url) {
            return (TestInterfaceAsync)this.delegate.target(TestInterfaceAsync.class, url);
        }
    }

    static class IllegalArgumentExceptionOn404
    extends ErrorDecoder.Default {
        IllegalArgumentExceptionOn404() {
        }

        public Exception decode(String methodKey, Response response) {
            if (response.status() == 404) {
                return new IllegalArgumentException("bad zone name");
            }
            return super.decode(methodKey, response);
        }
    }

    static class IllegalArgumentExceptionOn400
    extends ErrorDecoder.Default {
        IllegalArgumentExceptionOn400() {
        }

        public Exception decode(String methodKey, Response response) {
            if (response.status() == 400) {
                return new IllegalArgumentException("bad zone name");
            }
            return super.decode(methodKey, response);
        }
    }

    static class UserAgentInterceptor
    implements RequestInterceptor {
        UserAgentInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("User-Agent", new String[]{"Feign"});
        }
    }

    static class ForwardedForInterceptor
    implements RequestInterceptor {
        ForwardedForInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("X-Forwarded-For", new String[]{"origin.host.com"});
        }
    }

    static interface OtherTestInterfaceAsync {
        @RequestLine(value="POST /")
        public CompletableFuture<String> post();

        @RequestLine(value="POST /")
        public CompletableFuture<byte[]> binaryResponseBody();

        @RequestLine(value="POST /")
        public CompletableFuture<Void> binaryRequestBody(byte[] var1);
    }

    class TestInterfaceException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TestInterfaceException(String message) {
            super(message);
        }
    }

    static interface TestInterfaceAsync {
        @RequestLine(value="POST /")
        public CompletableFuture<Response> response();

        @RequestLine(value="POST /")
        public CompletableFuture<String> post() throws TestInterfaceException;

        @RequestLine(value="POST /")
        @Body(value="%7B\"customer_name\": \"{customer_name}\", \"user_name\": \"{user_name}\", \"password\": \"{password}\"%7D")
        public CompletableFuture<Void> login(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);

        @RequestLine(value="POST /")
        public CompletableFuture<Void> body(List<String> var1);

        @RequestLine(value="POST /")
        public CompletableFuture<String> body(String var1);

        @RequestLine(value="POST /")
        public CompletableFuture<String> noContent();

        @RequestLine(value="POST /")
        @Headers(value={"Content-Encoding: gzip"})
        public CompletableFuture<Void> gzipBody(List<String> var1);

        @RequestLine(value="POST /")
        @Headers(value={"Content-Encoding: deflate"})
        public CompletableFuture<Void> deflateBody(List<String> var1);

        @RequestLine(value="POST /")
        public CompletableFuture<Void> form(@Param(value="customer_name") String var1, @Param(value="user_name") String var2, @Param(value="password") String var3);

        @RequestLine(value="GET /{1}/{2}")
        public CompletableFuture<Response> uriParam(@Param(value="1") String var1, URI var2, @Param(value="2") String var3);

        @RequestLine(value="GET /?1={1}&2={2}")
        public CompletableFuture<Response> queryParams(@Param(value="1") String var1, @Param(value="2") Iterable<String> var2);

        @RequestLine(value="POST /?date={date}")
        public CompletableFuture<Void> expand(@Param(value="date", expander=DateToMillis.class) Date var1);

        @RequestLine(value="GET /?date={date}")
        public CompletableFuture<Void> expandList(@Param(value="date", expander=DateToMillis.class) List<Date> var1);

        @RequestLine(value="GET /?date={date}")
        public CompletableFuture<Void> expandArray(@Param(value="date", expander=DateToMillis.class) Date[] var1);

        @RequestLine(value="GET /")
        public CompletableFuture<Void> headerMap(@HeaderMap Map<String, Object> var1);

        @RequestLine(value="GET /")
        @Headers(value={"Content-Encoding: deflate"})
        public CompletableFuture<Void> headerMapWithHeaderAnnotations(@HeaderMap Map<String, Object> var1);

        @RequestLine(value="GET /")
        public CompletableFuture<Void> queryMap(@QueryMap Map<String, Object> var1);

        @RequestLine(value="GET /")
        public CompletableFuture<Void> queryMapEncoded(@QueryMap(encoded=true) Map<String, Object> var1);

        @RequestLine(value="GET /?name={name}")
        public CompletableFuture<Void> queryMapWithQueryParams(@Param(value="name") String var1, @QueryMap Map<String, Object> var2);

        @RequestLine(value="GET /?trim={trim}")
        public CompletableFuture<Void> encodedQueryParam(@Param(value="trim", encoded=true) String var1);

        @RequestLine(value="GET /")
        public CompletableFuture<Void> queryMapPojo(@QueryMap CustomPojo var1);

        @RequestLine(value="GET /")
        public CompletableFuture<Void> queryMapPropertyPojo(@QueryMap PropertyPojo var1);

        @RequestLine(value="GET /")
        public CompletableFuture<Void> queryMapPropertyInheritence(@QueryMap ChildPojo var1);

        public static class DateToMillis
        implements Param.Expander {
            public String expand(Object value) {
                return String.valueOf(((Date)value).getTime());
            }
        }
    }
}

