/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AlwaysEncodeBodyContract;
import feign.Client;
import feign.Contract;
import feign.DeclarativeContract;
import feign.Feign;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class AlwaysEncodeBodyContractTest {
    @Test
    public void alwaysEncodeBodyTrueTest() {
        SampleTargetMultipleNonAnnotatedParameters sampleClient1 = (SampleTargetMultipleNonAnnotatedParameters)Feign.builder().contract((Contract)new SampleContract()).encoder((Encoder)new AllParametersSampleEncoder()).client((Client)new SampleClient()).target(SampleTargetMultipleNonAnnotatedParameters.class, "http://localhost");
        Assert.assertEquals((Object)"foobarchar", (Object)sampleClient1.concatenate("foo", "bar", "char"));
        SampleTargetNoParameters sampleClient2 = (SampleTargetNoParameters)Feign.builder().contract((Contract)new SampleContract()).encoder((Encoder)new AllParametersSampleEncoder()).client((Client)new SampleClient()).target(SampleTargetNoParameters.class, "http://localhost");
        Assert.assertEquals((Object)"", (Object)sampleClient2.concatenate());
        SampleTargetOneParameter sampleClient3 = (SampleTargetOneParameter)Feign.builder().contract((Contract)new SampleContract()).encoder((Encoder)new AllParametersSampleEncoder()).client((Client)new SampleClient()).target(SampleTargetOneParameter.class, "http://localhost");
        Assert.assertEquals((Object)"moo", (Object)sampleClient3.concatenate("moo"));
    }

    private static class SampleClient
    implements Client {
        private SampleClient() {
        }

        public Response execute(Request request, Request.Options options) throws IOException {
            return Response.builder().status(200).request(request).body(request.body()).build();
        }
    }

    private static class BodyParameterSampleEncoder
    implements Encoder {
        private BodyParameterSampleEncoder() {
        }

        public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
            template.body(String.valueOf(object));
        }
    }

    private static class AllParametersSampleEncoder
    implements Encoder {
        private AllParametersSampleEncoder() {
        }

        public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
            Object[] methodParameters = (Object[])object;
            String body = Arrays.stream(methodParameters).map(String::valueOf).collect(Collectors.joining());
            template.body(body);
        }
    }

    private static interface SampleTargetOneParameter {
        @SampleMethodAnnotation
        public String concatenate(String var1);
    }

    private static interface SampleTargetNoParameters {
        @SampleMethodAnnotation
        public String concatenate();
    }

    private static interface SampleTargetMultipleNonAnnotatedParameters {
        @SampleMethodAnnotation
        public String concatenate(String var1, String var2, String var3);
    }

    private static class SampleContract
    extends AlwaysEncodeBodyContract {
        SampleContract() {
            DeclarativeContract.AnnotationProcessor annotationProcessor = (annotation, metadata) -> metadata.template().method(Request.HttpMethod.POST);
            super.registerMethodAnnotation(SampleMethodAnnotation.class, annotationProcessor);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface SampleMethodAnnotation {
    }
}

