/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.placeholder.AudiencePlaceholder;
import io.github.miniplaceholders.api.placeholder.RelationalPlaceholder;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Tags {
    private Tags() {
    }

    static Relational relational(@NotNull String name, @NotNull RelationalPlaceholder relationalPlaceholder) {
        return new Relational(name, relationalPlaceholder);
    }

    static Single single(@NotNull String name, @NotNull AudiencePlaceholder audiencePlaceholder) {
        return new Single(name, audiencePlaceholder);
    }

    static final class Relational {
        private final RelationalPlaceholder relationalPlaceholder;
        private final String key;

        Relational(String key, RelationalPlaceholder relationalPlaceholder) {
            this.relationalPlaceholder = relationalPlaceholder;
            this.key = key;
        }

        TagResolver of(final @NotNull Audience audience, final @NotNull Audience otherAudience) {
            return new TagResolver(){

                @Nullable
                public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
                    return this.has(name) ? relationalPlaceholder.tag(audience, otherAudience, arguments, ctx) : null;
                }

                public boolean has(@NotNull String name) {
                    return key.equalsIgnoreCase(name);
                }
            };
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Relational)) {
                return false;
            }
            Relational that = (Relational)o;
            return that.key.equalsIgnoreCase(this.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    static final class Single {
        private final AudiencePlaceholder audiencePlaceholder;
        private final String key;

        private Single(@NotNull String key, @NotNull AudiencePlaceholder audiencePlaceholder) {
            this.key = key;
            this.audiencePlaceholder = audiencePlaceholder;
        }

        TagResolver of(final @NotNull Audience audience) {
            return new TagResolver(){

                @Nullable
                public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
                    return this.has(name) ? audiencePlaceholder.tag(audience, arguments, ctx) : null;
                }

                public boolean has(@NotNull String name) {
                    return key.equalsIgnoreCase(name);
                }
            };
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Single)) {
                return false;
            }
            Single that = (Single)o;
            return that.key.equalsIgnoreCase(this.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

