/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.MiniPlaceholders;
import io.github.miniplaceholders.api.Tags;
import io.github.miniplaceholders.api.placeholder.AudiencePlaceholder;
import io.github.miniplaceholders.api.placeholder.RelationalPlaceholder;
import io.github.miniplaceholders.api.utils.Conditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExpansionImpl
implements Expansion {
    private static final Tags.Single[] EMPTY_SINGLE_AUDIENCE = new Tags.Single[0];
    private static final Tags.Relational[] EMPTY_RELATIONAL_AUDIENCE = new Tags.Relational[0];
    private final String name;
    private final Tags.Single[] audiencePlaceholders;
    private final Tags.Relational[] relationalPlaceholders;
    private final TagResolver globalPlaceholders;
    private final Class<? extends Audience> filterClass;
    private final Predicate<Audience> predicateFilter;

    ExpansionImpl(@NotNull String expansionName, @Nullable Collection<Tags.Single> audiencePlaceholders, @Nullable Collection<Tags.Relational> relationalPlaceholders, @Nullable TagResolver globalPlaceholders, @Nullable Class<? extends Audience> filterClass, @Nullable Predicate<Audience> predicateFilter) {
        this.name = expansionName + "-";
        this.audiencePlaceholders = audiencePlaceholders != null ? audiencePlaceholders.toArray(EMPTY_SINGLE_AUDIENCE) : EMPTY_SINGLE_AUDIENCE;
        this.relationalPlaceholders = relationalPlaceholders != null ? relationalPlaceholders.toArray(EMPTY_RELATIONAL_AUDIENCE) : EMPTY_RELATIONAL_AUDIENCE;
        this.globalPlaceholders = globalPlaceholders;
        this.filterClass = filterClass;
        this.predicateFilter = predicateFilter;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public TagResolver audiencePlaceholders(@NotNull Audience audience) {
        if (this.audiencePlaceholders.length == 0) {
            return TagResolver.empty();
        }
        Objects.requireNonNull(audience, "the audience cannot be null");
        audience = this.expansionFilter(audience);
        if (audience == null) {
            return TagResolver.empty();
        }
        TagResolver.Builder placeholders = TagResolver.builder();
        for (Tags.Single pl : this.audiencePlaceholders) {
            placeholders.resolver(pl.of(audience));
        }
        return placeholders.build();
    }

    private Audience expansionFilter(Audience audience) {
        boolean eligible;
        if (audience == null || this.filterClass == null && this.predicateFilter == null) {
            return audience;
        }
        boolean bl = eligible = this.filterClass != null && this.filterClass.isInstance(audience) || this.predicateFilter != null && this.predicateFilter.test(audience);
        if (eligible) {
            return audience;
        }
        if (audience instanceof ForwardingAudience.Single) {
            ForwardingAudience.Single forward = (ForwardingAudience.Single)audience;
            return this.expansionFilter(forward.audience());
        }
        return null;
    }

    @Override
    @NotNull
    public TagResolver relationalPlaceholders(@NotNull Audience audience, @NotNull Audience otherAudience) {
        if (this.relationalPlaceholders.length == 0) {
            return TagResolver.empty();
        }
        Objects.requireNonNull(audience, "the audience cannot be null");
        Objects.requireNonNull(otherAudience, "the other audience cannot be null");
        audience = this.expansionFilter(audience);
        otherAudience = this.expansionFilter(otherAudience);
        if (audience == null || otherAudience == null) {
            return TagResolver.empty();
        }
        TagResolver.Builder placeholders = TagResolver.builder();
        for (Tags.Relational pl : this.relationalPlaceholders) {
            placeholders.resolver(pl.of(audience, otherAudience));
        }
        return placeholders.build();
    }

    @Override
    @NotNull
    public TagResolver globalPlaceholders() {
        return this.globalPlaceholders;
    }

    @Override
    public void register() {
        if (this.registered()) {
            throw new IllegalStateException("Expansion" + this.name + "is already registered");
        }
        MiniPlaceholders.expansions.add(this);
    }

    @Override
    public void unregister() {
        if (!this.registered()) {
            throw new IllegalStateException("Expansion " + this.name + " is not registered");
        }
        MiniPlaceholders.expansions.remove(this);
    }

    @Override
    public boolean registered() {
        return MiniPlaceholders.expansions.contains(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expansion)) {
            return false;
        }
        Expansion that = (Expansion)o;
        return that.name().equalsIgnoreCase(this.name());
    }

    public int hashCode() {
        return Objects.hash(this.name.hashCode());
    }

    static final class Builder
    implements Expansion.Builder {
        private final String expansionName;
        private Set<Tags.Single> audiencePlaceholders;
        private Set<Tags.Relational> relationalPlaceholders;
        private TagResolver.Builder globalPlaceholders;
        private Class<? extends Audience> filterClass;
        private Predicate<Audience> predicateFilter;

        Builder(@NotNull String name) {
            this.expansionName = Conditions.nonNullOrEmptyString(name, "Expansion name").toLowerCase(Locale.ROOT).concat("_");
        }

        @Override
        @NotNull
        public Builder audiencePlaceholder(@NotNull String key, @NotNull AudiencePlaceholder audiencePlaceholder) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(audiencePlaceholder, "the audience placeholder cannot be null");
            if (this.audiencePlaceholders == null) {
                this.audiencePlaceholders = new HashSet<Tags.Single>();
            }
            this.audiencePlaceholders.add(Tags.single(this.expansionName + key, audiencePlaceholder));
            return this;
        }

        @Override
        @NotNull
        public Builder relationalPlaceholder(@NotNull String key, @NotNull RelationalPlaceholder relationalPlaceholder) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(relationalPlaceholder, "the relational placeholder cannot be null");
            if (this.relationalPlaceholders == null) {
                this.relationalPlaceholders = new HashSet<Tags.Relational>();
            }
            this.relationalPlaceholders.add(Tags.relational(this.expansionName + "rel_" + key, relationalPlaceholder));
            return this;
        }

        @Override
        @NotNull
        public Builder globalPlaceholder(@NotNull String key, @NotNull BiFunction<ArgumentQueue, Context, Tag> function) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(function, "the global placeholder cannot be null");
            if (this.globalPlaceholders == null) {
                this.globalPlaceholders = TagResolver.builder();
            }
            this.globalPlaceholders.tag(this.expansionName + key, function);
            return this;
        }

        @Override
        @NotNull
        public Builder globalPlaceholder(@NotNull String key, @NotNull Tag tag) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(tag, "the tag cannot be null");
            if (this.globalPlaceholders == null) {
                this.globalPlaceholders = TagResolver.builder();
            }
            this.globalPlaceholders.tag(this.expansionName + key, tag);
            return this;
        }

        @Override
        @NotNull
        public Builder filter(@Nullable Class<? extends Audience> clazz) {
            this.filterClass = clazz;
            return this;
        }

        @Override
        @NotNull
        public Builder filter(@Nullable Predicate<Audience> predicate) {
            this.predicateFilter = predicate;
            return this;
        }

        @NotNull
        public Expansion build() {
            return new ExpansionImpl(this.expansionName, this.audiencePlaceholders, this.relationalPlaceholders, this.globalPlaceholders != null ? this.globalPlaceholders.build() : TagResolver.empty(), this.filterClass, this.predicateFilter);
        }
    }
}

