/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.ExpansionImpl;
import io.github.miniplaceholders.api.placeholder.AudiencePlaceholder;
import io.github.miniplaceholders.api.placeholder.RelationalPlaceholder;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Expansion {
    @NotNull
    public String name();

    @NotNull
    public TagResolver audiencePlaceholders(@NotNull Audience var1);

    @NotNull
    public TagResolver relationalPlaceholders(@NotNull Audience var1, @NotNull Audience var2);

    @NotNull
    public TagResolver globalPlaceholders();

    public void register();

    public void unregister();

    public boolean registered();

    @NotNull
    public static Builder builder(@NotNull String name) {
        return new ExpansionImpl.Builder(name);
    }

    public static interface Builder
    extends AbstractBuilder<Expansion> {
        @NotNull
        public Builder audiencePlaceholder(@NotNull String var1, @NotNull AudiencePlaceholder var2);

        @NotNull
        public Builder relationalPlaceholder(@NotNull String var1, @NotNull RelationalPlaceholder var2);

        @NotNull
        public Builder globalPlaceholder(@NotNull String var1, @NotNull @NotNull BiFunction<@NotNull ArgumentQueue, @NotNull Context, @Nullable Tag> var2);

        @NotNull
        public Builder globalPlaceholder(@NotNull String var1, @NotNull Tag var2);

        @Contract(value="_ -> this")
        @NotNull
        public Builder filter(@Nullable Class<? extends Audience> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder filter(@Nullable Predicate<@NotNull Audience> var1);
    }
}

