/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AnnotationInfo
extends ScanResult.InfoObject
implements Comparable<AnnotationInfo> {
    final String annotationName;
    List<AnnotationParamValue> annotationParamValues;
    private ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
        if (this.annotationParamValues != null) {
            for (AnnotationParamValue a : this.annotationParamValues) {
                a.setScanResult(scanResult);
            }
        }
    }

    public AnnotationInfo(String annotationName, List<AnnotationParamValue> annotationParamValues) {
        this.annotationName = annotationName;
        if (annotationParamValues != null) {
            Collections.sort(annotationParamValues);
        }
        this.annotationParamValues = annotationParamValues;
    }

    void addDefaultValues(List<AnnotationParamValue> defaultAnnotationParamValues) {
        if (defaultAnnotationParamValues != null && !defaultAnnotationParamValues.isEmpty()) {
            if (this.annotationParamValues == null || this.annotationParamValues.isEmpty()) {
                this.annotationParamValues = new ArrayList<AnnotationParamValue>(defaultAnnotationParamValues);
            } else {
                HashMap<String, Object> allParamValues = new HashMap<String, Object>();
                for (AnnotationParamValue annotationParamValue : defaultAnnotationParamValues) {
                    allParamValues.put(annotationParamValue.paramName, annotationParamValue.paramValue);
                }
                for (AnnotationParamValue annotationParamValue : this.annotationParamValues) {
                    allParamValues.put(annotationParamValue.paramName, annotationParamValue.paramValue);
                }
                this.annotationParamValues.clear();
                for (Map.Entry entry : allParamValues.entrySet()) {
                    this.annotationParamValues.add(new AnnotationParamValue((String)entry.getKey(), entry.getValue()));
                }
            }
        }
        if (this.annotationParamValues != null) {
            Collections.sort(this.annotationParamValues);
        }
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public Class<?> getAnnotationType() {
        return ReflectionUtils.typeStrToClass(this.annotationName, this.scanResult);
    }

    public List<AnnotationParamValue> getAnnotationParamValues() {
        return this.annotationParamValues;
    }

    @Override
    public int compareTo(AnnotationInfo o) {
        int diff = this.annotationName.compareTo(o.annotationName);
        if (diff != 0) {
            return diff;
        }
        if (this.annotationParamValues == null && o.annotationParamValues == null) {
            return 0;
        }
        if (this.annotationParamValues == null) {
            return -1;
        }
        if (o.annotationParamValues == null) {
            return 1;
        }
        int max = Math.max(this.annotationParamValues.size(), o.annotationParamValues.size());
        for (int i = 0; i < max; ++i) {
            if (i >= this.annotationParamValues.size()) {
                return -1;
            }
            if (i >= o.annotationParamValues.size()) {
                return 1;
            }
            int diff2 = this.annotationParamValues.get(i).compareTo(o.annotationParamValues.get(i));
            if (diff2 == 0) continue;
            return diff2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationInfo)) {
            return false;
        }
        AnnotationInfo o = (AnnotationInfo)obj;
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        int h = this.annotationName.hashCode();
        if (this.annotationParamValues != null) {
            for (int i = 0; i < this.annotationParamValues.size(); ++i) {
                AnnotationParamValue e = this.annotationParamValues.get(i);
                h = h * 7 + e.getParamName().hashCode() * 3 + e.getParamValue().hashCode();
            }
        }
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("@" + this.annotationName);
        if (this.annotationParamValues != null) {
            buf.append('(');
            for (int i = 0; i < this.annotationParamValues.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                AnnotationParamValue annotationParamValue = this.annotationParamValues.get(i);
                if (this.annotationParamValues.size() > 1 || !"value".equals(annotationParamValue.paramName)) {
                    annotationParamValue.toString(buf);
                    continue;
                }
                annotationParamValue.toStringParamValueOnly(buf);
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public static String[] getUniqueAnnotationNamesSorted(Collection<AnnotationInfo> annotationInfo) {
        if (annotationInfo == null || annotationInfo.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        HashSet<String> annotationNamesSet = new HashSet<String>();
        for (AnnotationInfo annotation : annotationInfo) {
            annotationNamesSet.add(annotation.annotationName);
        }
        Object[] annotationNamesSorted = new String[annotationNamesSet.size()];
        int i = 0;
        for (String annotationName : annotationNamesSet) {
            annotationNamesSorted[i++] = annotationName;
        }
        Arrays.sort(annotationNamesSorted);
        return annotationNamesSorted;
    }

    public static String[] getUniqueAnnotationNamesSorted(AnnotationInfo[] annotationInfo) {
        if (annotationInfo == null || annotationInfo.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        HashSet<String> annotationNamesSet = new HashSet<String>();
        for (AnnotationInfo annotation : annotationInfo) {
            annotationNamesSet.add(annotation.annotationName);
        }
        Object[] annotationNamesSorted = new String[annotationNamesSet.size()];
        int i = 0;
        for (String annotationName : annotationNamesSet) {
            annotationNamesSorted[i++] = annotationName;
        }
        Arrays.sort(annotationNamesSorted);
        return annotationNamesSorted;
    }

    public static class AnnotationClassRef
    extends ScanResult.InfoObject {
        private final String typeStr;
        private ScanResult scanResult;

        @Override
        void setScanResult(ScanResult scanResult) {
            this.scanResult = scanResult;
        }

        AnnotationClassRef(String annotationTypeStr) {
            this.typeStr = annotationTypeStr;
        }

        public String getTypeStr() {
            return this.typeStr;
        }

        public Class<?> getType() {
            return ReflectionUtils.typeStrToClass(this.typeStr, this.scanResult);
        }

        public String toString() {
            return this.typeStr + ".class";
        }
    }

    public static class AnnotationEnumValue
    extends ScanResult.InfoObject
    implements Comparable<AnnotationEnumValue> {
        final String className;
        final String constName;
        private ScanResult scanResult;

        public AnnotationEnumValue(String className, String constName) {
            this.className = className;
            this.constName = constName;
        }

        @Override
        void setScanResult(ScanResult scanResult) {
            this.scanResult = scanResult;
        }

        public String getClassName() {
            return this.className;
        }

        public String getConstName() {
            return this.constName;
        }

        public Object getEnumValueRef() throws IllegalArgumentException {
            Field field;
            Class<?> classRef = this.scanResult.classNameToClassRef(this.className);
            if (!classRef.isEnum()) {
                throw new IllegalArgumentException("Class " + this.className + " is not an enum");
            }
            try {
                field = classRef.getDeclaredField(this.constName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new IllegalArgumentException("Could not find enum constant " + this.toString(), e);
            }
            if (!field.isEnumConstant()) {
                throw new IllegalArgumentException("Field " + this.toString() + " is not an enum constant");
            }
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Field " + this.toString() + " is not accessible", e);
            }
        }

        @Override
        public int compareTo(AnnotationEnumValue o) {
            int diff = this.className.compareTo(o.className);
            return diff == 0 ? this.constName.compareTo(o.constName) : diff;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationEnumValue)) {
                return false;
            }
            return this.compareTo((AnnotationEnumValue)o) == 0;
        }

        public int hashCode() {
            return this.className.hashCode() * 11 + this.constName.hashCode();
        }

        public String toString() {
            return this.className + "." + this.constName;
        }
    }

    public static class AnnotationParamValue
    extends ScanResult.InfoObject
    implements Comparable<AnnotationParamValue> {
        private final String paramName;
        private final Object paramValue;

        public AnnotationParamValue(String paramName, Object paramValue) {
            this.paramName = paramName;
            this.paramValue = paramValue;
        }

        @Override
        void setScanResult(ScanResult scanResult) {
            if (this.paramValue != null) {
                if (this.paramValue instanceof ScanResult.InfoObject) {
                    ((ScanResult.InfoObject)this.paramValue).setScanResult(scanResult);
                } else {
                    Class<?> valClass = this.paramValue.getClass();
                    if (valClass.isArray()) {
                        int n = Array.getLength(this.paramValue);
                        for (int j = 0; j < n; ++j) {
                            Object elt = Array.get(this.paramValue, j);
                            if (elt == null || !(elt instanceof ScanResult.InfoObject)) continue;
                            ((ScanResult.InfoObject)elt).setScanResult(scanResult);
                        }
                    }
                }
            }
        }

        public String getParamName() {
            return this.paramName;
        }

        public Object getParamValue() {
            return this.paramValue;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        void toString(StringBuilder buf) {
            buf.append(this.paramName);
            buf.append(" = ");
            this.toStringParamValueOnly(buf);
        }

        void toStringParamValueOnly(StringBuilder buf) {
            if (this.paramValue == null) {
                buf.append("null");
            } else {
                Class<?> valClass = this.paramValue.getClass();
                if (valClass.isArray()) {
                    buf.append('{');
                    int n = Array.getLength(this.paramValue);
                    for (int j = 0; j < n; ++j) {
                        Object elt;
                        if (j > 0) {
                            buf.append(", ");
                        }
                        buf.append((elt = Array.get(this.paramValue, j)) == null ? "null" : elt.toString());
                    }
                    buf.append('}');
                } else if (this.paramValue instanceof String) {
                    buf.append('\"');
                    buf.append(this.paramValue.toString().replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
                    buf.append('\"');
                } else if (this.paramValue instanceof Character) {
                    buf.append('\'');
                    buf.append(this.paramValue.toString().replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r"));
                    buf.append('\'');
                } else {
                    buf.append(this.paramValue.toString());
                }
            }
        }

        @Override
        public int compareTo(AnnotationParamValue o) {
            int diff = this.paramName.compareTo(o.getParamName());
            if (diff != 0) {
                return diff;
            }
            if (this.paramValue == null && o.paramValue == null) {
                return 0;
            }
            if (this.paramValue == null) {
                return -1;
            }
            if (o.paramValue == null) {
                return 1;
            }
            if (this.paramValue instanceof Comparable && o.paramValue instanceof Comparable) {
                try {
                    int cmp = ((Comparable)this.paramValue).compareTo(o.paramValue);
                    return cmp;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return this.paramValue.toString().compareTo(o.paramValue.toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationParamValue)) {
                return false;
            }
            AnnotationParamValue o = (AnnotationParamValue)obj;
            int diff = this.compareTo(o);
            return diff != 0 ? false : (this.paramValue == null && o.paramValue == null ? true : this.paramValue != null && o.paramValue != null);
        }
    }
}

