/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassfileBinaryParser
implements AutoCloseable {
    private InputStream inputStream;
    private String className;
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 16384;
    private static final int SUBSEQUENT_BUFFER_CHUNK_SIZE = 4096;
    private byte[] buf = new byte[16384];
    private int curr = 0;
    private int used = 0;
    private int[] offset;
    private int[] tag;
    private int[] indirectStringRefs;

    ClassfileBinaryParser() {
    }

    @Override
    public void close() {
    }

    private void readMore(int bytesRequired) throws IOException, InterruptedException {
        int bytesRead;
        int extraBytesNeeded = bytesRequired - (this.used - this.curr);
        int bytesToRequest = extraBytesNeeded + 4096;
        int maxNewUsed = this.used + bytesToRequest;
        if (maxNewUsed > this.buf.length) {
            int newBufLen;
            for (newBufLen = this.buf.length; newBufLen < maxNewUsed; newBufLen <<= 1) {
            }
            this.buf = Arrays.copyOf(this.buf, newBufLen);
        }
        for (int extraBytesStillNotRead = extraBytesNeeded; extraBytesStillNotRead > 0; extraBytesStillNotRead -= bytesRead) {
            bytesRead = this.inputStream.read(this.buf, this.used, bytesToRequest);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (bytesRead > 0) {
                this.used += bytesRead;
                bytesToRequest -= bytesRead;
                continue;
            }
            if (extraBytesStillNotRead <= 0) break;
            throw new IOException("Premature EOF while reading classfile");
        }
    }

    private int readUnsignedByte() throws IOException, InterruptedException {
        if (this.curr > this.used - 1) {
            this.readMore(1);
        }
        return this.buf[this.curr++] & 0xFF;
    }

    private int readUnsignedByte(int offset) {
        return this.buf[offset] & 0xFF;
    }

    private int readUnsignedShort() throws IOException, InterruptedException {
        if (this.curr > this.used - 2) {
            this.readMore(2);
        }
        int val = (this.buf[this.curr] & 0xFF) << 8 | this.buf[this.curr + 1] & 0xFF;
        this.curr += 2;
        return val;
    }

    private int readUnsignedShort(int offset) {
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    private int readInt() throws IOException, InterruptedException {
        if (this.curr > this.used - 4) {
            this.readMore(4);
        }
        int val = (this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF;
        this.curr += 4;
        return val;
    }

    private int readInt(int offset) throws IOException {
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    private long readLong() throws IOException, InterruptedException {
        if (this.curr > this.used - 8) {
            this.readMore(8);
        }
        long val = (long)((this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF) << 32 | (long)((this.buf[this.curr + 4] & 0xFF) << 24) | (long)((this.buf[this.curr + 5] & 0xFF) << 16) | (long)((this.buf[this.curr + 6] & 0xFF) << 8) | (long)(this.buf[this.curr + 7] & 0xFF);
        this.curr += 8;
        return val;
    }

    private long readLong(int offset) throws IOException {
        return (long)((this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF) << 32 | (long)((this.buf[offset + 4] & 0xFF) << 24) | (long)((this.buf[offset + 5] & 0xFF) << 16) | (long)((this.buf[offset + 6] & 0xFF) << 8) | (long)(this.buf[offset + 7] & 0xFF);
    }

    private void skip(int bytesToSkip) throws IOException, InterruptedException {
        if (this.curr > this.used - bytesToSkip) {
            this.readMore(bytesToSkip);
        }
        this.curr += bytesToSkip;
    }

    private String readString(int strStart, boolean replaceSlashWithDot) {
        int c;
        int byteIdx;
        int utfLen = this.readUnsignedShort(strStart);
        int utfStart = strStart + 2;
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[utfStart + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[utfStart + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0x1F) << 6 | c2 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 2];
                    byte c3 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
            }
            throw new RuntimeException("Bad modified UTF8");
        }
        if (charIdx < utfLen) {
            return new String(chars, 0, charIdx);
        }
        return new String(chars);
    }

    private int getConstantPoolStringOffset(int CpIdx) {
        int t = this.tag[CpIdx];
        if (t != 1 && t != 7 && t != 8) {
            throw new RuntimeException("Wrong tag number at constant pool index " + CpIdx + ", cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
        }
        int cpIdx = CpIdx;
        if (t == 7 || t == 8) {
            int indirIdx = this.indirectStringRefs[CpIdx];
            if (indirIdx == -1) {
                throw new RuntimeException("Bad string indirection index, cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
            if (indirIdx == 0) {
                return 0;
            }
            cpIdx = indirIdx;
        }
        return this.offset[cpIdx];
    }

    private String getConstantPoolString(int CpIdx, boolean replaceSlashWithDot) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(CpIdx);
        return constantPoolStringOffset == 0 ? null : this.readString(constantPoolStringOffset, replaceSlashWithDot);
    }

    private String getConstantPoolString(int CpIdx) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(CpIdx);
        return constantPoolStringOffset == 0 ? null : this.readString(constantPoolStringOffset, false);
    }

    private byte getConstantPoolStringFirstByte(int CpIdx) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(CpIdx);
        if (constantPoolStringOffset == 0) {
            return 0;
        }
        int utfLen = this.readUnsignedShort(constantPoolStringOffset);
        if (utfLen == 0) {
            return 0;
        }
        return this.buf[constantPoolStringOffset + 2];
    }

    private String getConstantPoolClassName(int CpIdx) {
        return this.getConstantPoolString(CpIdx, true);
    }

    private boolean constantPoolStringEquals(int CpIdx, String otherString) {
        int otherLen;
        int strOffset = this.getConstantPoolStringOffset(CpIdx);
        if (strOffset == 0) {
            return otherString == null;
        }
        int strLen = this.readUnsignedShort(strOffset);
        if (strLen != (otherLen = otherString.length())) {
            return false;
        }
        int strStart = strOffset + 2;
        for (int i = 0; i < strLen; ++i) {
            if ((char)(this.buf[strStart + i] & 0xFF) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private Object getConstantPoolValue(int CpIdx) throws IOException {
        switch (this.tag[CpIdx]) {
            case 1: {
                return this.getConstantPoolString(CpIdx);
            }
            case 3: {
                return new Integer(this.readInt(this.offset[CpIdx]));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(this.offset[CpIdx])));
            }
            case 5: {
                return new Long(this.readLong(this.offset[CpIdx]));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(this.offset[CpIdx])));
            }
            case 7: 
            case 8: {
                return this.getConstantPoolString(CpIdx);
            }
        }
        throw new RuntimeException("Constant pool entry type " + this.tag[CpIdx] + " unsupported, cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
    }

    private String readAnnotation() throws IOException, InterruptedException {
        String annotationFieldDescriptor = this.getConstantPoolClassName(this.readUnsignedShort());
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1) : annotationFieldDescriptor;
        int numElementValuePairs = this.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            this.skip(2);
            this.readAnnotationElementValue();
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue() throws IOException, InterruptedException {
        char tag = (char)this.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                this.skip(2);
                break;
            }
            case 'e': {
                this.skip(4);
                break;
            }
            case 'c': {
                this.skip(2);
                break;
            }
            case '@': {
                this.readAnnotation();
                break;
            }
            case '[': {
                int count = this.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue();
                }
                break;
            }
            default: {
                throw new RuntimeException("Class " + this.className + " has unknown annotation element type tag '" + (char)tag + "': element size unknown, cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
        }
    }

    private void addFieldTypeDescriptorParts(ClassInfoUnlinked classInfoUnlinked, String typeDescriptor) {
        for (int i = 0; i < typeDescriptor.length(); ++i) {
            char c = typeDescriptor.charAt(i);
            if (c != 'L') continue;
            int typeNameStart = ++i;
            while (i < typeDescriptor.length() && (c = typeDescriptor.charAt(i)) != '<' && c != ';') {
                ++i;
            }
            char[] typeNameChars = new char[i - typeNameStart];
            for (int j = typeNameStart; j < i; ++j) {
                char chr = typeDescriptor.charAt(j);
                typeNameChars[j - typeNameStart] = chr == '/' ? 46 : (int)chr;
            }
            String typeName = new String(typeNameChars);
            classInfoUnlinked.addFieldType(typeName);
        }
    }

    ClassInfoUnlinked readClassInfoFromClassfileHeader(ClasspathElement classpathElement, String relativePath, InputStream inputStream, ScanSpec scanSpec, ConcurrentHashMap<String, String> stringInternMap, LogNode log) throws IOException, InterruptedException {
        this.inputStream = inputStream;
        this.className = null;
        this.curr = 0;
        this.used = inputStream.read(this.buf, 0, 16384);
        if (this.used < 0) {
            throw new IOException("Classfile " + relativePath + " is empty");
        }
        if (this.readInt() != -889275714) {
            throw new IOException("Classfile " + relativePath + " does not have correct classfile magic number");
        }
        this.readUnsignedShort();
        this.readUnsignedShort();
        int cpCount = this.readUnsignedShort();
        if (this.offset == null || this.offset.length < cpCount) {
            this.offset = new int[cpCount];
            this.tag = new int[cpCount];
            this.indirectStringRefs = new int[cpCount];
        }
        Arrays.fill(this.indirectStringRefs, 0, cpCount, -1);
        block17: for (int i = 1; i < cpCount; ++i) {
            this.tag[i] = this.readUnsignedByte();
            this.offset[i] = this.curr;
            switch (this.tag[i]) {
                case 1: {
                    int strLen = this.readUnsignedShort();
                    this.skip(strLen);
                    continue block17;
                }
                case 3: 
                case 4: {
                    this.skip(4);
                    continue block17;
                }
                case 5: 
                case 6: {
                    this.skip(8);
                    ++i;
                    continue block17;
                }
                case 7: 
                case 8: {
                    this.indirectStringRefs[i] = this.readUnsignedShort();
                    continue block17;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.skip(4);
                    continue block17;
                }
                case 15: {
                    this.skip(3);
                    continue block17;
                }
                case 16: {
                    this.skip(2);
                    continue block17;
                }
                case 18: {
                    this.skip(4);
                    continue block17;
                }
                default: {
                    throw new RuntimeException("Unknown constant pool tag " + this.tag + " in classfile " + relativePath + " (element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
                }
            }
        }
        int classModifierFlags = this.readUnsignedShort();
        boolean isInterface = (classModifierFlags & 0x200) != 0;
        boolean isAnnotation = (classModifierFlags & 0x2000) != 0;
        String classNamePath = this.getConstantPoolString(this.readUnsignedShort());
        String className = classNamePath.replace('/', '.');
        if ("java.lang.Object".equals(className)) {
            return null;
        }
        if (!relativePath.endsWith(".class")) {
            if (log != null) {
                log.log("File " + relativePath + " does not end in \".class\"");
            }
            return null;
        }
        int len = classNamePath.length();
        if (relativePath.length() != len + 6 || !classNamePath.regionMatches(0, relativePath, 0, len)) {
            if (log != null) {
                log.log("Class " + className + " is at incorrect relative path " + relativePath + " -- ignoring");
            }
            return null;
        }
        String superclassName = this.getConstantPoolClassName(this.readUnsignedShort());
        ClassInfoUnlinked classInfoUnlinked = new ClassInfoUnlinked(className, isInterface, isAnnotation, stringInternMap, classpathElement);
        classInfoUnlinked.addSuperclass(superclassName);
        int interfaceCount = this.readUnsignedShort();
        for (int i = 0; i < interfaceCount; ++i) {
            String interfaceName = this.getConstantPoolClassName(this.readUnsignedShort());
            classInfoUnlinked.addImplementedInterface(interfaceName);
        }
        MultiMapKeyToSet<String, String> classNameToStaticFinalFieldsToMatch = scanSpec.getClassNameToStaticFinalFieldsToMatch();
        Set<String> staticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch == null ? null : classNameToStaticFinalFieldsToMatch.get(className);
        boolean matchStaticFinalFields = staticFinalFieldsToMatch != null;
        int fieldCount = this.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            boolean matchThisStaticFinalField;
            int fieldModifierFlags = this.readUnsignedShort();
            boolean isPublicField = (fieldModifierFlags & 1) == 1;
            boolean isStaticFinalField = (fieldModifierFlags & 0x18) == 24;
            boolean fieldIsVisible = isPublicField || scanSpec.ignoreFieldVisibility;
            boolean bl = matchThisStaticFinalField = matchStaticFinalFields && isStaticFinalField && fieldIsVisible;
            if (!(fieldIsVisible && (scanSpec.enableFieldInfo || scanSpec.enableFieldTypeIndexing || matchThisStaticFinalField || scanSpec.enableFieldAnnotationIndexing))) {
                this.readUnsignedShort();
                this.readUnsignedShort();
                int attributesCount = this.readUnsignedShort();
                for (int j = 0; j < attributesCount; ++j) {
                    this.readUnsignedShort();
                    int attributeLength = this.readInt();
                    this.skip(attributeLength);
                }
                continue;
            }
            int fieldNameCpIdx = this.readUnsignedShort();
            String fieldName = null;
            boolean isMatchedFieldName = false;
            if (matchThisStaticFinalField || scanSpec.enableFieldInfo) {
                fieldName = this.getConstantPoolString(fieldNameCpIdx);
                if (matchThisStaticFinalField && staticFinalFieldsToMatch.contains(fieldName)) {
                    isMatchedFieldName = true;
                }
            }
            int fieldTypeDescriptorCpIdx = this.readUnsignedShort();
            char fieldTypeDescriptorFirstChar = (char)this.getConstantPoolStringFirstByte(fieldTypeDescriptorCpIdx);
            String fieldTypeDescriptor = null;
            if (scanSpec.enableFieldInfo) {
                fieldTypeDescriptor = this.getConstantPoolString(fieldTypeDescriptorCpIdx);
            }
            if (scanSpec.enableFieldTypeIndexing && fieldIsVisible) {
                this.addFieldTypeDescriptorParts(classInfoUnlinked, this.getConstantPoolString(fieldTypeDescriptorCpIdx));
            }
            Object fieldConstValue = null;
            boolean foundFieldConstValue = false;
            ArrayList<String> fieldAnnotationNames = null;
            if (scanSpec.enableFieldInfo && fieldIsVisible) {
                fieldAnnotationNames = new ArrayList<String>(1);
            }
            int attributesCount = this.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                int attributeNameCpIdx = this.readUnsignedShort();
                int attributeLength = this.readInt();
                if ((isMatchedFieldName || scanSpec.enableFieldInfo) && this.constantPoolStringEquals(attributeNameCpIdx, "ConstantValue")) {
                    fieldConstValue = this.getConstantPoolValue(this.readUnsignedShort());
                    switch (fieldTypeDescriptorFirstChar) {
                        case 'B': {
                            fieldConstValue = new Byte(((Integer)fieldConstValue).byteValue());
                            break;
                        }
                        case 'C': {
                            fieldConstValue = new Character((char)((Integer)fieldConstValue).intValue());
                            break;
                        }
                        case 'S': {
                            fieldConstValue = new Short(((Integer)fieldConstValue).shortValue());
                            break;
                        }
                        case 'Z': {
                            fieldConstValue = new Boolean((Integer)fieldConstValue != 0);
                            break;
                        }
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': {
                            break;
                        }
                        default: {
                            if (this.constantPoolStringEquals(fieldTypeDescriptorCpIdx, "Ljava/lang/String;")) break;
                            throw new RuntimeException("Unknown constant initializer type " + this.getConstantPoolString(fieldTypeDescriptorCpIdx) + " for class " + className + " -- please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
                        }
                    }
                    if (isMatchedFieldName) {
                        classInfoUnlinked.addFieldConstantValue(fieldName, fieldConstValue);
                    }
                    foundFieldConstValue = true;
                } else if (scanSpec.enableFieldTypeIndexing && fieldIsVisible && this.constantPoolStringEquals(attributeNameCpIdx, "Signature")) {
                    String fieldTypeSignature = this.getConstantPoolString(this.readUnsignedShort());
                    this.addFieldTypeDescriptorParts(classInfoUnlinked, fieldTypeSignature);
                } else if ((scanSpec.enableFieldInfo || scanSpec.enableFieldAnnotationIndexing) && (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations"))) {
                    int annotationCount = this.readUnsignedShort();
                    for (int k = 0; k < annotationCount; ++k) {
                        String annotationName = this.readAnnotation();
                        if (scanSpec.enableFieldAnnotationIndexing) {
                            classInfoUnlinked.addFieldAnnotation(annotationName);
                        }
                        if (fieldAnnotationNames == null) continue;
                        fieldAnnotationNames.add(annotationName);
                    }
                } else {
                    this.skip(attributeLength);
                }
                if (!isMatchedFieldName || foundFieldConstValue || log == null) continue;
                boolean reasonFound = false;
                if (!isStaticFinalField) {
                    log.log("Requested static final field match " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameCpIdx) + " is not declared as static final");
                    reasonFound = true;
                }
                if (!isPublicField && !scanSpec.ignoreFieldVisibility) {
                    log.log("Requested static final field match " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameCpIdx) + " is not declared as public, and ignoreFieldVisibility was not set to true before scan");
                    reasonFound = true;
                }
                if (reasonFound) continue;
                log.log("Requested static final field match " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameCpIdx) + " does not have a constant literal initializer value");
            }
            if (!scanSpec.enableFieldInfo || !fieldIsVisible) continue;
            classInfoUnlinked.addFieldInfo(new FieldInfo(fieldName, fieldModifierFlags, fieldTypeDescriptor, fieldConstValue, fieldAnnotationNames));
        }
        int methodCount = this.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            int j;
            int methodModifierFlags = this.readUnsignedShort();
            String methodName = null;
            String methodTypeDescriptor = null;
            if (scanSpec.enableMethodInfo) {
                int methodNameCpIdx = this.readUnsignedShort();
                methodName = this.getConstantPoolString(methodNameCpIdx);
                int methodTypeDescriptorCpIdx = this.readUnsignedShort();
                methodTypeDescriptor = this.getConstantPoolString(methodTypeDescriptorCpIdx);
            } else {
                this.skip(4);
            }
            int attributesCount = this.readUnsignedShort();
            boolean isPublicMethod = (methodModifierFlags & 1) == 1;
            boolean methodIsVisible = isPublicMethod || scanSpec.ignoreMethodVisibility;
            ArrayList<String> methodAnnotationNames = null;
            if (scanSpec.enableMethodInfo && methodIsVisible) {
                methodAnnotationNames = new ArrayList<String>(1);
            }
            if (!methodIsVisible || !scanSpec.enableMethodInfo && !scanSpec.enableMethodAnnotationIndexing) {
                for (j = 0; j < attributesCount; ++j) {
                    this.skip(2);
                    int attributeLength = this.readInt();
                    this.skip(attributeLength);
                }
            } else {
                for (j = 0; j < attributesCount; ++j) {
                    int attributeNameCpIdx = this.readUnsignedShort();
                    int attributeLength = this.readInt();
                    if (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations")) {
                        int annotationCount = this.readUnsignedShort();
                        for (int k = 0; k < annotationCount; ++k) {
                            String annotationName = this.readAnnotation();
                            if (scanSpec.enableMethodAnnotationIndexing) {
                                classInfoUnlinked.addMethodAnnotation(annotationName);
                            }
                            if (methodAnnotationNames == null) continue;
                            methodAnnotationNames.add(annotationName);
                        }
                        continue;
                    }
                    this.skip(attributeLength);
                }
            }
            if (!scanSpec.enableMethodInfo || !methodIsVisible) continue;
            boolean isConstructor = "<init>".equals(methodName);
            classInfoUnlinked.addMethodInfo(new MethodInfo(isConstructor ? className : methodName, methodModifierFlags, methodTypeDescriptor, methodAnnotationNames, isConstructor));
        }
        int attributesCount = this.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            int attributeNameCpIdx = this.readUnsignedShort();
            int attributeLength = this.readInt();
            if (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations")) {
                int annotationCount = this.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    String annotationName = this.readAnnotation();
                    classInfoUnlinked.addAnnotation(annotationName);
                }
                continue;
            }
            this.skip(attributeLength);
        }
        return classInfoUnlinked;
    }
}

