/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.ext.labymod;

import com.github.juliarn.npclib.api.protocol.OutboundPacket;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.ext.labymod.BufferUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class LabyModExtension {
    private static final String EMOTE_ID_PROPERTY = "emote_id";
    private static final String STICKER_ID_PROPERTY = "sticker_id";
    private static final String EMOTE_API_MESSAGE_KEY = "emote_api";
    private static final String STICKER_API_MESSAGE_KEY = "sticker_api";
    private static final String LM_PLUGIN_CHANNEL = "labymod3:main";
    private static final int DEFAULT_BUFFER_ALLOCATION_BYTES = 128;

    private LabyModExtension() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <W, P, I, E> OutboundPacket<W, P, I, E> createEmotePacket(@NotNull PlatformPacketAdapter<W, P, I, E> packetAdapter, int ... emoteIds) {
        return (player, npc) -> {
            JsonArray data = LabyModExtension.createIdJsonData(EMOTE_ID_PROPERTY, npc.profile().uniqueId(), emoteIds);
            byte[] payloadData = LabyModExtension.constructPayloadData(EMOTE_API_MESSAGE_KEY, data.toString());
            packetAdapter.createCustomPayloadPacket(LM_PLUGIN_CHANNEL, payloadData).schedule(player, npc);
        };
    }

    @NotNull
    public static <W, P, I, E> OutboundPacket<W, P, I, E> createStickerPacket(@NotNull PlatformPacketAdapter<W, P, I, E> packetAdapter, int ... stickerIds) {
        return (player, npc) -> {
            JsonArray data = LabyModExtension.createIdJsonData(STICKER_ID_PROPERTY, npc.profile().uniqueId(), stickerIds);
            byte[] payloadData = LabyModExtension.constructPayloadData(STICKER_API_MESSAGE_KEY, data.toString());
            packetAdapter.createCustomPayloadPacket(LM_PLUGIN_CHANNEL, payloadData).schedule(player, npc);
        };
    }

    private static byte[] constructPayloadData(@NotNull String apiMessageKey, @NotNull String data) {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        buffer = BufferUtil.putString(buffer, apiMessageKey);
        buffer = BufferUtil.putString(buffer, data);
        return BufferUtil.extractData(buffer);
    }

    @NotNull
    private static JsonArray createIdJsonData(@NotNull String idProperty, @NotNull UUID npcId, int ... ids) {
        JsonArray array = new JsonArray();
        for (int id : ids) {
            JsonObject object = new JsonObject();
            object.addProperty(idProperty, (Number)id);
            object.addProperty("uuid", npcId.toString());
            array.add((JsonElement)object);
        }
        return array;
    }
}

