/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.ext.labymod;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class BufferUtil {
    private static final int[] VAR_INT_BYTE_LENGTHS = new int[33];

    private BufferUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static ByteBuffer ensureWriteable(@NotNull ByteBuffer buffer, int contentBytes) {
        if (buffer.remaining() >= contentBytes) {
            return buffer;
        }
        int newSize = buffer.capacity() + contentBytes;
        ByteBuffer newBuffer = buffer.isDirect() ? ByteBuffer.allocateDirect(newSize) : ByteBuffer.allocate(newSize);
        buffer.flip();
        return newBuffer.put(buffer);
    }

    @NotNull
    public static ByteBuffer putString(@NotNull ByteBuffer buffer, @NotNull String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        ByteBuffer writeBuffer = BufferUtil.putVarInt(buffer, bytes.length);
        writeBuffer = BufferUtil.putBytes(writeBuffer, bytes);
        return writeBuffer;
    }

    @NotNull
    public static ByteBuffer putBytes(@NotNull ByteBuffer buffer, byte[] bytes) {
        ByteBuffer writeBuffer = BufferUtil.ensureWriteable(buffer, bytes.length);
        return writeBuffer.put(bytes);
    }

    @NotNull
    public static ByteBuffer putVarInt(@NotNull ByteBuffer buffer, int value) {
        int varIntBytes = VAR_INT_BYTE_LENGTHS[Integer.numberOfLeadingZeros(value)];
        ByteBuffer writeBuffer = BufferUtil.ensureWriteable(buffer, varIntBytes);
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                writeBuffer.put((byte)value);
                return writeBuffer;
            }
            writeBuffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static byte[] extractData(@NotNull ByteBuffer buffer) {
        if (buffer.hasArray()) {
            byte[] data = buffer.array();
            return Arrays.copyOfRange(data, 0, buffer.position());
        }
        int prevPos = buffer.position();
        byte[] data = new byte[prevPos];
        buffer.position(0);
        buffer.get(data).position(prevPos);
        return data;
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            BufferUtil.VAR_INT_BYTE_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        BufferUtil.VAR_INT_BYTE_LENGTHS[32] = 1;
    }
}

