/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.profile;

import com.github.juliarn.npclib.api.profile.DefaultResolvedProfile;
import com.github.juliarn.npclib.api.profile.DefaultUnresolvedProfile;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Profile {
    @NotNull
    public static Unresolved unresolved(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        return new DefaultUnresolvedProfile(name, null);
    }

    @NotNull
    public static Unresolved unresolved(@NotNull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        return new DefaultUnresolvedProfile(null, uniqueId);
    }

    @NotNull
    public static Resolved resolved(@NotNull String name, @NotNull UUID uniqueId) {
        return Profile.resolved(name, uniqueId, Collections.emptySet());
    }

    @NotNull
    public static Resolved resolved(@NotNull String name, @NotNull UUID uniqueId, @NotNull Set<ProfileProperty> properties) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(uniqueId, "unique id");
        Objects.requireNonNull(properties, "properties");
        return new DefaultResolvedProfile(name, uniqueId, properties);
    }

    public boolean resolved();

    @Nullable
    public UUID uniqueId();

    @Nullable
    public String name();

    @NotNull
    public Set<ProfileProperty> properties();

    public static interface Resolved
    extends Profile {
        @Override
        @NotNull
        public UUID uniqueId();

        @Override
        @NotNull
        public String name();

        @NotNull
        public Resolved withName(@NotNull String var1);

        @NotNull
        public Resolved withUniqueId(@NotNull UUID var1);

        @NotNull
        public Resolved withoutProperties();

        @NotNull
        public Resolved withProperty(@NotNull ProfileProperty var1);

        @NotNull
        public Resolved withProperties(@NotNull Set<ProfileProperty> var1);

        @Override
        default public boolean resolved() {
            return true;
        }
    }

    public static interface Unresolved
    extends Profile {
        @Override
        default public boolean resolved() {
            return false;
        }

        @Override
        @NotNull
        default public Set<ProfileProperty> properties() {
            return Collections.emptySet();
        }
    }
}

