/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.platform;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.PlatformTaskManager;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.PlatformWorldAccessor;
import com.github.juliarn.npclib.api.event.manager.NpcEventManager;
import com.github.juliarn.npclib.api.log.PlatformLogger;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.common.npc.CommonNpcBuilder;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonPlatform<W, P, I, E>
implements Platform<W, P, I, E> {
    protected final E extension;
    protected final boolean debug;
    protected final PlatformLogger logger;
    protected final NpcEventManager eventManager;
    protected final NpcTracker<W, P, I, E> npcTracker;
    protected final ProfileResolver profileResolver;
    protected final PlatformTaskManager taskManager;
    protected final NpcActionController actionController;
    protected final PlatformVersionAccessor versionAccessor;
    protected final PlatformWorldAccessor<W> worldAccessor;
    protected final PlatformPacketAdapter<W, P, I, E> packetAdapter;

    public CommonPlatform(boolean debug, @NotNull E extension, @NotNull PlatformLogger logger, @NotNull NpcTracker<W, P, I, E> npcTracker, @NotNull ProfileResolver profileResolver, @NotNull PlatformTaskManager taskManager, @Nullable NpcActionController actionController, @NotNull PlatformVersionAccessor versionAccessor, @NotNull NpcEventManager eventManager, @NotNull PlatformWorldAccessor<W> worldAccessor, @NotNull PlatformPacketAdapter<W, P, I, E> packetAdapter) {
        this.debug = debug;
        this.logger = logger;
        this.extension = extension;
        this.npcTracker = npcTracker;
        this.profileResolver = profileResolver;
        this.taskManager = taskManager;
        this.actionController = actionController;
        this.versionAccessor = versionAccessor;
        this.eventManager = eventManager;
        this.worldAccessor = worldAccessor;
        this.packetAdapter = packetAdapter;
        this.packetAdapter.initialize((Platform)this);
    }

    public boolean debug() {
        return this.debug;
    }

    @NotNull
    public E extension() {
        return this.extension;
    }

    @NotNull
    public PlatformLogger logger() {
        return this.logger;
    }

    @NotNull
    public NpcTracker<W, P, I, E> npcTracker() {
        return this.npcTracker;
    }

    @NotNull
    public ProfileResolver profileResolver() {
        return this.profileResolver;
    }

    @NotNull
    public PlatformTaskManager taskManager() {
        return this.taskManager;
    }

    @NotNull
    public Npc.Builder<W, P, I, E> newNpcBuilder() {
        return new CommonNpcBuilder(this);
    }

    @NotNull
    public PlatformVersionAccessor versionAccessor() {
        return this.versionAccessor;
    }

    @NotNull
    public NpcEventManager eventManager() {
        return this.eventManager;
    }

    @NotNull
    public PlatformWorldAccessor<W> worldAccessor() {
        return this.worldAccessor;
    }

    @NotNull
    public PlatformPacketAdapter<W, P, I, E> packetFactory() {
        return this.packetAdapter;
    }

    @NotNull
    public Optional<NpcActionController> actionController() {
        return Optional.ofNullable(this.actionController);
    }
}

