/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.flag;

import com.github.juliarn.npclib.api.flag.NpcFlag;
import com.github.juliarn.npclib.api.flag.NpcFlaggedObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonNpcFlaggedObject
implements NpcFlaggedObject {
    protected final Map<NpcFlag<?>, Optional<?>> flags;

    public CommonNpcFlaggedObject(@NotNull Map<NpcFlag<?>, Optional<?>> flags) {
        this.flags = new HashMap(flags);
    }

    public <T> void flagValue(@NotNull NpcFlag<T> flag, @Nullable T newValue) {
        this.flags.put(flag, Optional.ofNullable(newValue));
    }

    @NotNull
    public <T> Optional<T> flagValue(@NotNull NpcFlag<T> flag) {
        return this.flags.getOrDefault(flag, Optional.empty());
    }
}

