/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.task;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class AsyncTaskThreadFactory
implements ThreadFactory {
    private final String threadNameFormat;
    private final ThreadGroup parentThreadGroup;
    private final AtomicLong createdThreadCount = new AtomicLong(0L);

    private AsyncTaskThreadFactory(@NotNull String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
        this.parentThreadGroup = Thread.currentThread().getThreadGroup();
    }

    @NotNull
    public static ThreadFactory create(@NotNull String threadNameFormat) {
        Objects.requireNonNull(threadNameFormat, "threadNameFormat");
        return new AsyncTaskThreadFactory(threadNameFormat);
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable runnable) {
        String threadName = String.format(this.threadNameFormat, this.createdThreadCount.incrementAndGet());
        Thread thread = new Thread(this.parentThreadGroup, runnable, threadName, 0L);
        thread.setDaemon(true);
        thread.setPriority(5);
        return thread;
    }
}

