/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.ShowNpcEvent;
import com.github.juliarn.npclib.api.event.manager.NpcEventManager;
import com.github.juliarn.npclib.api.flag.NpcFlag;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.PlayerInfoAction;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.bukkit.util.BukkitPlatformUtil;
import com.github.juliarn.npclib.common.CommonNpcActionController;
import com.github.juliarn.npclib.common.flag.CommonNpcFlaggedBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BukkitActionController
extends CommonNpcActionController
implements Listener {
    private final NpcTracker<World, Player, ItemStack, Plugin> npcTracker;
    private final int spawnDistance;
    private final int imitateDistance;

    public BukkitActionController(@NotNull Map<NpcFlag<?>, Optional<?>> flags, @NotNull Plugin plugin, @NotNull NpcEventManager eventManager, @NotNull PlatformVersionAccessor versionAccessor, @NotNull NpcTracker<World, Player, ItemStack, Plugin> tracker) {
        super(flags);
        this.npcTracker = tracker;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        if (!versionAccessor.atLeast(1, 19, 3)) {
            eventManager.registerEventHandler(ShowNpcEvent.Post.class, event -> {
                int tabRemovalTicks = (Integer)this.flagValueOrDefault(TAB_REMOVAL_TICKS);
                plugin.getServer().getScheduler().runTaskLaterAsynchronously(plugin, () -> {
                    Player player = (Player)event.player();
                    event.npc().platform().packetFactory().createPlayerInfoPacket(PlayerInfoAction.REMOVE_PLAYER).schedule((Object)player, event.npc());
                }, (long)tabRemovalTicks);
            });
        }
        int spawnDistance = (Integer)this.flagValueOrDefault(SPAWN_DISTANCE);
        this.spawnDistance = spawnDistance * spawnDistance;
        int imitateDistance = (Integer)this.flagValueOrDefault(IMITATE_DISTANCE);
        this.imitateDistance = imitateDistance * imitateDistance;
        if (((Boolean)this.flagValueOrDefault(NpcActionController.AUTO_SYNC_POSITION_ON_SPAWN)).booleanValue()) {
            eventManager.registerEventHandler(ShowNpcEvent.Post.class, event -> {
                Player player = (Player)event.player();
                Location to = player.getLocation();
                double distance = BukkitPlatformUtil.distance(event.npc(), to);
                if (distance <= (double)this.imitateDistance && ((Boolean)event.npc().flagValueOrDefault(Npc.LOOK_AT_PLAYER)).booleanValue()) {
                    event.npc().lookAt(BukkitPlatformUtil.positionFromBukkitLegacy(to)).schedule((Object)player);
                }
            });
        }
    }

    @NotNull
    static NpcActionController.Builder actionControllerBuilder(@NotNull Plugin plugin, @NotNull NpcEventManager eventManager, @NotNull PlatformVersionAccessor versionAccessor, @NotNull NpcTracker<World, Player, ItemStack, Plugin> npcTracker) {
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(eventManager, "eventManager");
        Objects.requireNonNull(npcTracker, "npcTracker");
        Objects.requireNonNull(versionAccessor, "versionAccessor");
        return new BukkitActionControllerBuilder(plugin, eventManager, versionAccessor, npcTracker);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void handleMove(@NotNull PlayerMoveEvent event) {
        boolean changedPosition;
        Location to = event.getTo();
        Location from = event.getFrom();
        boolean changedWorld = !Objects.equals(from.getWorld(), to.getWorld());
        boolean changedOrientation = from.getYaw() != to.getYaw() || from.getPitch() != to.getPitch();
        boolean bl = changedPosition = from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ();
        if (changedPosition || changedOrientation || changedWorld) {
            Player player = event.getPlayer();
            for (Npc npc : this.npcTracker.trackedNpcs()) {
                Position pos = npc.position();
                if (!((World)npc.world()).equals((Object)player.getWorld()) || !((World)npc.world()).isChunkLoaded(pos.chunkX(), pos.chunkZ())) {
                    npc.stopTrackingPlayer((Object)player);
                    continue;
                }
                double distance = BukkitPlatformUtil.distance(npc, to);
                if (distance > (double)this.spawnDistance) {
                    npc.stopTrackingPlayer((Object)player);
                    continue;
                }
                npc.trackPlayer((Object)player);
                if (!changedPosition || !npc.tracksPlayer((Object)player) || !(distance <= (double)this.imitateDistance) || !((Boolean)npc.flagValueOrDefault(Npc.LOOK_AT_PLAYER)).booleanValue()) continue;
                npc.lookAt(BukkitPlatformUtil.positionFromBukkitLegacy(to)).schedule((Object)player);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void handleSneak(@NotNull PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        for (Npc npc : this.npcTracker.trackedNpcs()) {
            double distance = BukkitPlatformUtil.distance(npc, player.getLocation());
            if (!Objects.equals(player.getWorld(), npc.world()) || !npc.tracksPlayer((Object)player) || !(distance <= (double)this.imitateDistance) || !((Boolean)npc.flagValueOrDefault(Npc.SNEAK_WHEN_PLAYER_SNEAKS)).booleanValue()) continue;
            npc.platform().packetFactory().createEntityMetaPacket(EntityMetadataFactory.sneakingMetaFactory(), (Object)event.isSneaking()).schedule((Object)player, npc);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void handleLeftClick(@NotNull PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            for (Npc npc : this.npcTracker.trackedNpcs()) {
                double distance = BukkitPlatformUtil.distance(npc, player.getLocation());
                if (!Objects.equals(player.getWorld(), npc.world()) || !npc.tracksPlayer((Object)player) || !(distance <= (double)this.imitateDistance) || !((Boolean)npc.flagValueOrDefault(Npc.HIT_WHEN_PLAYER_HITS)).booleanValue()) continue;
                npc.platform().packetFactory().createAnimationPacket(EntityAnimation.SWING_MAIN_ARM).schedule((Object)player, npc);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void handleQuit(@NotNull PlayerQuitEvent event) {
        for (Npc npc : this.npcTracker.trackedNpcs()) {
            npc.stopTrackingPlayer((Object)event.getPlayer());
        }
    }

    private static final class BukkitActionControllerBuilder
    extends CommonNpcFlaggedBuilder<NpcActionController.Builder>
    implements NpcActionController.Builder {
        private final Plugin plugin;
        private final NpcEventManager eventManager;
        private final PlatformVersionAccessor versionAccessor;
        private final NpcTracker<World, Player, ItemStack, Plugin> npcTracker;

        public BukkitActionControllerBuilder(@NotNull Plugin plugin, @NotNull NpcEventManager eventManager, @NotNull PlatformVersionAccessor versionAccessor, @NotNull NpcTracker<World, Player, ItemStack, Plugin> npcTracker) {
            this.plugin = plugin;
            this.eventManager = eventManager;
            this.npcTracker = npcTracker;
            this.versionAccessor = versionAccessor;
        }

        @NotNull
        public NpcActionController build() {
            return new BukkitActionController(this.flags, this.plugin, this.eventManager, this.versionAccessor, this.npcTracker);
        }
    }
}

