/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.manager.player;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.player.PlayerManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.protocol.ProtocolManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.channel.ChannelHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.User;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.PlayerPingAccessorModern;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.SpigotReflectionUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.protocolsupport.ProtocolSupportUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.viaversion.ViaVersionUtil;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerManagerImpl
implements PlayerManager {
    @Override
    public int getPing(@NotNull Object player) {
        if (SpigotReflectionUtil.V_1_17_OR_HIGHER) {
            return PlayerPingAccessorModern.getPing((Player)player);
        }
        return SpigotReflectionUtil.getPlayerPingLegacy((Player)player);
    }

    @Override
    @NotNull
    public ClientVersion getClientVersion(@NotNull Object p) {
        Player player = (Player)p;
        User user = this.getUser(player);
        if (user == null) {
            return ClientVersion.UNKNOWN;
        }
        if (user.getClientVersion() == null) {
            int protocolVersion;
            if (ProtocolSupportUtil.isAvailable()) {
                protocolVersion = ProtocolSupportUtil.getProtocolVersion(user.getAddress());
                PacketEvents.getAPI().getLogManager().debug("Requested ProtocolSupport for user " + user.getName() + "'s protocol version. Protocol version: " + protocolVersion);
            } else if (ViaVersionUtil.isAvailable()) {
                protocolVersion = ViaVersionUtil.getProtocolVersion(player);
                PacketEvents.getAPI().getLogManager().debug("Requested ViaVersion for " + player.getName() + "'s protocol version. Protocol version: " + protocolVersion);
            } else {
                protocolVersion = PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion();
                PacketEvents.getAPI().getLogManager().debug("No protocol translation plugins are available. We will assume " + user.getName() + "'s protocol version is the same as the server's protocol version. Protocol version: " + protocolVersion);
            }
            ClientVersion version = ClientVersion.getById(protocolVersion);
            user.setClientVersion(version);
        }
        return user.getClientVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getChannel(@NotNull Object player) {
        UUID uuid = ((Player)player).getUniqueId();
        Object channel = PacketEvents.getAPI().getProtocolManager().getChannel(uuid);
        if (channel == null && (channel = SpigotReflectionUtil.getChannel((Player)player)) != null) {
            Object object = channel;
            synchronized (object) {
                if (ChannelHelper.isOpen(channel)) {
                    ProtocolManager.CHANNELS.put(uuid, channel);
                }
            }
        }
        return channel;
    }

    @Override
    public User getUser(@NotNull Object player) {
        Player p = (Player)player;
        Object channel = this.getChannel(p);
        if (channel == null) {
            return null;
        }
        return PacketEvents.getAPI().getProtocolManager().getUser(channel);
    }
}

