/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.handlers;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.exception.PacketProcessException;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.ConnectionState;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.User;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.ExceptionUtil;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.PacketEventsImplHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.connection.ServerConnectionInitializer;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.handlers.PacketEventsEncoder;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.SpigotReflectionUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.folia.FoliaScheduler;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public Player player;
    public boolean hasBeenRelocated;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    public PacketEventsDecoder(PacketEventsDecoder decoder) {
        this.user = decoder.user;
        this.player = decoder.player;
        this.hasBeenRelocated = decoder.hasBeenRelocated;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
        Object buffer = PacketEventsImplHelper.handleServerBoundPacket(ctx.channel(), this.user, this.player, input, true);
        out.add(ByteBufHelper.retain(buffer));
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.isReadable()) {
            this.read(ctx, buffer, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (ExceptionUtil.isException(cause, PacketProcessException.class) && !SpigotReflectionUtil.isMinecraftServerInstanceDebugging() && this.user != null && this.user.getDecoderState() != ConnectionState.HANDSHAKING) {
            if (PacketEvents.getAPI().getSettings().isFullStackTraceEnabled()) {
                cause.printStackTrace();
            } else {
                PacketEvents.getAPI().getLogManager().warn(cause.getMessage());
            }
            if (PacketEvents.getAPI().getSettings().isKickOnPacketExceptionEnabled()) {
                try {
                    this.user.sendPacket(new WrapperPlayServerDisconnect(Component.text("Invalid packet")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.user.closeConnection();
                if (this.player != null) {
                    FoliaScheduler.getEntityScheduler().runDelayed((Entity)this.player, (Plugin)PacketEvents.getAPI().getPlugin(), o -> this.player.kickPlayer("Invalid packet"), null, 1L);
                }
                PacketEvents.getAPI().getLogManager().warn("Disconnected " + this.user.getProfile().getName() + " due to invalid packet!");
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (PacketEventsEncoder.COMPRESSION_ENABLED_EVENT == null || event != PacketEventsEncoder.COMPRESSION_ENABLED_EVENT) {
            super.userEventTriggered(ctx, event);
            return;
        }
        ServerConnectionInitializer.relocateHandlers(ctx.channel(), this, this.user);
        super.userEventTriggered(ctx, event);
    }
}

