/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketListenerPriority;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.SimplePacketListenerAbstract;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.UserConnectEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.UserDisconnectEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.UserLoginEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.simple.PacketConfigReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.simple.PacketConfigSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.simple.PacketLoginSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.simple.PacketPlaySendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.states.type.StateTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.TimeStampMode;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.SpigotConversionUtil;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PacketEventsPlugin
extends JavaPlugin {
    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(PacketListenerPriority.HIGH){

            @Override
            public void onPacketLoginSend(PacketLoginSendEvent event) {
            }

            @Override
            public void onPacketConfigReceive(PacketConfigReceiveEvent event) {
            }

            @Override
            public void onPacketConfigSend(PacketConfigSendEvent event) {
            }

            @Override
            public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
                WrapperPlayClientInteractEntity interaction;
                if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY && (interaction = new WrapperPlayClientInteractEntity(event)).getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                    Player player = (Player)event.getPlayer();
                    WrapperPlayServerBlockChange blockChange = new WrapperPlayServerBlockChange(SpigotConversionUtil.fromBukkitLocation(player.getLocation()).getPosition().toVector3i().subtract(0, 1, 0), StateTypes.COAL_BLOCK.createBlockState().getGlobalId());
                    event.getUser().sendPacket(blockChange);
                }
            }

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
                    WrapperPlayServerBlockChange bc = new WrapperPlayServerBlockChange(event);
                    ((Player)event.getPlayer()).sendMessage("Type: " + bc.getBlockState().getType().getName());
                } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
                    WrapperPlayServerSystemChatMessage packet = new WrapperPlayServerSystemChatMessage(event);
                    System.out.println("System chat message: " + AdventureSerializer.asVanilla(packet.getMessage()));
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }
}

