/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.attribute.Attribute;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.attribute.Attributes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public class WrapperPlayServerUpdateAttributes
extends PacketWrapper<WrapperPlayServerUpdateAttributes> {
    private static final List<Map.Entry<String, Attribute>> PRE_1_16_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(new AbstractMap.SimpleEntry<String, Attribute>("generic.maxHealth", Attributes.GENERIC_MAX_HEALTH), new AbstractMap.SimpleEntry<String, Attribute>("Max Health", Attributes.GENERIC_MAX_HEALTH), new AbstractMap.SimpleEntry<String, Attribute>("zombie.spawnReinforcements", Attributes.ZOMBIE_SPAWN_REINFORCEMENTS), new AbstractMap.SimpleEntry<String, Attribute>("Spawn Reinforcements Chance", Attributes.ZOMBIE_SPAWN_REINFORCEMENTS), new AbstractMap.SimpleEntry<String, Attribute>("horse.jumpStrength", Attributes.HORSE_JUMP_STRENGTH), new AbstractMap.SimpleEntry<String, Attribute>("Jump Strength", Attributes.HORSE_JUMP_STRENGTH), new AbstractMap.SimpleEntry<String, Attribute>("generic.followRange", Attributes.GENERIC_FOLLOW_RANGE), new AbstractMap.SimpleEntry<String, Attribute>("Follow Range", Attributes.GENERIC_FOLLOW_RANGE), new AbstractMap.SimpleEntry<String, Attribute>("generic.knockbackResistance", Attributes.GENERIC_KNOCKBACK_RESISTANCE), new AbstractMap.SimpleEntry<String, Attribute>("Knockback Resistance", Attributes.GENERIC_KNOCKBACK_RESISTANCE), new AbstractMap.SimpleEntry<String, Attribute>("generic.movementSpeed", Attributes.GENERIC_MOVEMENT_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("Movement Speed", Attributes.GENERIC_MOVEMENT_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("generic.flyingSpeed", Attributes.GENERIC_FLYING_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("Flying Speed", Attributes.GENERIC_FLYING_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("generic.attackDamage", Attributes.GENERIC_ATTACK_DAMAGE), new AbstractMap.SimpleEntry<String, Attribute>("generic.attackKnockback", Attributes.GENERIC_ATTACK_KNOCKBACK), new AbstractMap.SimpleEntry<String, Attribute>("generic.attackSpeed", Attributes.GENERIC_ATTACK_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("generic.armorToughness", Attributes.GENERIC_ARMOR_TOUGHNESS), new AbstractMap.SimpleEntry<String, Attribute>("generic.armor", Attributes.GENERIC_ARMOR), new AbstractMap.SimpleEntry<String, Attribute>("generic.luck", Attributes.GENERIC_LUCK)));
    private static final Map<String, Attribute> PRE_1_16_ATTRIBUTES_MAP = PRE_1_16_ATTRIBUTES.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Map<Attribute, String> PRE_1_16_ATTRIBUTES_RMAP = PRE_1_16_ATTRIBUTES.stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (s1, s2) -> s1));
    private int entityID;
    private List<Property> properties;

    public WrapperPlayServerUpdateAttributes(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerUpdateAttributes(int entityID, List<Property> properties) {
        super(PacketType.Play.Server.UPDATE_ATTRIBUTES);
        this.entityID = entityID;
        this.properties = properties;
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion == ServerVersion.V_1_7_10 ? this.readInt() : this.readVarInt();
        int propertyCount = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.properties = new ArrayList<Property>(propertyCount);
        for (int i = 0; i < propertyCount; ++i) {
            Attribute attribute;
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                attribute = this.readMappedEntity(Attributes::getById);
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
                attribute = Attributes.getByName(this.readIdentifier().toString());
            } else {
                String attributeName = this.readString(64);
                attribute = PRE_1_16_ATTRIBUTES_MAP.get(attributeName);
                if (attribute == null) {
                    throw new IllegalStateException("Can't find attribute for name " + attributeName + " (version: " + this.serverVersion.name() + ")");
                }
            }
            double value = this.readDouble();
            int modifiersLength = this.serverVersion == ServerVersion.V_1_7_10 ? this.readShort() : this.readVarInt();
            ArrayList<PropertyModifier> modifiers = new ArrayList<PropertyModifier>(modifiersLength);
            for (int j = 0; j < modifiersLength; ++j) {
                UUID uuid;
                ResourceLocation name;
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
                    name = this.readIdentifier();
                    uuid = PropertyModifier.generateSemiUniqueId(name);
                } else {
                    uuid = this.readUUID();
                    name = new ResourceLocation(uuid.toString());
                }
                double amount = this.readDouble();
                byte operationIndex = this.readByte();
                PropertyModifier.Operation operation = PropertyModifier.Operation.VALUES[operationIndex];
                modifiers.add(new PropertyModifier(name, uuid, amount, operation));
            }
            this.properties.add(new Property(attribute, value, modifiers));
        }
    }

    @Override
    public void write() {
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.properties.size());
        } else {
            this.writeInt(this.properties.size());
        }
        for (Property property : this.properties) {
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                this.writeVarInt(property.getAttribute().getId(this.serverVersion.toClientVersion()));
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
                this.writeIdentifier(property.getAttribute().getName());
            } else {
                this.writeString(PRE_1_16_ATTRIBUTES_RMAP.get(property.getAttribute()));
            }
            this.writeDouble(property.value);
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeShort(property.modifiers.size());
            } else {
                this.writeVarInt(property.modifiers.size());
            }
            for (PropertyModifier modifier : property.modifiers) {
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
                    this.writeIdentifier(modifier.name);
                } else {
                    this.writeUUID(modifier.uuid);
                }
                this.writeDouble(modifier.amount);
                this.writeByte(modifier.operation.ordinal());
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerUpdateAttributes wrapper) {
        this.entityID = wrapper.entityID;
        this.properties = wrapper.properties;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public static class PropertyModifier {
        private ResourceLocation name;
        private UUID uuid;
        private double amount;
        private Operation operation;

        public PropertyModifier(UUID uuid, double amount, Operation operation) {
            this(new ResourceLocation(uuid.toString()), uuid, amount, operation);
        }

        public PropertyModifier(ResourceLocation name, double amount, Operation operation) {
            this(name, PropertyModifier.generateSemiUniqueId(name), amount, operation);
        }

        public PropertyModifier(ResourceLocation name, UUID uuid, double amount, Operation operation) {
            this.name = name;
            this.uuid = uuid;
            this.amount = amount;
            this.operation = operation;
        }

        private static UUID generateSemiUniqueId(ResourceLocation name) {
            String extendedName = "packetevents_" + name.toString();
            return UUID.nameUUIDFromBytes(extendedName.getBytes(StandardCharsets.UTF_8));
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public void setName(ResourceLocation name) {
            this.name = name;
            this.uuid = PropertyModifier.generateSemiUniqueId(name);
        }

        @ApiStatus.Obsolete
        public UUID getUUID() {
            return this.uuid;
        }

        @ApiStatus.Obsolete
        public void setUUID(UUID uuid) {
            this.name = new ResourceLocation(uuid.toString());
            this.uuid = uuid;
        }

        public void setNameAndUUID(ResourceLocation name, UUID uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public static enum Operation {
            ADDITION,
            MULTIPLY_BASE,
            MULTIPLY_TOTAL;

            public static final Operation[] VALUES;

            static {
                VALUES = Operation.values();
            }
        }
    }

    public static class Property {
        private Attribute attribute;
        private double value;
        private List<PropertyModifier> modifiers;

        @Deprecated
        public Property(String key, double value, List<PropertyModifier> modifiers) {
            this(Attributes.getByName(key), value, modifiers);
        }

        public Property(Attribute attribute, double value, List<PropertyModifier> modifiers) {
            this.attribute = attribute;
            this.value = value;
            this.modifiers = modifiers;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
        }

        @Deprecated
        public String getKey() {
            return this.getAttribute().getName().toString();
        }

        @Deprecated
        public void setKey(String key) {
            this.setAttribute(Attributes.getByName(key));
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public List<PropertyModifier> getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(List<PropertyModifier> modifiers) {
            this.modifiers = modifiers;
        }
    }
}

