/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.ScoreFormat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.score.ScoreFormatTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.LegacyFormat;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.adventure.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerScoreboardObjective
extends PacketWrapper<WrapperPlayServerScoreboardObjective> {
    private String name;
    private ObjectiveMode mode;
    private Component displayName;
    @Nullable
    private RenderType renderType;
    @Nullable
    private ScoreFormat scoreFormat;

    public WrapperPlayServerScoreboardObjective(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerScoreboardObjective(String name, ObjectiveMode mode, Component displayName, @Nullable RenderType renderType) {
        this(name, mode, displayName, renderType, null);
    }

    public WrapperPlayServerScoreboardObjective(String name, ObjectiveMode mode, Component displayName, @Nullable RenderType renderType, @Nullable ScoreFormat scoreFormat) {
        super(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        this.name = name;
        this.mode = mode;
        this.displayName = displayName;
        this.renderType = renderType;
        this.scoreFormat = scoreFormat;
    }

    @Override
    public void read() {
        this.name = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18) ? this.readString() : this.readString(16);
        this.mode = ObjectiveMode.getById(this.readByte());
        if (this.mode != ObjectiveMode.CREATE && this.mode != ObjectiveMode.UPDATE) {
            this.displayName = Component.empty();
            this.renderType = RenderType.INTEGER;
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                this.scoreFormat = null;
            }
        } else if (this.serverVersion.isOlderThan(ServerVersion.V_1_13)) {
            this.displayName = AdventureSerializer.fromLegacyFormat(this.readString(32));
            this.renderType = RenderType.getByName(this.readString());
        } else {
            this.displayName = this.readComponent();
            this.renderType = RenderType.getById(this.readVarInt());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                this.scoreFormat = (ScoreFormat)this.readOptional(ScoreFormatTypes::read);
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.writeString(this.name);
        } else {
            this.writeString(this.name, 16);
        }
        this.writeByte((byte)this.mode.ordinal());
        if (this.mode == ObjectiveMode.CREATE || this.mode == ObjectiveMode.UPDATE) {
            if (this.serverVersion.isOlderThan(ServerVersion.V_1_13)) {
                this.writeString(LegacyFormat.trimLegacyFormat(AdventureSerializer.asVanilla(this.displayName), 32));
                if (this.renderType != null) {
                    this.writeString(this.renderType.name().toLowerCase());
                } else {
                    this.writeString(RenderType.INTEGER.name().toLowerCase());
                }
            } else {
                this.writeComponent(this.displayName);
                if (this.renderType != null) {
                    this.writeVarInt(this.renderType.ordinal());
                } else {
                    this.writeVarInt(RenderType.INTEGER.ordinal());
                }
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                    this.writeOptional(this.scoreFormat, ScoreFormatTypes::write);
                }
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerScoreboardObjective wrapper) {
        this.name = wrapper.name;
        this.mode = wrapper.mode;
        this.displayName = wrapper.displayName;
        this.renderType = wrapper.renderType;
        this.scoreFormat = wrapper.scoreFormat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ObjectiveMode getMode() {
        return this.mode;
    }

    public void setMode(ObjectiveMode mode) {
        this.mode = mode;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(@Nullable RenderType renderType) {
        this.renderType = renderType;
    }

    @Nullable
    public ScoreFormat getScoreFormat() {
        return this.scoreFormat;
    }

    public void setScoreFormat(@Nullable ScoreFormat scoreFormat) {
        this.scoreFormat = scoreFormat;
    }

    public static enum ObjectiveMode {
        CREATE,
        REMOVE,
        UPDATE;

        private static final ObjectiveMode[] VALUES;

        @Nullable
        public static ObjectiveMode getByName(String name) {
            for (ObjectiveMode mode : VALUES) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return null;
        }

        public static ObjectiveMode getById(int id) {
            return VALUES[id];
        }

        static {
            VALUES = ObjectiveMode.values();
        }
    }

    public static enum RenderType {
        INTEGER,
        HEARTS;

        private static final RenderType[] VALUES;

        @Nullable
        public static RenderType getByName(String name) {
            for (RenderType display : VALUES) {
                if (!display.name().equalsIgnoreCase(name)) continue;
                return display;
            }
            return null;
        }

        @Nullable
        public static RenderType getById(int id) {
            return VALUES[id];
        }

        static {
            VALUES = RenderType.values();
        }
    }
}

