/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.InteractionHand;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientUseItem
extends PacketWrapper<WrapperPlayClientUseItem> {
    private InteractionHand hand;
    private int sequence;
    private float yaw;
    private float pitch;

    public WrapperPlayClientUseItem(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientUseItem(InteractionHand hand) {
        this(hand, 0);
    }

    public WrapperPlayClientUseItem(InteractionHand hand, int sequence) {
        this(hand, sequence, 0.0f, 0.0f);
    }

    public WrapperPlayClientUseItem(InteractionHand hand, int sequence, float yaw, float pitch) {
        super(PacketType.Play.Client.USE_ITEM);
        this.hand = hand;
        this.sequence = sequence;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    public void read() {
        this.hand = InteractionHand.getById(this.readVarInt());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.sequence = this.readVarInt();
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
                this.yaw = this.readFloat();
                this.pitch = this.readFloat();
            }
        }
    }

    @Override
    public void write() {
        this.writeVarInt(this.hand.getId());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeVarInt(this.sequence);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
                this.writeFloat(this.yaw);
                this.writeFloat(this.pitch);
            }
        }
    }

    @Override
    public void copy(WrapperPlayClientUseItem packet) {
        this.hand = packet.hand;
        this.sequence = packet.sequence;
        this.yaw = packet.yaw;
        this.pitch = packet.pitch;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public void setHand(InteractionHand hand) {
        this.hand = hand;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }
}

